/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.repository.Repository;
import org.netbeans.modules.mercurial.ui.repository.RepositoryConnection;
import org.netbeans.modules.mercurial.ui.wizards.CloneRepositoryPanel;
import org.netbeans.modules.mercurial.ui.wizards.WizardStepProgressSupport;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CloneRepositoryWizardPanel
implements WizardDescriptor.AsynchronousValidatingPanel,
PropertyChangeListener {
    private CloneRepositoryPanel component;
    private Repository repository;
    private int repositoryModeMask;
    private boolean valid;
    private String errorMessage;
    private WizardStepProgressSupport support;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public Component getComponent() {
        if (this.component == null) {
            this.component = new CloneRepositoryPanel();
            if (this.repository == null) {
                this.repositoryModeMask = this.repositoryModeMask | 2 | 4 | 0x20 | 0x40;
                String string = NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"CTL_Repository_Location");
                this.repository = new Repository(this.repositoryModeMask, string, false);
                this.repository.addPropertyChangeListener(this);
                CloneRepositoryPanel cloneRepositoryPanel = this.component;
                cloneRepositoryPanel.repositoryPanel.setLayout(new BorderLayout());
                cloneRepositoryPanel.repositoryPanel.add(this.repository.getPanel());
                this.valid();
            }
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(CloneRepositoryWizardPanel.class);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("valid")) {
            if (this.repository.isValid()) {
                this.valid(this.repository.getMessage());
            } else {
                this.invalid(this.repository.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object);
        }
    }

    protected final void valid() {
        this.setValid(true, null);
    }

    protected final void valid(String string) {
        this.setValid(true, string);
    }

    protected final void invalid(String string) {
        this.setValid(false, string);
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    private void setValid(boolean bl, String string) {
        boolean bl2 = this.valid != bl;
        boolean bl3 = string != null && !string.equals(this.errorMessage);
        this.valid = bl;
        this.errorMessage = string;
        if (bl2 |= bl3) {
            this.fireChangeEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateBeforeNext() {
        try {
            this.support = new RepositoryStepProgressSupport(this.component.progressPanel);
            String string = this.getUrl();
            this.support.setRepositoryRoot(string);
            RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(string);
            RequestProcessor.Task task = this.support.start(requestProcessor, string, NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"BK2012"));
            task.waitFinished();
            Object var5_4 = null;
            this.support = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.support = null;
            throw throwable;
        }
    }

    public final void validate() throws WizardValidationException {
        this.validateBeforeNext();
        if (!this.isValid() || this.errorMessage != null) {
            throw new WizardValidationException((JComponent)this.component, this.errorMessage, this.errorMessage);
        }
    }

    public void readSettings(Object object) {
    }

    public void storeSettings(Object object) {
        if (object instanceof WizardDescriptor) {
            ((WizardDescriptor)object).putProperty("repository", (Object)this.repository.getSelectedRC().getUrl());
            ((WizardDescriptor)object).putProperty("username", (Object)this.repository.getSelectedRC().getUsername());
            ((WizardDescriptor)object).putProperty("password", (Object)this.repository.getSelectedRC().getPassword());
        }
    }

    public void prepareValidation() {
    }

    private String getUrl() {
        return this.getSelectedRepositoryConnection().getUrl();
    }

    private void storeHistory() {
        RepositoryConnection repositoryConnection = this.getSelectedRepositoryConnection();
        if (repositoryConnection != null) {
            HgModuleConfig.getDefault().insertRecentUrl(repositoryConnection);
        }
    }

    private RepositoryConnection getSelectedRepositoryConnection() {
        try {
            return this.repository.getSelectedRC();
        }
        catch (Exception exception) {
            this.invalid(exception.getLocalizedMessage());
            return null;
        }
    }

    public void stop() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    private class RepositoryStepProgressSupport
    extends WizardStepProgressSupport {
        public RepositoryStepProgressSupport(JPanel jPanel) {
            super(jPanel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void perform() {
            String string;
            block28: {
                block30: {
                    block29: {
                        RepositoryConnection repositoryConnection = CloneRepositoryWizardPanel.this.getSelectedRepositoryConnection();
                        if (repositoryConnection == null) {
                            return;
                        }
                        string = null;
                        try {
                            try {
                                boolean bl;
                                URL uRL;
                                HttpURLConnection httpURLConnection;
                                CloneRepositoryWizardPanel.this.invalid(null);
                                repositoryConnection.getHgUrl();
                                String string2 = repositoryConnection.getUrl();
                                URI uRI = new URI(string2);
                                String string3 = uRI.getScheme();
                                if (string3.equals("file")) {
                                    File file = new File(string2.substring("file://".length()));
                                    if (file.exists() && file.canRead()) break block28;
                                    string = NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"MSG_Progress_Clone_CannotAccess_Err");
                                    Object var11_13 = null;
                                    break block29;
                                }
                                if (!string3.equals("http") && !string3.equals("https") || (httpURLConnection = (HttpURLConnection)(uRL = new URL(string2)).openConnection()) == null) break block28;
                                String string4 = uRI.getUserInfo();
                                boolean bl2 = bl = string4 == null;
                                if (bl && httpURLConnection.getResponseCode() != 200) {
                                    string = NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"MSG_Progress_Clone_CannotAccess_Err");
                                    httpURLConnection.disconnect();
                                    break block30;
                                }
                                if (string4 != null) {
                                    Mercurial.LOG.log(Level.FINE, "RepositoryStepProgressSupport.perform(): UserInfo - {0}", new Object[]{string4});
                                }
                                httpURLConnection.disconnect();
                                break block28;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                string = NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"MSG_Progress_Clone_InvalidURL_Err");
                                Object var11_16 = null;
                                if (this.isCanceled()) {
                                    CloneRepositoryWizardPanel.this.valid(NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"CTL_Repository_Canceled"));
                                    return;
                                }
                                if (string == null) {
                                    CloneRepositoryWizardPanel.this.valid();
                                    CloneRepositoryWizardPanel.this.storeHistory();
                                    return;
                                }
                                CloneRepositoryWizardPanel.this.invalid(string);
                                return;
                            }
                            catch (IOException iOException) {
                                string = NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"MSG_Progress_Clone_CannotAccess_Err");
                                Object var11_17 = null;
                                if (this.isCanceled()) {
                                    CloneRepositoryWizardPanel.this.valid(NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"CTL_Repository_Canceled"));
                                    return;
                                }
                                if (string == null) {
                                    CloneRepositoryWizardPanel.this.valid();
                                    CloneRepositoryWizardPanel.this.storeHistory();
                                    return;
                                }
                                CloneRepositoryWizardPanel.this.invalid(string);
                                return;
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                string = NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"MSG_Progress_Clone_InvalidURL_Err");
                                Object var11_18 = null;
                                if (this.isCanceled()) {
                                    CloneRepositoryWizardPanel.this.valid(NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"CTL_Repository_Canceled"));
                                    return;
                                }
                                if (string == null) {
                                    CloneRepositoryWizardPanel.this.valid();
                                    CloneRepositoryWizardPanel.this.storeHistory();
                                    return;
                                }
                                CloneRepositoryWizardPanel.this.invalid(string);
                                return;
                            }
                            catch (RuntimeException runtimeException) {
                                Throwable throwable = runtimeException.getCause();
                                string = throwable != null ? throwable.getLocalizedMessage() : runtimeException.getLocalizedMessage();
                                Mercurial.LOG.log(Level.INFO, string, runtimeException);
                                Object var11_19 = null;
                                if (this.isCanceled()) {
                                    CloneRepositoryWizardPanel.this.valid(NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"CTL_Repository_Canceled"));
                                    return;
                                }
                                if (string == null) {
                                    CloneRepositoryWizardPanel.this.valid();
                                    CloneRepositoryWizardPanel.this.storeHistory();
                                    return;
                                }
                                CloneRepositoryWizardPanel.this.invalid(string);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var11_20 = null;
                            if (this.isCanceled()) {
                                CloneRepositoryWizardPanel.this.valid(NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"CTL_Repository_Canceled"));
                                throw throwable;
                            }
                            if (string == null) {
                                CloneRepositoryWizardPanel.this.valid();
                                CloneRepositoryWizardPanel.this.storeHistory();
                                throw throwable;
                            }
                            CloneRepositoryWizardPanel.this.invalid(string);
                            throw throwable;
                        }
                    }
                    if (this.isCanceled()) {
                        CloneRepositoryWizardPanel.this.valid(NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"CTL_Repository_Canceled"));
                        return;
                    }
                    if (string == null) {
                        CloneRepositoryWizardPanel.this.valid();
                        CloneRepositoryWizardPanel.this.storeHistory();
                        return;
                    }
                    CloneRepositoryWizardPanel.this.invalid(string);
                    return;
                }
                Object var11_14 = null;
                if (this.isCanceled()) {
                    CloneRepositoryWizardPanel.this.valid(NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"CTL_Repository_Canceled"));
                    return;
                }
                if (string == null) {
                    CloneRepositoryWizardPanel.this.valid();
                    CloneRepositoryWizardPanel.this.storeHistory();
                    return;
                }
                CloneRepositoryWizardPanel.this.invalid(string);
                return;
            }
            Object var11_15 = null;
            if (this.isCanceled()) {
                CloneRepositoryWizardPanel.this.valid(NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"CTL_Repository_Canceled"));
                return;
            }
            if (string == null) {
                CloneRepositoryWizardPanel.this.valid();
                CloneRepositoryWizardPanel.this.storeHistory();
                return;
            }
            CloneRepositoryWizardPanel.this.invalid(string);
        }

        public void setEditable(boolean bl) {
            CloneRepositoryWizardPanel.this.repository.setEditable(bl);
        }
    }
}

