/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.catd;

import com.sun.esb.management.api.configuration.ConfigurationService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.netbeans.modules.compapp.catd.Input;
import org.netbeans.modules.compapp.catd.Output;
import org.netbeans.modules.compapp.catd.util.EditableProperties;
import org.netbeans.modules.compapp.projects.jbi.AdministrationServiceHelper;
import org.netbeans.modules.sun.manager.jbi.util.ServerInstance;
import org.netbeans.modules.sun.manager.jbi.util.ServerInstanceReader;
import org.netbeans.modules.xml.xdm.diff.Add;
import org.netbeans.modules.xml.xdm.diff.Change;
import org.netbeans.modules.xml.xdm.diff.Delete;
import org.netbeans.modules.xml.xdm.diff.Difference;
import org.netbeans.modules.xml.xdm.diff.NodeInfo;
import org.netbeans.modules.xml.xdm.diff.XDMUtil;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfiguredTest
extends TestCase {
    public static final String COMPARISON_TYPE_IDENTICAL = "identical";
    public static final String COMPARISON_TYPE_BINARY = "binary";
    public static final String COMPARISON_TYPE_EQUALS = "equals";
    private static final String TEST_IN_PROGRESS_VAL = "progress";
    private static final String TEST_IN_PROGRESS_KEY = "featurestatus";
    private static final SimpleDateFormat mSDF = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String OVERWRITE_EMPTY_OUTPUT_MSG = "The expected output file for this test case was empty. The most recent output is saved as the test case's expected output file for comparison during later test runs.";
    public static final String NS_PREFIX = "xmlns";
    public static final String SCHEMA_LOCATION = "schemaLocation";
    private SOAPConnectionFactory mSoapConnFactory;
    private SOAPConnection mConnection;
    private MessageFactory mMessageFactory;
    private String mName;
    private Properties mProperties;
    private boolean mGenerateOutputOnSuccess = true;
    private static final XDMUtil xdmUtil = new XDMUtil();
    private String mIndent;
    static String EMPTY = "";

    public ConfiguredTest(String name, String methodName) {
        super(methodName);
        this.mName = name;
    }

    public ConfiguredTest(String name, String methodName, Properties testProperties) {
        this(name, methodName);
        this.mProperties = testProperties;
        this.mIndent = "  ";
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    protected void setUp() throws Exception {
        this.mSoapConnFactory = SOAPConnectionFactory.newInstance();
        this.mConnection = this.mSoapConnFactory.createConnection();
        this.mMessageFactory = MessageFactory.newInstance();
        Logger.getLogger("org.netbeans.modules.editor.impl.KitsTracker").setLevel(Level.SEVERE);
        Logger.getLogger("org.openide.loaders").setLevel(Level.SEVERE);
    }

    protected void tearDown() throws Exception {
        this.mConnection.close();
        this.mConnection = null;
    }

    public static Test suite() throws Exception {
        Properties props = System.getProperties();
        System.out.println(props);
        Properties testcasesProps = ConfiguredTest.loadProperties("test/selected-tests.properties");
        String testCasesCSV = (String)testcasesProps.get("testcases");
        String[] testCaseNames = testCasesCSV.split(",");
        TestSuite suite = new TestSuite();
        String testPropertiesPostfix = ".properties";
        FileFilter testPropertiesFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return false;
                }
                return f.getName().endsWith(".properties");
            }
        };
        HashSet<String> processedTestCases = new HashSet<String>();
        for (int i = 0; i < testCaseNames.length; ++i) {
            File testCaseDir;
            String testCaseName = testCaseNames[i];
            if (testCaseName == null || testCaseName.trim().length() == 0 || processedTestCases.contains(testCaseName) || !(testCaseDir = new File("test/" + testCaseName)).isDirectory()) continue;
            String inputDirName = testCaseDir.getName();
            String inputDirAbsolutePath = testCaseDir.getAbsolutePath();
            File[] testPropertiesFiles = testCaseDir.listFiles(testPropertiesFilter);
            if (testPropertiesFiles == null) continue;
            processedTestCases.add(testCaseName);
            for (int testCnt = 0; testCnt < testPropertiesFiles.length; ++testCnt) {
                String testPropertiesFile = testPropertiesFiles[testCnt].getAbsolutePath();
                String testName = inputDirName;
                Properties testProps = ConfiguredTest.loadProperties(testPropertiesFile);
                testProps.put("testpropertiesfilename", testPropertiesFiles[testCnt].getName());
                testProps.put("absoluteinputdir", inputDirAbsolutePath);
                testProps.put("inputdirname", inputDirName);
                if (testPropertiesFile.endsWith("Invoke.properties")) {
                    suite.addTest((Test)new ConfiguredTest(testName, "testInboundSOAPRequest", testProps));
                    continue;
                }
                if (testPropertiesFile.endsWith("Concurrent.properties")) {
                    suite.addTest((Test)new ConfiguredTest(testName, "testConcurrentSOAPRequest", testProps));
                    continue;
                }
                if (testPropertiesFile.endsWith("FaultHandling.properties")) {
                    suite.addTest((Test)new ConfiguredTest(testName, "testFaultHandlingSOAPRequest", testProps));
                    continue;
                }
                if (testPropertiesFile.endsWith("N2M.properties")) {
                    suite.addTest((Test)new ConfiguredTest(testName, "testN2MInboundSOAPRequest", testProps));
                    continue;
                }
                if (testPropertiesFile.endsWith("Feed.properties")) {
                    suite.addTest((Test)new ConfiguredTest(testName, "testFileRequest", testProps));
                    continue;
                }
                if (testPropertiesFile.endsWith("Ftp.properties")) {
                    suite.addTest((Test)new ConfiguredTest(testName, "testFtpRequest", testProps));
                    continue;
                }
                if (testPropertiesFile.endsWith("Correlation.properties")) {
                    suite.addTest((Test)new ConfiguredTest(testName, "testCorrelationSOAPRequest", testProps));
                    continue;
                }
                if (testPropertiesFile.endsWith("ConcurrentCorrelation.properties")) {
                    suite.addTest((Test)new ConfiguredTest(testName, "testConcurrentCorrelationSOAPRequest", testProps));
                    continue;
                }
                if (!testPropertiesFile.endsWith("conc_correlation.properties")) continue;
                suite.addTest((Test)new ConfiguredTest(testName, "testConcCorrelationSOAPRequest", testProps));
            }
        }
        return suite;
    }

    protected static String stackTraceElementToString(StackTraceElement[] ste) {
        String s = "";
        for (int i = 0; i < ste.length; ++i) {
            s = s + ste[i].toString() + "\n";
        }
        return s;
    }

    protected static void initSuite(String testSuitePath, String suiteName) throws Exception {
        boolean success = new File(testSuitePath + File.separator + suiteName).mkdir();
        if (!success) {
            throw new Exception("Failed to create directory " + testSuitePath + File.separator + suiteName);
        }
    }

    protected static void initTest(String testSuitePath, String suiteName, String testName) throws Exception {
        String testDir = testSuitePath + File.separator + suiteName + File.separator + testName;
        boolean success = new File(testDir).mkdir();
        if (!success) {
            throw new Exception("Failed to create directory " + testDir);
        }
    }

    protected static void copyTestResourceFile(File srcFile, File destFile) throws Exception {
        FileInputStream in = null;
        OutputStream out = null;
        boolean isExists = destFile.exists();
        if (isExists) {
            destFile.delete();
        }
        destFile.createNewFile();
        try {
            int bytesRead;
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = ((InputStream)in).read(buffer)) >= 0) {
                out.write(buffer, 0, bytesRead);
            }
            out.close();
            ((InputStream)in).close();
        }
        catch (Throwable th) {
            try {
                if (out != null) {
                    out.close();
                }
                if (out != null) {
                    ((InputStream)in).close();
                }
            }
            catch (Throwable th2) {
                // empty catch block
            }
        }
    }

    protected static void writeStringToFile(File destFile, String content) throws Exception {
        boolean isExists = destFile.exists();
        if (isExists) {
            destFile.delete();
        }
        destFile.createNewFile();
        FileOutputStream out = null;
        OutputStreamWriter ow = null;
        try {
            out = new FileOutputStream(destFile);
            ow = new OutputStreamWriter(out);
            ow.write(content);
            ow.flush();
            ow.close();
            ((OutputStream)out).close();
        }
        catch (Throwable th) {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
                if (ow != null) {
                    ow.close();
                }
            }
            catch (Throwable th2) {
                // empty catch block
            }
        }
    }

    protected static void logResultsForBuild(Properties properties, String suitePath, String suiteName, String testName, String value, String errorString) throws Exception {
        String outputHome = System.getenv("BUILD_OUTPUT_HOME");
        if (outputHome != null) {
            ConfiguredTest.logResults(properties, suitePath, suiteName, testName, value, errorString);
        }
    }

    protected static void logResults(Properties properties, String suitePath, String suiteName, String testName, String aValue, String errorString) throws Exception {
        String valuePropertyFile;
        boolean exists;
        String destDir = suitePath + File.separator + suiteName + File.separator + testName;
        String srcDir = (String)properties.get("absoluteinputdir");
        File source = new File(srcDir);
        File[] inputDir = source.listFiles();
        if (inputDir != null) {
            for (int count = 0; count < inputDir.length; ++count) {
                File currentFile = inputDir[count];
                if (currentFile.isDirectory()) continue;
                ConfiguredTest.copyTestResourceFile(currentFile, new File(destDir + File.separator + currentFile.getName()));
            }
        }
        if (errorString != null) {
            File errorFile = new File(suitePath + File.separator + suiteName + File.separator + testName + File.separator + "error.txt");
            ConfiguredTest.writeStringToFile(errorFile, errorString);
        }
        if (!(exists = new File(valuePropertyFile = suitePath + File.separator + aValue + ".properties").exists())) {
            File propFile = new File(valuePropertyFile);
            try {
                propFile.createNewFile();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Properties prop = new Properties();
        FileInputStream fis = new FileInputStream(valuePropertyFile);
        prop.load(fis);
        fis.close();
        String tests = prop.getProperty("list");
        String content = suiteName + ":" + testName;
        tests = tests == null ? content : tests + ", " + content;
        FileOutputStream fos = new FileOutputStream(valuePropertyFile);
        prop.setProperty("list", tests);
        prop.store(fos, "");
        fos.close();
    }

    protected static File[] getDirList(File baseDir) {
        ArrayList<File> retValue = new ArrayList<File>();
        if (baseDir.isDirectory()) {
            retValue.add(baseDir);
            File[] children = baseDir.listFiles();
            for (int ii = 0; ii < children.length; ++ii) {
                retValue.addAll(Arrays.asList(ConfiguredTest.getDirList(children[ii])));
            }
        }
        return retValue.toArray(new File[0]);
    }

    protected static String getRelativePath(File root, File subDir) throws Exception {
        String rootPath = root.getCanonicalPath();
        String subDirPath = subDir.getCanonicalPath();
        int index = subDirPath.indexOf(rootPath);
        if (index != -1) {
            return subDirPath.substring(index + rootPath.length() + 1, subDirPath.length());
        }
        return subDirPath;
    }

    public void testInboundSOAPRequest() throws Exception {
        String destination = this.mProperties.getProperty("destination");
        String description = this.mProperties.getProperty("description");
        String soapAction = this.mProperties.getProperty("soapaction");
        String inputFileName = this.mProperties.getProperty("inputfile");
        String outputFileName = this.mProperties.getProperty("outputfile");
        String comparisonType = this.mProperties.getProperty("comparisontype");
        String testPropertiesFileName = this.mProperties.getProperty("testpropertiesfilename");
        String inputDir = this.mProperties.getProperty("absoluteinputdir");
        String inputDirName = this.mProperties.getProperty("inputdirname");
        String debugStr = this.mProperties.getProperty("debug");
        String featureProgressVal = this.mProperties.getProperty(TEST_IN_PROGRESS_KEY);
        if (featureProgressVal != null && featureProgressVal.equals(TEST_IN_PROGRESS_VAL)) {
            System.out.println("Test " + inputDirName + "\\" + testPropertiesFileName + " in Development");
            return;
        }
        boolean logDetails = false;
        if (debugStr != null && Boolean.valueOf(debugStr) == Boolean.TRUE) {
            logDetails = true;
        }
        System.out.print("Test " + inputDirName + "\\" + testPropertiesFileName);
        System.out.flush();
        try {
            if (logDetails) {
                System.out.println("testInboundSOAPRequest Running " + testPropertiesFileName + " : " + description);
                System.out.println("Test destination: " + destination);
            }
            String inputFile = inputDir + File.separator + inputFileName;
            String expectedOutputFile = null;
            if (outputFileName != null) {
                expectedOutputFile = new File(inputDir, outputFileName).getAbsolutePath();
            }
            String logPrefix = inputDirName + "\\" + testPropertiesFileName + ":";
            this.sendAndCheck(logPrefix, logDetails, destination, inputFile, expectedOutputFile, null, null, comparisonType, soapAction);
            System.out.println(" Passed.");
        }
        catch (Exception ex) {
            System.out.println(" Failed.");
            throw ex;
        }
        catch (Error er) {
            System.out.println(" Failed.");
            throw er;
        }
    }

    public void testFaultHandlingSOAPRequest() throws Exception {
        String description = this.mProperties.getProperty("description");
        String destination = this.mProperties.getProperty("destination");
        String soapAction = this.mProperties.getProperty("soapaction");
        String inputFileName = this.mProperties.getProperty("inputfile");
        String expectedHttpStatus = this.mProperties.getProperty("httpstatuscode");
        String expectedHttpWarning = this.mProperties.getProperty("httpwarning");
        String outputFileName = this.mProperties.getProperty("outputfile");
        String comparisonType = this.mProperties.getProperty("comparisontype");
        String testPropertiesFileName = this.mProperties.getProperty("testpropertiesfilename");
        String inputDir = this.mProperties.getProperty("absoluteinputdir");
        String inputDirName = this.mProperties.getProperty("inputdirname");
        String debugStr = this.mProperties.getProperty("debug");
        String featureProgressVal = this.mProperties.getProperty(TEST_IN_PROGRESS_KEY);
        if (featureProgressVal != null && featureProgressVal.equals(TEST_IN_PROGRESS_VAL)) {
            System.out.println("Test " + inputDirName + "\\" + testPropertiesFileName + " in Development");
            return;
        }
        boolean logDetails = false;
        if (debugStr != null && Boolean.valueOf(debugStr) == Boolean.TRUE) {
            logDetails = true;
        }
        System.out.print("Test " + inputDirName + "\\" + testPropertiesFileName);
        System.out.flush();
        try {
            if (logDetails) {
                System.out.println("testFaultHandlingSOAPRequest Running " + testPropertiesFileName + " : " + description);
                System.out.println("Test destination: " + destination);
            }
            String inputFile = inputDir + File.separator + inputFileName;
            String expectedOutputFile = null;
            if (expectedOutputFile != null) {
                expectedOutputFile = new File(inputDir, outputFileName).getAbsolutePath();
            }
            String logPrefix = inputDirName + "\\" + testPropertiesFileName + ":";
            this.sendAndCheck(logPrefix, logDetails, destination, inputFile, expectedOutputFile, expectedHttpStatus, expectedHttpWarning, comparisonType, soapAction);
            System.out.println(" Passed.");
        }
        catch (Exception ex) {
            System.out.println(" Failed.");
            throw ex;
        }
        catch (Error er) {
            System.out.println(" Failed.");
            throw er;
        }
    }

    public void testConcurrentSOAPRequest() throws Exception {
        String description = this.mProperties.getProperty("description");
        String destination = this.mProperties.getProperty("destination");
        String soapAction = this.mProperties.getProperty("soapaction");
        String concurrentInvokesStr = this.mProperties.getProperty("concurrentthreads");
        String invokesPerThreadStr = this.mProperties.getProperty("invokesperthread");
        String comparisonType = this.mProperties.getProperty("comparisontype");
        String testTimeoutStr = this.mProperties.getProperty("testtimeout");
        String testPropertiesFileName = this.mProperties.getProperty("testpropertiesfilename");
        String inputDir = this.mProperties.getProperty("absoluteinputdir");
        String inputDirName = this.mProperties.getProperty("inputdirname");
        String calculateThroughputStr = this.mProperties.getProperty("calculatethroughput");
        String debugStr = this.mProperties.getProperty("debug");
        String featureProgressVal = this.mProperties.getProperty(TEST_IN_PROGRESS_KEY);
        if (featureProgressVal != null && featureProgressVal.equals(TEST_IN_PROGRESS_VAL)) {
            System.out.println("Test " + inputDirName + "\\" + testPropertiesFileName + " in Development");
            return;
        }
        int concurrentInvokes = Integer.parseInt(concurrentInvokesStr);
        int testTimeout = Integer.parseInt(testTimeoutStr);
        if ("true".equals(System.getProperty("inDebug"))) {
            testTimeout = 0;
        }
        int invokesPerThread = 1;
        if (invokesPerThreadStr != null) {
            invokesPerThread = Integer.parseInt(invokesPerThreadStr);
        }
        boolean calculateThroughput = false;
        if (calculateThroughputStr != null && Boolean.valueOf(calculateThroughputStr) == Boolean.TRUE) {
            calculateThroughput = true;
        }
        boolean logDetails = false;
        if (debugStr != null && Boolean.valueOf(debugStr) == Boolean.TRUE) {
            logDetails = true;
        }
        System.out.print("Test " + inputDirName + "\\" + testPropertiesFileName);
        System.out.flush();
        try {
            int threadCount;
            LinkedHashMap<String, String> inputToOutputFileNames = new LinkedHashMap<String, String>();
            Set<Map.Entry<Object, Object>> entries = this.mProperties.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                String key = (String)entry.getKey();
                if (!key.startsWith("inputfile")) continue;
                String inputFileName = (String)entry.getValue();
                String fileId = key.substring("inputfile".length());
                String expectedOutputProperty = "outputfile" + fileId;
                String outputFileName = this.mProperties.getProperty(expectedOutputProperty);
                if (outputFileName != null) {
                    inputToOutputFileNames.put(inputFileName, outputFileName);
                    continue;
                }
                throw new Exception("Test set up error. No corresponding property to define output file found for input file property " + key + ". Identified unique id is: " + fileId + " expected output file property: " + expectedOutputProperty);
            }
            if (logDetails) {
                System.out.println("testConcurrentSOAPRequest Running " + testPropertiesFileName + " : " + description);
                System.out.println("Test destination: " + destination);
            }
            Map.Entry[] inOutEntries = inputToOutputFileNames.entrySet().toArray(new Map.Entry[0]);
            Thread[] threads = new Thread[concurrentInvokes];
            ConcurrentTestSendOnlyRunnable[] runnables = new ConcurrentTestSendOnlyRunnable[concurrentInvokes];
            for (threadCount = 0; threadCount < concurrentInvokes; ++threadCount) {
                ConcurrentTestSendOnlyRunnable runnable;
                Map.Entry entry = inOutEntries[threadCount % inOutEntries.length];
                String inputFileName = (String)entry.getKey();
                String outputFileName = (String)entry.getValue();
                String threadName = "Concurrent test thread " + threadCount;
                String logPrefix = inputDirName + "\\" + testPropertiesFileName + " - " + threadName + ":";
                String inputFile = inputDir + File.separator + inputFileName;
                SOAPMessage message = this.loadMessage(logPrefix, logDetails, inputFile);
                String expectedOutputFile = new File(inputDir, outputFileName).getAbsolutePath();
                runnables[threadCount] = runnable = new ConcurrentTestSendOnlyRunnable(inputDirName, message, expectedOutputFile, destination, testPropertiesFileName, invokesPerThread, soapAction);
                threads[threadCount] = new Thread(runnable);
                threads[threadCount].setName(threadName);
            }
            for (threadCount = 0; threadCount < concurrentInvokes; ++threadCount) {
                threads[threadCount].start();
            }
            long startTime = System.currentTimeMillis();
            long timeoutTime = startTime + (long)(testTimeout * 1000);
            long threadCountStuck = 0L;
            long threadCountSuccess = 0L;
            long threadCountError = 0L;
            long duration = 0L;
            String detail = "";
            for (int threadCount2 = 0; threadCount2 < concurrentInvokes; ++threadCount2) {
                long remainingTime = timeoutTime - System.currentTimeMillis();
                if (testTimeout == 0 || remainingTime >= 0L) {
                    threads[threadCount2].join(testTimeout * 1000);
                }
                if (threads[threadCount2].isAlive()) {
                    ++threadCountStuck;
                    detail = detail + "<" + threads[threadCount2].getName() + ">" + " did not complete. Success rate " + runnables[threadCount2].getInvocationsDone() + "/" + runnables[threadCount2].getInvocationCount() + " \n";
                    continue;
                }
                Throwable encountered = runnables[threadCount2].getThrowableEncountered();
                if (encountered != null) {
                    ++threadCountError;
                    String message = encountered.getMessage();
                    detail = detail + "<" + threads[threadCount2].getName() + ">" + " is Errored. Success rate " + runnables[threadCount2].getInvocationsDone() + "/" + runnables[threadCount2].getInvocationCount() + " \n";
                    continue;
                }
                ++threadCountSuccess;
                duration += runnables[threadCount2].getDuration();
                SOAPMessage[] replies = runnables[threadCount2].getReplies();
                for (int replyCount = 0; replyCount < replies.length; ++replyCount) {
                    String testExpectedOutputFileName = runnables[threadCount2].getExpectedOutputFileName();
                    String logPrefix = inputDirName + "\\" + testPropertiesFileName + " - " + threads[threadCount2].getName() + ":";
                    SOAPMessage reply = replies[replyCount];
                    this.checkExpectedOutput(logPrefix, logDetails, reply, testExpectedOutputFileName, comparisonType);
                }
            }
            String result = " Passed.";
            result = result + " Threads count Success: <" + threadCountSuccess + "> Error: <" + threadCountError + "> Not completed: <" + threadCountStuck + ">";
            if (calculateThroughput) {
                int totalInvocations = invokesPerThread * concurrentInvokes;
                double timeInSecs = (double)duration / 1000.0;
                double invocationsPerSecond = (double)totalInvocations / timeInSecs;
                result = result + " Throughput: <" + totalInvocations + "> invocations in <" + timeInSecs + ">s = <" + invocationsPerSecond + "> invokes/s";
            }
            if (detail.length() > 0) {
                result = result + "\nDetails: \n" + detail;
                ConfiguredTest.assertTrue((String)result, (boolean)false);
            } else {
                System.out.println(result);
            }
        }
        catch (Exception ex) {
            System.out.println(" Failed. (Destination: " + destination + ")");
            throw ex;
        }
        catch (Error er) {
            System.out.println(" Failed. (Destination: " + destination + ")");
            throw er;
        }
    }

    public void testCorrelationSOAPRequest() throws Exception {
        String featureProgressVal = this.mProperties.getProperty(TEST_IN_PROGRESS_KEY);
        String testPropertiesFileName = this.mProperties.getProperty("testpropertiesfilename");
        String inputDirName = this.mProperties.getProperty("inputdirname");
        if (featureProgressVal != null && featureProgressVal.equals(TEST_IN_PROGRESS_VAL)) {
            System.out.println("Test " + inputDirName + "\\" + testPropertiesFileName + " in Development");
            return;
        }
        String description = this.mProperties.getProperty("description");
        String comparisonType = "#" + this.mProperties.getProperty("comparisontype");
        String testTimeoutStr = this.mProperties.getProperty("testtimeout");
        String inputDir = this.mProperties.getProperty("absoluteinputdir");
        String calculateThroughputStr = this.mProperties.getProperty("calculatethroughput");
        String debugStr = this.mProperties.getProperty("debug");
        boolean calculateThroughput = false;
        if (calculateThroughputStr != null && Boolean.valueOf(calculateThroughputStr) == Boolean.TRUE) {
            calculateThroughput = true;
        }
        boolean logDetails = false;
        if (debugStr != null && Boolean.valueOf(debugStr) == Boolean.TRUE) {
            logDetails = true;
        }
        int testTimeout = 0;
        if (testTimeoutStr != null && !testTimeoutStr.trim().equals("")) {
            testTimeout = Integer.parseInt(testTimeoutStr);
        }
        if ("true".equals(System.getProperty("inDebug"))) {
            testTimeout = 0;
        }
        System.out.print("Test " + inputDirName + "\\" + testPropertiesFileName);
        System.out.flush();
        try {
            int threadCount;
            String soapAction;
            ArrayList individualPropMaps = new ArrayList();
            HashMap<String, String> individualPropMap = null;
            Set<Map.Entry<Object, Object>> entries = this.mProperties.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                String key = (String)entry.getKey();
                if (!key.startsWith("inputfile")) continue;
                String inputFileName = (String)entry.getValue();
                String fileId = key.substring("inputfile".length());
                String expectedOutputProperty = "outputfile" + fileId;
                String outputFileName = this.mProperties.getProperty(expectedOutputProperty);
                String expectedDestination = "destination" + fileId;
                String expectedDestinationVal = this.mProperties.getProperty(expectedDestination);
                soapAction = "soapaction" + fileId;
                String soapActionVal = this.mProperties.getProperty(soapAction);
                if (outputFileName == null || expectedDestinationVal == null) {
                    throw new Exception("Test set up error. No corresponding property to define output file found for input file property " + key + ". Identified unique id is: " + fileId + " expected output file property: " + expectedOutputProperty);
                }
                individualPropMap = new HashMap<String, String>();
                individualPropMap.put("inputfile", inputFileName);
                individualPropMap.put("outputfile", outputFileName);
                individualPropMap.put("destination", expectedDestinationVal);
                individualPropMap.put("soapaction", soapActionVal);
                individualPropMaps.add(individualPropMap);
            }
            if (logDetails) {
                System.out.println("testCorrelationSOAPRequest Running " + testPropertiesFileName + " : " + description);
            }
            int totalNumberOfDestinations = individualPropMaps.size();
            Thread[] threads = new Thread[totalNumberOfDestinations];
            ConcurrentTestSendOnlyRunnable[] runnables = new ConcurrentTestSendOnlyRunnable[totalNumberOfDestinations];
            Map individualDest = null;
            for (threadCount = 0; threadCount < totalNumberOfDestinations; ++threadCount) {
                ConcurrentTestSendOnlyRunnable runnable;
                individualDest = (Map)individualPropMaps.get(threadCount);
                String inputFileName = (String)individualDest.get("inputfile");
                String outputFileName = (String)individualDest.get("outputfile");
                String destination = (String)individualDest.get("destination");
                soapAction = (String)individualDest.get("soapaction");
                String threadName = "Correlation test thread " + threadCount;
                String logPrefix = inputDirName + "\\" + testPropertiesFileName + " - " + threadName + ":";
                String inputFile = inputDir + File.separator + inputFileName;
                SOAPMessage message = this.loadMessage(logPrefix, logDetails, inputFile);
                String expectedOutputFile = "";
                if (!"".equals(outputFileName)) {
                    expectedOutputFile = new File(inputDir, outputFileName).getAbsolutePath();
                }
                runnables[threadCount] = runnable = new ConcurrentTestSendOnlyRunnable(inputDirName, message, expectedOutputFile, destination, testPropertiesFileName, 1, soapAction);
                threads[threadCount] = new Thread(runnable);
                threads[threadCount].setName(threadName);
            }
            for (threadCount = 0; threadCount < totalNumberOfDestinations; ++threadCount) {
                threads[threadCount].start();
            }
            long startTime = System.currentTimeMillis();
            long timeoutTime = startTime + (long)(testTimeout * 1000);
            for (int threadCount2 = 0; threadCount2 < totalNumberOfDestinations; ++threadCount2) {
                long remainingTime = timeoutTime - System.currentTimeMillis();
                if (testTimeout == 0 || remainingTime >= 0L) {
                    threads[threadCount2].join(testTimeout * 1000);
                }
                if (threads[threadCount2].isAlive()) {
                    throw new Exception("Test has reached the maximum timeout allowed of " + testTimeout);
                }
                Throwable encountered = runnables[threadCount2].getThrowableEncountered();
                if (encountered == null) continue;
                if (encountered instanceof AssertionFailedError) {
                    throw (AssertionFailedError)encountered;
                }
                ConfiguredTest.fail((String)("Exception reported by thread " + threads[threadCount2].getName() + encountered.getMessage()));
            }
            long endTime = System.currentTimeMillis();
            for (int threadCount3 = 0; threadCount3 < totalNumberOfDestinations; ++threadCount3) {
                SOAPMessage[] replies = runnables[threadCount3].getReplies();
                for (int replyCount = 0; replyCount < replies.length; ++replyCount) {
                    String testExpectedOutputFileName = runnables[threadCount3].getExpectedOutputFileName();
                    String logPrefix = inputDirName + "\\" + testPropertiesFileName + " - " + threads[threadCount3].getName() + ":";
                    SOAPMessage reply = replies[replyCount];
                    this.checkExpectedOutput(logPrefix, logDetails, reply, testExpectedOutputFileName, comparisonType);
                }
            }
            String result = " Passed.";
            System.out.println(result);
        }
        catch (Exception ex) {
            System.out.println(" Failed.");
            throw ex;
        }
        catch (Error er) {
            System.out.println(" Failed.");
            throw er;
        }
    }

    public void testConcurrentCorrelationSOAPRequest() throws Exception {
        String featureProgressVal = this.mProperties.getProperty(TEST_IN_PROGRESS_KEY);
        String testPropertiesFileName = this.mProperties.getProperty("testpropertiesfilename");
        String inputDirName = this.mProperties.getProperty("inputdirname");
        if (featureProgressVal != null && featureProgressVal.equals(TEST_IN_PROGRESS_VAL)) {
            System.out.println("Test " + inputDirName + "\\" + testPropertiesFileName + " in Development");
            return;
        }
        String description = this.mProperties.getProperty("description");
        String comparisonType = "#" + this.mProperties.getProperty("comparisontype");
        String testTimeoutStr = this.mProperties.getProperty("testtimeout");
        String inputDir = this.mProperties.getProperty("absoluteinputdir");
        String calculateThroughputStr = this.mProperties.getProperty("calculatethroughput");
        String debugStr = this.mProperties.getProperty("debug");
        boolean calculateThroughput = false;
        if (calculateThroughputStr != null && Boolean.valueOf(calculateThroughputStr) == Boolean.TRUE) {
            calculateThroughput = true;
        }
        boolean logDetails = false;
        if (debugStr != null && Boolean.valueOf(debugStr) == Boolean.TRUE) {
            logDetails = true;
        }
        int testTimeout = 0;
        if (testTimeoutStr != null && !testTimeoutStr.trim().equals("")) {
            testTimeout = Integer.parseInt(testTimeoutStr);
        }
        if ("true".equals(System.getProperty("inDebug"))) {
            testTimeout = 0;
        }
        System.out.print("Test " + inputDirName + "\\" + testPropertiesFileName);
        System.out.flush();
        try {
            int threadCount;
            ArrayList<Map> individualPropMaps = new ArrayList<Map>();
            Map properties = this.concurrentCorrelationBuildInfo(this.mProperties);
            Iterator itr = properties.entrySet().iterator();
            while (itr.hasNext()) {
                Map prop = (Map)itr.next().getValue();
                individualPropMaps.add(prop);
            }
            if (logDetails) {
                System.out.println("testCorrelationSOAPRequest Running " + testPropertiesFileName + " : " + description);
            }
            int totalNumberOfDestinations = individualPropMaps.size();
            Thread[] threads = new Thread[totalNumberOfDestinations];
            ConcurrentTestSendOnlyRunnable[] runnables = new ConcurrentTestSendOnlyRunnable[totalNumberOfDestinations];
            Map individualDest = null;
            for (threadCount = 0; threadCount < totalNumberOfDestinations; ++threadCount) {
                ConcurrentTestSendOnlyRunnable runnable;
                individualDest = (Map)individualPropMaps.get(threadCount);
                String inputFileName = (String)individualDest.get("inputfile");
                String outputFileName = (String)individualDest.get("outputfile");
                String destination = (String)individualDest.get("destination");
                String soapAction = (String)individualDest.get("soapaction");
                String threadName = "Correlation test thread " + threadCount;
                String logPrefix = inputDirName + "\\" + testPropertiesFileName + " - " + threadName + ":";
                String inputFile = inputDir + File.separator + inputFileName;
                SOAPMessage message = this.loadMessage(logPrefix, logDetails, inputFile);
                String expectedOutputFile = "";
                if (!"".equals(outputFileName)) {
                    expectedOutputFile = new File(inputDir, outputFileName).getAbsolutePath();
                }
                runnables[threadCount] = runnable = new ConcurrentTestSendOnlyRunnable(inputDirName, message, expectedOutputFile, destination, testPropertiesFileName, 1, soapAction);
                threads[threadCount] = new Thread(runnable);
                threads[threadCount].setName(threadName);
            }
            for (threadCount = 0; threadCount < totalNumberOfDestinations; ++threadCount) {
                threads[threadCount].start();
            }
            long startTime = System.currentTimeMillis();
            long timeoutTime = startTime + (long)(testTimeout * 1000);
            for (int threadCount2 = 0; threadCount2 < totalNumberOfDestinations; ++threadCount2) {
                long remainingTime = timeoutTime - System.currentTimeMillis();
                if (testTimeout == 0 || remainingTime >= 0L) {
                    threads[threadCount2].join(testTimeout * 1000);
                }
                if (threads[threadCount2].isAlive()) {
                    throw new Exception("Test has reached the maximum timeout allowed of " + testTimeout);
                }
                Throwable encountered = runnables[threadCount2].getThrowableEncountered();
                if (encountered == null) continue;
                if (encountered instanceof AssertionFailedError) {
                    throw (AssertionFailedError)encountered;
                }
                ConfiguredTest.fail((String)("Exception reported by thread " + threads[threadCount2].getName() + encountered.getMessage()));
            }
            long endTime = System.currentTimeMillis();
            for (int threadCount3 = 0; threadCount3 < totalNumberOfDestinations; ++threadCount3) {
                SOAPMessage[] replies = runnables[threadCount3].getReplies();
                for (int replyCount = 0; replyCount < replies.length; ++replyCount) {
                    String testExpectedOutputFileName = runnables[threadCount3].getExpectedOutputFileName();
                    String logPrefix = inputDirName + "\\" + testPropertiesFileName + " - " + threads[threadCount3].getName() + ":";
                    SOAPMessage reply = replies[replyCount];
                    this.checkExpectedOutput(logPrefix, logDetails, reply, testExpectedOutputFileName, comparisonType);
                }
            }
            String result = " Passed.";
            System.out.println(result);
        }
        catch (Exception ex) {
            System.out.println(" Failed.");
            throw ex;
        }
        catch (Error er) {
            System.out.println(" Failed.");
            throw er;
        }
    }

    public void testConcCorrelationSOAPRequest() throws Exception {
        String featureProgressVal = this.mProperties.getProperty(TEST_IN_PROGRESS_KEY);
        String testPropertiesFileName = this.mProperties.getProperty("testpropertiesfilename");
        String inputDirName = this.mProperties.getProperty("inputdirname");
        if (featureProgressVal != null && featureProgressVal.equals(TEST_IN_PROGRESS_VAL)) {
            System.out.println("Test " + inputDirName + "\\" + testPropertiesFileName + " in Development");
            return;
        }
        String description = this.mProperties.getProperty("description");
        String comparisonType = this.mProperties.getProperty("comparisontype");
        String testTimeoutStr = this.mProperties.getProperty("testtimeout");
        String inputDir = this.mProperties.getProperty("absoluteinputdir");
        String concurrentInvokesStr = this.mProperties.getProperty("concurrentthreads");
        if (concurrentInvokesStr == null) {
            System.out.println("Test " + inputDirName + "\\" + testPropertiesFileName + " failed" + " property 'concurrentthreads' not specified");
        }
        int concurrentInvokes = Integer.parseInt(concurrentInvokesStr);
        String numberofInvokesPerBPELStr = this.mProperties.getProperty("numberOfInvokesPerBPEL");
        if (numberofInvokesPerBPELStr == null) {
            System.out.println("Test " + inputDirName + "\\" + testPropertiesFileName + " failed" + " property 'numberofInvokesPerBPEL' not specified");
        }
        int numberofInvokesPerBPEL = Integer.parseInt(numberofInvokesPerBPELStr);
        String calculateThroughputStr = this.mProperties.getProperty("calculatethroughput");
        String debugStr = this.mProperties.getProperty("debug");
        boolean calculateThroughput = false;
        if (calculateThroughputStr != null && Boolean.valueOf(calculateThroughputStr) == Boolean.TRUE) {
            calculateThroughput = true;
        }
        boolean logDetails = false;
        if (debugStr != null && Boolean.valueOf(debugStr) == Boolean.TRUE) {
            logDetails = true;
        }
        int testTimeout = 0;
        if (testTimeoutStr != null && !testTimeoutStr.trim().equals("")) {
            testTimeout = Integer.parseInt(testTimeoutStr);
        }
        if ("true".equals(System.getProperty("inDebug"))) {
            testTimeout = 0;
        }
        System.out.print("Test " + inputDirName + "\\" + testPropertiesFileName);
        System.out.flush();
        String inputFileKeyPart = "inputfile.invoke";
        String outputFileKeyPart = "outputfile.invoke";
        String destinationKeyPart = "destination.invoke";
        String soapActionKeyPart = "soapaction.invoke";
        String ipOpFolderName = testPropertiesFileName.substring(0, testPropertiesFileName.indexOf(46));
        try {
            ArrayList individualPropMaps = new ArrayList();
            int totalNumberOfDestinations = 0;
            for (int threadCount = 1; threadCount <= concurrentInvokes; ++threadCount) {
                StringBuffer threadInputKeyPart = new StringBuffer();
                threadInputKeyPart.append(threadCount);
                threadInputKeyPart.append(".");
                StringBuffer threadOutputKeyPart = new StringBuffer();
                threadOutputKeyPart.append(threadCount);
                threadOutputKeyPart.append(".");
                ArrayList noOfInvokesList = new ArrayList();
                for (int i = 1; i <= numberofInvokesPerBPEL; ++i) {
                    StringBuffer threadIPKeyPart = new StringBuffer();
                    StringBuffer threadOPKeyPart = new StringBuffer();
                    threadIPKeyPart.append(threadInputKeyPart);
                    threadIPKeyPart.append(inputFileKeyPart);
                    threadIPKeyPart.append(i);
                    threadOPKeyPart.append(threadOutputKeyPart);
                    threadOPKeyPart.append(outputFileKeyPart);
                    threadOPKeyPart.append(i);
                    StringBuffer destKeyPart = new StringBuffer(destinationKeyPart);
                    destKeyPart.append(i);
                    StringBuffer soapActionKey = new StringBuffer(soapActionKeyPart);
                    soapActionKey.append(i);
                    String iputFileName = this.mProperties.getProperty(threadIPKeyPart.toString());
                    String outputFileName = this.mProperties.getProperty(threadOPKeyPart.toString());
                    String destination = this.mProperties.getProperty(destKeyPart.toString());
                    String soapAction = this.mProperties.getProperty(soapActionKey.toString());
                    if (outputFileName == null) {
                        throw new Exception("Test set up error. output file not defined for Thread Number " + threadCount + " and invoke Number " + i + " expected output file property: " + threadOutputKeyPart);
                    }
                    if (iputFileName == null) {
                        throw new Exception("Test set up error. input file not defined for Thread Number " + threadCount + " and invoke Number " + i + " expected input file property: " + threadInputKeyPart);
                    }
                    if (destination == null) {
                        throw new Exception("Test set up error. destination not defined invoke Number " + i + " expected " + "destination property: " + destKeyPart);
                    }
                    HashMap<String, String> individualPropMap = new HashMap<String, String>();
                    individualPropMap.put("inputfile", iputFileName);
                    individualPropMap.put("outputfile", outputFileName);
                    individualPropMap.put("destination", destination);
                    individualPropMap.put("soapaction", soapAction);
                    ++totalNumberOfDestinations;
                    noOfInvokesList.add(individualPropMap);
                }
                individualPropMaps.add(noOfInvokesList);
            }
            if (logDetails) {
                System.out.println("testCorrelationSOAPRequest Running " + testPropertiesFileName + " : " + description);
            }
            Thread[] threads = new Thread[totalNumberOfDestinations];
            CorrelationTestRunnable[] runnables = new CorrelationTestRunnable[totalNumberOfDestinations];
            Map individualDest = null;
            List threadDestinations = null;
            int threadCount = 0;
            for (int j = 0; j < individualPropMaps.size(); ++j) {
                threadDestinations = (List)individualPropMaps.get(j);
                int size = threadDestinations.size();
                for (int i = 0; i < size; ++i) {
                    CorrelationTestRunnable runnable;
                    individualDest = (Map)threadDestinations.get(i);
                    String inputFileName = (String)individualDest.get("inputfile");
                    String outputFileName = (String)individualDest.get("outputfile");
                    String destination = (String)individualDest.get("destination");
                    String soapAction = (String)individualDest.get("soapaction");
                    String threadName = "Correlation test thread " + threadCount;
                    String logPrefix = inputDirName + "\\" + testPropertiesFileName + " - " + threadName + ":";
                    String inputFile = inputDir + File.separator + ipOpFolderName + File.separator + inputFileName;
                    SOAPMessage message = this.loadMessage(logPrefix, logDetails, inputFile);
                    String expectedOutputFile = new File(inputDir + File.separator + ipOpFolderName, outputFileName).getAbsolutePath();
                    runnables[threadCount] = runnable = new CorrelationTestRunnable(inputDirName, message, expectedOutputFile, destination, testPropertiesFileName, 1, soapAction);
                    threads[threadCount] = new Thread(runnable);
                    threads[threadCount].setName(threadName);
                    ++threadCount;
                }
            }
            for (int threadCount2 = 0; threadCount2 < totalNumberOfDestinations; ++threadCount2) {
                threads[threadCount2].start();
            }
            long startTime = System.currentTimeMillis();
            long timeoutTime = startTime + (long)(testTimeout * 1000);
            for (int threadCount3 = 0; threadCount3 < totalNumberOfDestinations; ++threadCount3) {
                long remainingTime = timeoutTime - System.currentTimeMillis();
                if (testTimeout == 0 || remainingTime >= 0L) {
                    threads[threadCount3].join(testTimeout * 1000);
                }
                if (threads[threadCount3].isAlive()) {
                    throw new Exception("Test has reached the maximum timeout allowed of " + testTimeout);
                }
                Throwable encountered = runnables[threadCount3].getThrowableEncountered();
                if (encountered == null) continue;
                if (encountered instanceof AssertionFailedError) {
                    throw (AssertionFailedError)encountered;
                }
                ConfiguredTest.fail((String)("Exception reported by thread " + threads[threadCount3].getName() + encountered.getMessage()));
            }
            long endTime = System.currentTimeMillis();
            for (int threadCount4 = 0; threadCount4 < totalNumberOfDestinations; ++threadCount4) {
                SOAPMessage[] replies = runnables[threadCount4].getReplies();
                for (int replyCount = 0; replyCount < replies.length; ++replyCount) {
                    String testExpectedOutputFileName = runnables[threadCount4].getExpectedOutputFileName();
                    String logPrefix = inputDirName + "\\" + testPropertiesFileName + " - " + threads[threadCount4].getName() + ":";
                    SOAPMessage reply = replies[replyCount];
                    this.checkExpectedOutput(logPrefix, logDetails, reply, testExpectedOutputFileName, comparisonType);
                }
            }
            String result = " Passed.";
            System.out.println(result);
        }
        catch (Exception ex) {
            System.out.println(" Failed.");
            throw ex;
        }
        catch (Error er) {
            System.out.println(" Failed.");
            throw er;
        }
    }

    public void testFileRequest() throws Exception {
        String description = this.mProperties.getProperty("description");
        String clearFeeder = this.mProperties.getProperty("clearfeederdirectory");
        String clearEater = this.mProperties.getProperty("cleareaterdirectory");
        String feederDir = this.mProperties.getProperty("feederdirectory");
        String absoluteFeederDir = this.mProperties.getProperty("absolutefeederdir");
        String feederFileName = this.mProperties.getProperty("feederfile");
        String eaterDir = this.mProperties.getProperty("eaterdirectory");
        String absoluteEaterDir = this.mProperties.getProperty("absoluteeaterdir");
        String eaterFileName = this.mProperties.getProperty("eaterfile");
        String comparisonType = this.mProperties.getProperty("comparisontype");
        String testPropertiesFileName = this.mProperties.getProperty("testpropertiesfilename");
        String outputFileName = this.mProperties.getProperty("outputfile");
        String testTimeoutStr = this.mProperties.getProperty("testtimeout");
        String inputDir = this.mProperties.getProperty("absoluteinputdir");
        String inputDirName = this.mProperties.getProperty("inputdirname");
        String debugStr = this.mProperties.getProperty("debug");
        String featureProgressVal = this.mProperties.getProperty(TEST_IN_PROGRESS_KEY);
        if (featureProgressVal != null && featureProgressVal.equals(TEST_IN_PROGRESS_VAL)) {
            System.out.println("Test " + inputDirName + "\\" + testPropertiesFileName + " in Development");
            return;
        }
        boolean logDetails = false;
        if (debugStr != null && Boolean.valueOf(debugStr) == Boolean.TRUE) {
            logDetails = true;
        }
        int testTimeoutSecs = 0;
        if (testTimeoutStr != null) {
            testTimeoutSecs = Integer.parseInt(testTimeoutStr);
        }
        if ("true".equals(System.getProperty("inDebug"))) {
            testTimeoutSecs = 0;
        }
        System.out.print("Test " + inputDirName + "\\" + testPropertiesFileName);
        System.out.flush();
        try {
            File dir;
            if (logDetails) {
                System.out.println("testFileRequest Running " + testPropertiesFileName + " : " + description);
            }
            String inputFile = inputDir + File.separator + feederFileName;
            String feederDirName = "";
            String feederFile = "";
            if (absoluteFeederDir != null && absoluteFeederDir.trim().length() > 0) {
                feederFile = new File(absoluteFeederDir, feederFileName).getAbsolutePath();
            } else {
                feederDirName = inputDir + File.separator + feederDir;
                feederFile = new File(feederDirName, feederFileName).getAbsolutePath();
            }
            String eaterDirName = "";
            eaterDirName = absoluteEaterDir != null && absoluteEaterDir.trim().length() > 0 ? absoluteEaterDir : inputDir + File.separator + eaterDir;
            String testRunOutputFile = new File(eaterDirName, eaterFileName).getAbsolutePath();
            String expectedOutputFile = new File(inputDir, outputFileName).getAbsolutePath();
            String logPrefix = inputDirName + "\\" + testPropertiesFileName + ":";
            if (clearFeeder != null && Boolean.valueOf(clearFeeder).equals(Boolean.TRUE)) {
                if (absoluteFeederDir != null && absoluteFeederDir.length() > 0) {
                    dir = new File(absoluteFeederDir);
                    this.deleteDirAndContents(dir, false);
                    dir.mkdirs();
                }
                if (feederDir != null && feederDir.length() > 0) {
                    dir = new File(feederDirName);
                    this.deleteDirAndContents(dir, false);
                    dir.mkdirs();
                }
            }
            if (clearEater != null && Boolean.valueOf(clearEater).equals(Boolean.TRUE)) {
                if (absoluteEaterDir != null && absoluteEaterDir.length() > 0) {
                    dir = new File(absoluteEaterDir);
                    this.deleteDirAndContents(dir, false);
                    dir.mkdirs();
                }
                if (eaterDir != null && eaterDir.length() > 0) {
                    dir = new File(eaterDirName);
                    this.deleteDirAndContents(dir, false);
                    dir.mkdirs();
                }
            }
            this.copyFile(new File(inputFile), new File(feederFile));
            boolean filePresent = this.waitForfile(testRunOutputFile, testTimeoutSecs);
            if (!filePresent) {
                ConfiguredTest.fail((String)("Timed out waiting for file " + testRunOutputFile + " to appear"));
            }
            ByteArrayOutputStream outputStream = this.getFileContentsAsOS(testRunOutputFile);
            File testExpectedOutputFile = new File(expectedOutputFile);
            this.checkExpectedOutput(logPrefix, logDetails, outputStream, testExpectedOutputFile, comparisonType);
            System.out.println(" Passed.");
        }
        catch (Exception ex) {
            System.out.println(" Failed.");
            throw ex;
        }
        catch (Error er) {
            System.out.println(" Failed.");
            throw er;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testFtpRequest() throws Exception {
        String description = this.mProperties.getProperty("test.desc");
        String clearInputDir = this.mProperties.getProperty("clear.input.dir");
        String clearOutputDir = this.mProperties.getProperty("clear.output.dir");
        String inputDir = this.mProperties.getProperty("input.dir");
        String outputDir = this.mProperties.getProperty("output.dir");
        String comparisonType = this.mProperties.getProperty("comparisontype");
        String testPropertiesFile = this.mProperties.getProperty("testpropertiesfilename");
        String dataDir = this.mProperties.getProperty("data.dir");
        String expectedOutputDir = this.mProperties.getProperty("expected.dir");
        String testTimeoutStr = this.mProperties.getProperty("testtimeout");
        String testCaseDirectoryFullPath = this.mProperties.getProperty("absoluteinputdir");
        String testCaseDirectory = this.mProperties.getProperty("inputdirname");
        String debugStr = this.mProperties.getProperty("debug");
        String inputCountStr = this.mProperties.getProperty("number.input");
        String outputCountStr = this.mProperties.getProperty("number.output");
        String inputFilter = this.mProperties.getProperty("filter.input");
        String outputFilter = this.mProperties.getProperty("filter.output");
        String expectedFilter = this.mProperties.getProperty("filter.expected");
        String relaxStr = this.mProperties.getProperty("relax");
        String cleanupStr = this.mProperties.getProperty("cleanup");
        int inputCount = 0;
        int outputCount = 0;
        String featureProgressVal = this.mProperties.getProperty(TEST_IN_PROGRESS_KEY);
        if (featureProgressVal != null && featureProgressVal.equals(TEST_IN_PROGRESS_VAL)) {
            System.out.println("Test ".concat(testCaseDirectory).concat("\\").concat(testPropertiesFile).concat(" in Development"));
            return;
        }
        boolean relax = relaxStr != null && relaxStr.equalsIgnoreCase("true");
        boolean cleanup = cleanupStr != null && cleanupStr.equalsIgnoreCase("true");
        boolean logDetails = false;
        if (debugStr != null && Boolean.valueOf(debugStr) == Boolean.TRUE) {
            logDetails = true;
        }
        int testTimeoutSecs = 0;
        if (testTimeoutStr != null) {
            testTimeoutSecs = Integer.parseInt(testTimeoutStr);
        }
        if ("true".equals(System.getProperty("inDebug"))) {
            testTimeoutSecs = 0;
        }
        if (inputCountStr != null) {
            inputCount = Integer.parseInt(inputCountStr);
        }
        if (outputCountStr != null) {
            outputCount = Integer.parseInt(outputCountStr);
        }
        String dirIn = null;
        String dirOut = null;
        String dirData = null;
        String dirExpected = null;
        String logPrefix = testCaseDirectory + "\\" + testPropertiesFile + ":";
        try {
            if (logDetails) {
                System.out.println("testFtpRequest Running " + testPropertiesFile + " : " + description);
            }
            dirIn = testCaseDirectoryFullPath + File.separator + inputDir;
            File dirInObj = new File(dirIn);
            if (clearInputDir != null && Boolean.valueOf(clearInputDir).equals(Boolean.TRUE) && dirIn != null && dirIn.length() > 0) {
                this.deleteDirAndContents(dirInObj, false);
                dirInObj.mkdirs();
            }
            dirOut = testCaseDirectoryFullPath + File.separator + outputDir;
            File dirOutObj = new File(dirOut);
            if (clearOutputDir != null && Boolean.valueOf(clearOutputDir).equals(Boolean.TRUE) && dirOut != null && dirOut.length() > 0) {
                this.deleteDirAndContents(dirOutObj, false);
                dirOutObj.mkdirs();
            }
            dirData = testCaseDirectoryFullPath + File.separator + dataDir;
            dirExpected = testCaseDirectoryFullPath + File.separator + expectedOutputDir;
            int inputCopied = 0;
            if (inputCount > 0) {
                inputCopied = this.copyFiles(dirData, dirIn);
                if (logDetails) {
                    System.out.print("Test ".concat(testCaseDirectory).concat("\\").concat(testPropertiesFile).concat(inputCount + " input required..." + inputCopied + " feeded..."));
                    System.out.flush();
                }
            } else if (logDetails) {
                System.out.print("Test ".concat(testCaseDirectory).concat("\\").concat(testPropertiesFile).concat(" no input required..."));
                System.out.flush();
            }
            if (logDetails) {
                System.out.println(inputCount + " message copied to from [" + dirData + "] to [" + dirIn + "]");
            }
            RegexFileFilter outputFileFilter = new RegexFileFilter(outputFilter);
            if (outputCount > 0) {
                int outputReceived = this.waitForOutput(dirOutObj, testTimeoutSecs, outputCount, outputFileFilter);
                if (outputReceived < outputCount) {
                    if (!relax) {
                        if (cleanup) {
                            if (logDetails) {
                                System.out.println("clean up the input output directories....");
                            }
                            this.emptyDir(dirOutObj);
                            this.emptyDir(dirInObj);
                        }
                        ConfiguredTest.fail((String)("Timed out waiting for outputs to appear in directory [" + dirOutObj.getPath() + "]"));
                    } else if (outputReceived == 0) {
                        if (cleanup) {
                            if (logDetails) {
                                System.out.println("clean up the input output directories....");
                            }
                            this.emptyDir(dirOutObj);
                            this.emptyDir(dirInObj);
                        }
                        ConfiguredTest.fail((String)("Timed out waiting for outputs to appear in directory [" + dirOutObj.getPath() + "]"));
                    }
                    if (logDetails) {
                        System.out.println("+++++ ============ got some of the expected outputs =========== ++++++");
                    }
                } else if (logDetails) {
                    System.out.println(outputCount + " expected in [" + dirOut + "] " + outputReceived + " received before time out");
                }
                if (COMPARISON_TYPE_EQUALS.equals(comparisonType)) {
                    if (expectedFilter == null) {
                        throw new Exception("filter.expected not specified, required for XML result compare.");
                    }
                    RegexFileFilter expectedFileFilter = new RegexFileFilter(expectedFilter);
                    File dirExpectedObj = new File(dirExpected);
                    File[] expected = dirExpectedObj.listFiles(expectedFileFilter);
                    File[] outputs = dirOutObj.listFiles(outputFileFilter);
                    if (outputs.length != 1 || expected.length != 1) throw new Exception("When comparison type is XML equal - expect 1 output and 1 expected - but # of output =" + outputs.length + "and # of expected =" + expected.length);
                    String outXML = ConfiguredTest.getFileContents(outputs[0]);
                    String expXML = ConfiguredTest.getFileContents(expected[0]);
                    if (outXML == null || outXML.trim().length() == 0) {
                        throw new Exception("NULL content from output file: " + outputs[0].getAbsolutePath());
                    }
                    if (expXML == null || expXML.trim().length() == 0) {
                        throw new Exception("NULL content from expected file: " + expected[0].getAbsolutePath());
                    }
                    boolean isEqual = this.testCompareXMLIdentical(outXML, expXML);
                    if (logDetails) {
                        System.out.print("XML compare = " + isEqual);
                    }
                    ConfiguredTest.assertTrue((String)"Result not equal to expected ...", (boolean)isEqual);
                } else {
                    this.checkExpectedOutput(logPrefix, logDetails, dirOut, dirIn, dirExpected, outputFileFilter, comparisonType, cleanup, relax, logDetails);
                }
            } else if (logDetails) {
                System.out.print("Test ".concat(testCaseDirectory).concat("\\").concat(testPropertiesFile).concat(inputCount + " no output expected..."));
                System.out.flush();
            }
            if (cleanup) {
                if (logDetails) {
                    System.out.println("clean up the input output directories....");
                }
                this.emptyDir(dirOutObj);
                this.emptyDir(dirInObj);
            }
            System.out.println();
            System.out.println("Test ".concat(testCaseDirectory).concat("\\").concat(testPropertiesFile).concat(" Passed."));
            System.out.flush();
            return;
        }
        catch (Exception ex) {
            System.out.println();
            System.out.println("Test ".concat(testCaseDirectory).concat("\\").concat(testPropertiesFile).concat(" Failed."));
            System.out.flush();
            if (!logDetails) throw ex;
            ex.printStackTrace();
            throw ex;
        }
        catch (Error er) {
            System.out.println();
            System.out.println("Test ".concat(testCaseDirectory).concat("\\").concat(testPropertiesFile).concat(" Failed."));
            System.out.flush();
            if (!logDetails) throw er;
            er.printStackTrace();
            throw er;
        }
    }

    void checkExpectedOutput(String logPrefix, boolean logDetails, String dirOut, String dirIn, String dirExpected, RegexFileFilter outputFilter, String comparisonType, boolean cleanup, boolean relax, boolean debug) throws IOException {
        boolean isEmptyOutputAllowed = false;
        if (comparisonType != null && comparisonType.startsWith("#")) {
            isEmptyOutputAllowed = true;
            comparisonType = comparisonType.substring(1);
        }
        File dirOutObj = new File(dirOut);
        File dirInObj = new File(dirIn);
        File dirExpectedObj = new File(dirExpected);
        String inputDirName = this.mProperties.getProperty("inputdirname");
        File actualOutputDir = new File(dirOutObj.getParent() + "/../results/" + inputDirName);
        if (actualOutputDir.exists()) {
            if (!actualOutputDir.isDirectory()) {
                return;
            }
        } else {
            actualOutputDir.mkdir();
        }
        if (COMPARISON_TYPE_BINARY.equals(comparisonType) || COMPARISON_TYPE_EQUALS.equals(comparisonType)) {
            System.out.println("Only supports IDENTICAL comparison !!!!!!!!!!!!!!");
            comparisonType = COMPARISON_TYPE_IDENTICAL;
        }
        if (comparisonType.equals(COMPARISON_TYPE_IDENTICAL)) {
            File[] expected = dirExpectedObj.listFiles();
            File[] outputs = dirOutObj.listFiles(outputFilter);
            for (int i = 0; i < outputs.length; ++i) {
                String outMsg = ConfiguredTest.getFileContents(outputs[i]);
                boolean found = false;
                for (int j = 0; j < expected.length; ++j) {
                    File exp = expected[j];
                    if (exp == null || exp.isDirectory()) continue;
                    String expMsg = ConfiguredTest.getFileContents(exp);
                    if (outMsg.length() != expMsg.length() || !outMsg.equals(expMsg)) continue;
                    found = true;
                    expected[j] = null;
                    break;
                }
                if (!found && cleanup) {
                    if (debug) {
                        System.out.println("clean up the input output directories....");
                    }
                    this.emptyDir(dirOutObj);
                    this.emptyDir(dirInObj);
                }
                ConfiguredTest.assertTrue((String)("Output message " + outputs[i].getPath() + " is not found among expected."), (boolean)found);
            }
        } else {
            System.out.println("For FTP BC driver tests, only supports idenitcal comparison between outputs and expected outputs, unsupported comparison type:[" + comparisonType + "]");
        }
    }

    void sendAndCheck(String logPrefix, boolean logDetails, String destination, File testMsgFile, File testExpectedOutputFile, String expectedHttpStatus, String expectedHttpWarning, String comparisonType, String soapAction) throws Exception {
        if (logDetails) {
            System.out.println(logPrefix + " destination: " + destination + " input message file: " + testMsgFile.getAbsolutePath() + " comparison output file: " + testExpectedOutputFile.getAbsolutePath());
        }
        SOAPMessage message = this.loadMessage(logPrefix, logDetails, testMsgFile);
        SOAPMessage response = this.sendMessage(logPrefix, logDetails, destination, message, expectedHttpStatus, expectedHttpWarning, soapAction);
        this.checkExpectedOutput(logPrefix, logDetails, response, testExpectedOutputFile, comparisonType);
    }

    void sendAndCheck(String logPrefix, boolean logDetails, String destination, String testMsgFileName, String testExpectedOutputFileName, String expectedHttpStatus, String expectedHttpWarning, String comparisonType, String soapAction) throws Exception {
        if (logDetails) {
            System.out.println(logPrefix + " destination: " + destination + " input message file: " + testMsgFileName + " comparison output file: " + testExpectedOutputFileName);
        }
        SOAPMessage message = this.loadMessage(logPrefix, logDetails, testMsgFileName);
        SOAPMessage response = this.sendMessage(logPrefix, logDetails, destination, message, expectedHttpStatus, expectedHttpWarning, soapAction);
        this.checkExpectedOutput(logPrefix, logDetails, response, testExpectedOutputFileName, comparisonType);
    }

    SOAPMessage loadMessage(String logPrefix, boolean logDetails, File testMsgFile) throws SOAPException, IOException {
        SOAPMessage message = this.mMessageFactory.createMessage();
        SOAPPart soapPart = message.getSOAPPart();
        StreamSource preppedMsgSrc = new StreamSource(new FileInputStream(testMsgFile));
        soapPart.setContent((Source)preppedMsgSrc);
        message.saveChanges();
        if (logDetails) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            message.writeTo((OutputStream)os);
            System.out.println("\n" + logPrefix + " REQUEST:\n" + ((Object)os).toString() + "\n");
        }
        return message;
    }

    SOAPMessage loadMessage(String logPrefix, boolean logDetails, String testMsgFileName) throws SOAPException, IOException {
        SOAPMessage message = this.mMessageFactory.createMessage();
        SOAPPart soapPart = message.getSOAPPart();
        StreamSource preppedMsgSrc = new StreamSource(new FileInputStream(testMsgFileName));
        soapPart.setContent((Source)preppedMsgSrc);
        message.saveChanges();
        if (logDetails) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            message.writeTo((OutputStream)os);
            System.out.println("\n" + logPrefix + " REQUEST:\n" + ((Object)os).toString() + "\n");
        }
        return message;
    }

    SOAPMessage sendMessage(String logPrefix, boolean logDetails, String destination, SOAPMessage message, String expectedHttpStatus, String expectedHttpWarning, String soapAction) throws SOAPException, Exception {
        if (soapAction != null) {
            MimeHeaders hd = message.getMimeHeaders();
            hd.setHeader("SOAPAction", soapAction);
        }
        PrintStream origErr = null;
        ByteArrayOutputStream bufferedErr = null;
        PrintStream stdErr = null;
        if (expectedHttpStatus != null && !expectedHttpStatus.startsWith("2") || expectedHttpWarning != null) {
            origErr = System.err;
            bufferedErr = new ByteArrayOutputStream();
            stdErr = new PrintStream(bufferedErr);
            System.setErr(stdErr);
        }
        SOAPMessage reply = null;
        long start = 0L;
        if (logDetails) {
            start = System.currentTimeMillis();
        }
        if (destination.indexOf("${") != -1 && destination.indexOf("}") != -1) {
            String nbUserDir = System.getProperty("NetBeansUserDir");
            ServerInstance serverInstance = ConfiguredTest.getServerInstance(nbUserDir);
            if (serverInstance == null) {
                throw new RuntimeException("Unknown server instance.");
            }
            String httpDefaultPort = "HttpDefaultPort";
            if (destination.indexOf("${" + httpDefaultPort + "}") != -1) {
                try {
                    ConfigurationService configService = AdministrationServiceHelper.getConfigurationService((ServerInstance)serverInstance);
                    Map configMap = configService.getComponentConfigurationAsMap("sun-http-binding", "server");
                    Object httpDefaultPortValue = configMap.get(httpDefaultPort);
                    System.out.println("");
                    if (httpDefaultPortValue != null) {
                        int httpDefaultPortIntValue = Integer.parseInt(httpDefaultPortValue.toString());
                        if (httpDefaultPortIntValue != -1) {
                            destination = destination.replace("${" + httpDefaultPort + "}", "" + httpDefaultPortIntValue);
                            System.out.println("Replace '${HttpDefaultPort}' in WSDL soap location by '" + httpDefaultPortIntValue + "' defined in sun-http-binding.");
                        } else {
                            System.out.println("WARNING: 'HttpDefaultPort' is not defined in sun-http-binding.");
                        }
                    } else {
                        System.out.println("WARNING: 'HttpDefaultPort' is not found in sun-http-binding's component configuration.");
                    }
                }
                catch (Exception ex) {
                    if (stdErr != null) {
                        System.setErr(origErr);
                        stdErr.flush();
                        stdErr.close();
                        origErr.print(bufferedErr.toString());
                    }
                    throw ex;
                }
            }
            String httpsDefaultPort = "HttpsDefaultPort";
            if (destination.indexOf("${" + httpsDefaultPort + "}") != -1) {
                try {
                    ConfigurationService configService = AdministrationServiceHelper.getConfigurationService((ServerInstance)serverInstance);
                    Map configMap = configService.getComponentConfigurationAsMap("sun-http-binding", "server");
                    Object httpsDefaultPortValue = configMap.get(httpsDefaultPort);
                    System.out.println("");
                    if (httpsDefaultPortValue != null) {
                        int httpsDefaultPortIntValue = Integer.parseInt(httpsDefaultPortValue.toString());
                        if (httpsDefaultPortIntValue != -1) {
                            destination = destination.replace("${" + httpsDefaultPort + "}", "" + httpsDefaultPortIntValue);
                            System.out.println("Replace '${HttpsDefaultPort}' in WSDL soap location by '" + httpsDefaultPortIntValue + "' defined in sun-http-binding.");
                        } else {
                            System.out.println("WARNING: 'HttpsDefaultPort' is not defined in sun-http-binding.");
                        }
                    } else {
                        System.out.println("WARNING: 'HttpsDefaultPort' is not found in sun-http-binding's component configuration.");
                    }
                }
                catch (Exception ex) {
                    if (stdErr != null) {
                        System.setErr(origErr);
                        stdErr.flush();
                        stdErr.close();
                        origErr.print(bufferedErr.toString());
                    }
                    throw ex;
                }
            }
        }
        boolean httpSuccess = true;
        try {
            reply = this.mConnection.call(message, (Object)destination);
        }
        catch (SOAPException ex) {
            httpSuccess = false;
            if (expectedHttpStatus == null || expectedHttpWarning != null && bufferedErr.toString().indexOf(expectedHttpWarning) < 0) {
                if (stdErr != null) {
                    System.setErr(origErr);
                    stdErr.flush();
                    stdErr.close();
                    origErr.print(bufferedErr.toString());
                }
                throw ex;
            }
            if (ex.getMessage().indexOf(expectedHttpStatus) > -1) {
                if (logDetails) {
                    System.out.println(logPrefix + " Expected HTTP status code " + expectedHttpStatus + " found in reply. ");
                }
            }
            if (stdErr != null) {
                System.setErr(origErr);
                stdErr.flush();
                stdErr.close();
                origErr.print(bufferedErr.toString());
            }
            ConfiguredTest.fail((String)(logPrefix + " Expected HTTP status code " + expectedHttpStatus + " NOT found in reply: " + ex.getMessage()));
        }
        long end = 0L;
        if (logDetails) {
            end = System.currentTimeMillis();
        }
        if (origErr != null) {
            System.setErr(origErr);
            if (stdErr != null) {
                stdErr.close();
            }
        }
        if (logDetails) {
            System.out.println(logPrefix + " Call took " + (end - start) + " ms");
        }
        if (expectedHttpStatus != null && httpSuccess && !expectedHttpStatus.startsWith("2")) {
            ConfiguredTest.fail((String)(logPrefix + " Call returned an unexpected 'success' HTTP status code instead of the expected HTTP status code " + expectedHttpStatus));
        }
        return reply;
    }

    void checkExpectedOutput(String logPrefix, boolean logDetails, SOAPMessage reply, File testExpectedOutputFile, String comparisonType) throws IOException, TransformerException, SAXException, ParserConfigurationException, SOAPException {
        if (testExpectedOutputFile != null) {
            ByteArrayOutputStream outputStream = ConfiguredTest.replyAsByteArrayOS(logPrefix, logDetails, reply);
            this.checkExpectedOutput(logPrefix, logDetails, outputStream, testExpectedOutputFile, comparisonType);
        }
    }

    void checkExpectedOutput(String logPrefix, boolean logDetails, SOAPMessage reply, String testExpectedOutputFileName, String comparisonType) throws IOException, TransformerException, SAXException, ParserConfigurationException, SOAPException {
        if (testExpectedOutputFileName == null || EMPTY.equals(testExpectedOutputFileName)) {
            return;
        }
        ByteArrayOutputStream outputStream = ConfiguredTest.replyAsByteArrayOS(logPrefix, logDetails, reply);
        File testExpectedOutputFile = new File(testExpectedOutputFileName);
        this.checkExpectedOutput(logPrefix, logDetails, outputStream, testExpectedOutputFile, comparisonType);
    }

    void checkExpectedOutput(String logPrefix, boolean logDetails, ByteArrayOutputStream outputStream, File testExpectedOutputFile, String comparisonType) throws IOException, SAXException, ParserConfigurationException {
        boolean isEmptyOutputAllowed = false;
        if (comparisonType != null && comparisonType.startsWith("#")) {
            isEmptyOutputAllowed = true;
            comparisonType = comparisonType.substring(1);
        }
        String testXML = outputStream.toString("UTF-8").trim();
        testXML = testXML.replaceFirst("xmlns:xsd=\"http://www.w3.org/1999/XMLSchema\"", "xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        if ((testXML = testXML.replaceFirst("xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\"", "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://schemas.xmlsoap.org/soap/envelope/ http://schemas.xmlsoap.org/soap/envelope/\"")).indexOf("xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"") == -1) {
            testXML = testXML.replaceFirst("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\">", "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://schemas.xmlsoap.org/soap/envelope/ http://schemas.xmlsoap.org/soap/envelope/\">");
        }
        if (isEmptyOutputAllowed && EMPTY.equals(testXML)) {
            return;
        }
        String inputDirName = this.mProperties.getProperty("inputdirname");
        File actualOutputDir = new File(testExpectedOutputFile.getParent() + "/../results/" + inputDirName);
        if (actualOutputDir.exists()) {
            if (!actualOutputDir.isDirectory()) {
                return;
            }
        } else {
            actualOutputDir.mkdir();
        }
        String testExpectedOutputAbsoluteFileName = testExpectedOutputFile.getAbsolutePath();
        String controlXML = null;
        try {
            controlXML = ConfiguredTest.getFileContents(testExpectedOutputAbsoluteFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String string = controlXML = controlXML == null ? EMPTY : controlXML.trim();
        if (isEmptyOutputAllowed && EMPTY.equals(testXML) && EMPTY.equals(controlXML)) {
            return;
        }
        if (!COMPARISON_TYPE_BINARY.equals(comparisonType) && !COMPARISON_TYPE_EQUALS.equals(comparisonType)) {
            comparisonType = COMPARISON_TYPE_IDENTICAL;
        }
        if (comparisonType.equals(COMPARISON_TYPE_EQUALS)) {
            boolean isSimilar = false;
            isSimilar = !controlXML.equals(EMPTY) ? this.testCompareXMLEquals(controlXML, testXML) : testXML.equals(EMPTY);
            if (!isSimilar || this.mGenerateOutputOnSuccess) {
                File actualOutputFile = ConfiguredTest.getActualOutputFile(actualOutputDir, isSimilar);
                ConfiguredTest.writeToFile(actualOutputFile, this.removeIndent(ConfiguredTest.formatString(testXML, this.mIndent), this.mIndent));
                String timeStampPrefix = ConfiguredTest.getActualOutputTimeStampPrefix(actualOutputFile);
                ConfiguredTest.assertTrue((String)(timeStampPrefix + " The response is not similar enough to be considered 'equal' to the expected output."), (boolean)isSimilar);
            }
        } else if (comparisonType.equals(COMPARISON_TYPE_IDENTICAL)) {
            boolean isIdentical = false;
            isIdentical = !controlXML.equals(EMPTY) ? this.testCompareXMLIdentical(controlXML, testXML) : testXML.equals(EMPTY);
            if (!isIdentical || this.mGenerateOutputOnSuccess) {
                File actualOutputFile = ConfiguredTest.getActualOutputFile(actualOutputDir, isIdentical);
                ConfiguredTest.writeToFile(actualOutputFile, this.removeIndent(ConfiguredTest.formatString(testXML, this.mIndent), this.mIndent));
                String timeStampPrefix = ConfiguredTest.getActualOutputTimeStampPrefix(actualOutputFile);
                ConfiguredTest.assertTrue((String)(timeStampPrefix + " The response is not identical to the expected output."), (boolean)isIdentical);
            }
        } else if (comparisonType.equals(COMPARISON_TYPE_BINARY)) {
            boolean isFailure;
            if (logDetails) {
                System.out.println(logPrefix + " Test expected output message file: " + testExpectedOutputFile.getAbsolutePath());
            }
            FileInputStream fis = new FileInputStream(testExpectedOutputFile);
            byte[] output = outputStream.toByteArray();
            byte[] compare = new byte[output.length];
            int bytesRead = fis.read(compare);
            int nextByte = fis.read();
            fis.close();
            if (bytesRead == -1) {
                ConfiguredTest.writeToFile(testExpectedOutputFile, output);
                ConfiguredTest.assertTrue((String)OVERWRITE_EMPTY_OUTPUT_MSG, (boolean)false);
                return;
            }
            boolean responseIsTooLong = bytesRead != -1;
            boolean responseIsTooShort = nextByte == -1;
            boolean responseNotMatch = !Arrays.equals(output, compare);
            boolean bl = isFailure = responseIsTooLong || responseIsTooShort || responseNotMatch;
            if (isFailure || this.mGenerateOutputOnSuccess) {
                File actualOutputFile = ConfiguredTest.getActualOutputFile(actualOutputDir, !isFailure);
                ConfiguredTest.writeToFile(actualOutputFile, output);
                String timeStampPrefix = ConfiguredTest.getActualOutputTimeStampPrefix(actualOutputFile);
                ConfiguredTest.assertFalse((String)(timeStampPrefix + " " + logPrefix + " The response is longer than expected."), (boolean)responseIsTooLong);
                ConfiguredTest.assertFalse((String)(timeStampPrefix + " " + logPrefix + " The response is shorter than expected."), (boolean)responseIsTooShort);
                ConfiguredTest.assertFalse((String)(timeStampPrefix + " " + logPrefix + " The response received does not match the expected response."), (boolean)responseNotMatch);
            }
            if (logDetails && !isFailure) {
                System.out.println(logPrefix + " Success: response matches expected output.");
            }
        }
    }

    private static File getActualOutputFile(File actualOutputDir, boolean success) {
        String actualOutputFileName = "Actual_" + mSDF.format(new Date()) + (success ? "_S" : "_F") + ".xml";
        return new File(actualOutputDir, actualOutputFileName);
    }

    private static String getActualOutputTimeStampPrefix(File actualOutputFile) {
        String timeStamp;
        String fileName = actualOutputFile.getName();
        try {
            String yearStr = fileName.substring(7, 11);
            String monthStr = fileName.substring(11, 13);
            String dayStr = fileName.substring(13, 15);
            String hourStr = fileName.substring(15, 17);
            String minuteStr = fileName.substring(17, 19);
            String secondStr = fileName.substring(19, 21);
            int year = Integer.parseInt(yearStr);
            int month = Integer.parseInt(monthStr);
            int day = Integer.parseInt(dayStr);
            int hour = Integer.parseInt(hourStr);
            int minute = Integer.parseInt(minuteStr);
            int second = Integer.parseInt(secondStr);
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, month - 1, day, hour, minute, second);
            Date date = calendar.getTime();
            Object[] arguments = new Object[]{date};
            String pattern = "{0, date} {0, time}";
            timeStamp = MessageFormat.format(pattern, arguments);
        }
        catch (Exception e) {
            timeStamp = "<Unknown Time Stamp>";
        }
        return "[" + timeStamp + "]";
    }

    static String formatString(String inStr, String indent) throws IOException, UnsupportedEncodingException {
        String inputStr = inStr;
        try {
            inputStr = xdmUtil.prettyPrintXML(inputStr, indent);
        }
        catch (UnsupportedEncodingException ex) {
            System.out.println(ex.toString());
            ex.printStackTrace();
            throw ex;
        }
        catch (BadLocationException ex) {
            System.out.println(" BadLocation from formatting xml.");
        }
        catch (IOException ex) {
            System.out.println(" Failed.");
            throw ex;
        }
        return inputStr;
    }

    static String formatString(File file) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", new Integer(2));
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StreamSource source = new StreamSource(file);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        transformer.transform(source, new StreamResult(out));
        try {
            return out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static ByteArrayOutputStream replyAsByteArrayOS(String logPrefix, boolean logDetails, SOAPMessage reply) throws TransformerException, SOAPException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", new Integer(2));
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (reply != null) {
            SOAPPart replySOAPPart = reply.getSOAPPart();
            Source sourceContent = replySOAPPart.getContent();
            try {
                StreamResult result = new StreamResult(new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, "UTF-8")));
                transformer.transform(sourceContent, result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (logDetails) {
            System.out.println("\n" + logPrefix + " RESPONSE:\n" + outputStream.toString());
        }
        return outputStream;
    }

    public static String getFileContents(String fileName) throws IOException {
        int chunksize = 512;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8");
        StringBuffer output = new StringBuffer();
        char[] buff = new char[chunksize];
        int len = reader.read(buff);
        while (len > 0) {
            output.append(buff, 0, len);
            len = reader.read(buff);
        }
        return output.toString();
    }

    ByteArrayOutputStream getFileContentsAsOS(String fileName) throws IOException {
        int i;
        FileInputStream in = new FileInputStream(fileName);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((i = ((InputStream)in).read()) != -1) {
            out.write(i);
        }
        ((InputStream)in).close();
        return out;
    }

    static void writeToFile(File file, byte[] content) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(content), "UTF-8");
            char[] buf = new char[512];
            int n = 0;
            while ((n = reader.read(buf)) != -1) {
                writer.write(buf, 0, n);
            }
            writer.flush();
        }
        catch (Exception e) {
            try {
                writer.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    static void writeToFile(File file, String content) {
        FileOutputStream writer = null;
        try {
            writer = new FileOutputStream(file);
            writer.write(content.getBytes("UTF-8"));
            writer.flush();
        }
        catch (Exception e) {
            try {
                writer.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    static String getFileContents(File file) throws IOException {
        int chunksize = 512;
        FileReader reader = new FileReader(file);
        StringBuffer output = new StringBuffer();
        char[] buff = new char[chunksize];
        int len = reader.read(buff);
        while (len > 0) {
            output.append(buff, 0, len);
            len = reader.read(buff);
        }
        return output.toString();
    }

    static Properties loadProperties(String propertiesFile) throws IOException {
        Properties props = new Properties();
        EditableProperties editableProps = new EditableProperties();
        editableProps.load(new FileInputStream(propertiesFile));
        for (String key : editableProps.keySet()) {
            props.put(key, editableProps.getProperty(key));
        }
        return props;
    }

    void copyFile(File in, File out) throws IOException {
        FileChannel sourceChannel = new FileInputStream(in).getChannel();
        FileChannel destinationChannel = new FileOutputStream(out).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
        sourceChannel.close();
        destinationChannel.close();
    }

    int copyFiles(String srcDir, String destDir) throws IOException, Exception {
        int count = 0;
        File src = new File(srcDir);
        File dest = new File(destDir);
        if (src.isDirectory() && dest.isDirectory()) {
            File[] msgFiles = src.listFiles();
            if (msgFiles != null && msgFiles.length > 0) {
                for (int i = 0; i < msgFiles.length; ++i) {
                    if (msgFiles[i].isDirectory()) continue;
                    ++count;
                    File destFile = new File(dest, msgFiles[i].getName());
                    FileChannel sourceChannel = new FileInputStream(msgFiles[i]).getChannel();
                    FileChannel destinationChannel = new FileOutputStream(destFile).getChannel();
                    sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
                    sourceChannel.close();
                    destinationChannel.close();
                }
            }
        } else {
            throw new Exception("copyFiles(srcDir, destDir) requires that both srcDir and destDir be directory.");
        }
        return count;
    }

    boolean deleteDirAndContents(File path, boolean recursive) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    if (!recursive) continue;
                    this.deleteDirAndContents(files[i], recursive);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    void emptyDir(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile()) continue;
                boolean b = files[i].delete();
            }
        }
    }

    boolean waitForfile(String fileNameToWaitFor, int testTimeoutSecs) throws InterruptedException {
        File fileToWaitFor = new File(fileNameToWaitFor);
        long timeLimit = System.currentTimeMillis() + (long)(testTimeoutSecs * 1000);
        boolean timedout = false;
        while (!fileToWaitFor.exists() && !timedout) {
            Thread.sleep(1000L);
            if (testTimeoutSecs <= 0 || System.currentTimeMillis() <= timeLimit) continue;
            timedout = true;
        }
        return !timedout;
    }

    int waitForOutput(File outDir, int testTimeoutSecs, int expectedCount, RegexFileFilter outputFilter) throws InterruptedException {
        long timeLimit = System.currentTimeMillis() + (long)(testTimeoutSecs * 1000);
        int received = 0;
        boolean timedout = false;
        File[] entries = null;
        while (!timedout) {
            Thread.sleep(1000L);
            if (testTimeoutSecs > 0 && System.currentTimeMillis() > timeLimit) {
                timedout = true;
            }
            if ((entries = outDir.listFiles(outputFilter)) == null || entries.length < expectedCount) continue;
            received = entries.length;
            break;
        }
        return received;
    }

    public void testN2MInboundSOAPRequest() throws Exception {
        String description = this.mProperties.getProperty("description");
        String destination = this.mProperties.getProperty("destination");
        String testPropertiesFileName = this.mProperties.getProperty("testpropertiesfilename");
        String inputDir = this.mProperties.getProperty("absoluteinputdir");
        String inputDirName = this.mProperties.getProperty("inputdirname");
        String featureProgressVal = this.mProperties.getProperty(TEST_IN_PROGRESS_KEY);
        if (featureProgressVal != null && featureProgressVal.equals(TEST_IN_PROGRESS_VAL)) {
            System.out.println("Test " + inputDirName + "\\" + testPropertiesFileName + " in Development");
            return;
        }
        System.out.print("Test " + inputDirName + "\\" + testPropertiesFileName);
        try {
            int i;
            Output output;
            int inputCount = Integer.parseInt(this.mProperties.getProperty("input.count"));
            HashMap<String, Input> inputTable = new HashMap<String, Input>();
            for (int i2 = 0; i2 < inputCount; ++i2) {
                String name = "input." + i2;
                String action = this.mProperties.getProperty(name + ".action");
                String dataFile = inputDir + File.separator + this.mProperties.getProperty(name + ".dataFile");
                String templateFile = inputDir + File.separator + this.mProperties.getProperty(name + ".templateFile");
                int batchSize = Integer.parseInt(this.mProperties.getProperty(name + ".batchSize"));
                inputTable.put(name, new Input(name, action, templateFile, dataFile, batchSize));
            }
            int outputCount = Integer.parseInt(this.mProperties.getProperty("output.count"));
            HashMap<String, Output> outputTable = new HashMap<String, Output>();
            for (int i3 = 0; i3 < outputCount; ++i3) {
                String name = "output." + i3;
                File actual = new File(inputDir, this.mProperties.getProperty(name + ".actualResultFile"));
                File expected = new File(inputDir, this.mProperties.getProperty(name + ".expectedResultFile"));
                output = new Output(name, actual, expected);
                output.removeActual();
                outputTable.put(name, output);
            }
            File scriptFile = new File(inputDir + File.separator + this.mProperties.getProperty("scriptFile"));
            List taskList = this.loadScript(scriptFile, inputTable);
            int I = taskList.size();
            for (i = 0; i < I; ++i) {
                Runnable r = (Runnable)taskList.get(i);
                r.run();
            }
            for (i = 0; i < outputCount; ++i) {
                String name = "output." + i;
                output = (Output)outputTable.get(name);
                String exp = output.getExpectedWithoutCRNL();
                String act = output.getActualWithoutCRNL();
                ConfiguredTest.assertEquals((String)name, (String)exp, (String)act);
                output.removeActual();
            }
            System.out.println(" Passed.");
        }
        catch (Exception ex) {
            System.out.println(" Failed.");
            throw ex;
        }
        catch (Error er) {
            System.out.println(" Failed.");
            throw er;
        }
    }

    public boolean testCompareXMLEquals(String controlStr, String actualStr) {
        return this.testCompareXMLIdentical(controlStr, actualStr, XDMUtil.ComparisonCriteria.EQUAL);
    }

    public boolean testCompareXMLIdentical(String controlStr, String actualStr) {
        return this.testCompareXMLIdentical(controlStr, actualStr, XDMUtil.ComparisonCriteria.IDENTICAL);
    }

    public boolean testCompareXMLIdentical(String controlStr, String actualStr, XDMUtil.ComparisonCriteria aCriteria) {
        boolean result = false;
        try {
            List diffs = xdmUtil.compareXML(controlStr, actualStr, aCriteria);
            this.filterEnvelopeNSDiffs(diffs);
            this.filterNSPrefixDiffs(diffs);
            this.filterAttrWhitespaceDiffs(diffs);
            this.filterAttributeOrderChange(diffs);
            this.filterEmptySoapHeaderElements(diffs);
            if (diffs.size() == 0) {
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private Map concurrentCorrelationBuildInfo(Properties properties) throws Exception {
        HashMap invokePropertiesMap = new HashMap();
        String tokens = properties.getProperty("invokeList");
        StringTokenizer st = new StringTokenizer(tokens, ",");
        while (st.hasMoreTokens()) {
            this.concurrentCorrelationAddToInvokeList(invokePropertiesMap, st.nextToken().trim());
        }
        return invokePropertiesMap;
    }

    private void concurrentCorrelationAddToInvokeList(Map invokePropertiesMap, String key) throws Exception {
        String destination;
        String inputFileTemplateString = "";
        String outputFileTemplateString = "";
        ArrayList inputValueList = null;
        ArrayList outputValueList = null;
        Object soapActionValueList = null;
        Object destinationValueList = null;
        inputValueList = new ArrayList();
        outputValueList = new ArrayList();
        String soapAction = this.mProperties.getProperty(key + ".soapAction");
        if (soapAction == null) {
            soapAction = "";
        }
        if ((destination = this.mProperties.getProperty(key + ".destination")) == null) {
            throw new Exception("destination not defined for " + key);
        }
        InputStreamReader fileReader = null;
        BufferedReader in = null;
        String str = "";
        String inputFileTemplate = this.mProperties.getProperty(key + ".inputTemplate");
        String outputFileTemplate = this.mProperties.getProperty(key + ".outputTemplate");
        try {
            fileReader = new FileReader(this.mProperties.getProperty("absoluteinputdir") + File.separator + inputFileTemplate);
            in = new BufferedReader(fileReader);
            while ((str = in.readLine()) != null) {
                inputFileTemplateString = inputFileTemplateString + str;
            }
            in.close();
            fileReader.close();
            str = "";
            fileReader = new FileReader(this.mProperties.getProperty("absoluteinputdir") + File.separator + outputFileTemplate);
            in = new BufferedReader(fileReader);
            while ((str = in.readLine()) != null) {
                outputFileTemplateString = outputFileTemplateString + str;
            }
            in.close();
            fileReader.close();
        }
        catch (IOException e) {
            try {
                if (in != null) {
                    in.close();
                }
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw e;
        }
        ArrayList allInputValuesList = new ArrayList();
        String inputValues = this.mProperties.getProperty(key + ".inputValues");
        StringTokenizer st = new StringTokenizer(inputValues, ",");
        int sizeInner = 0;
        boolean sizeDefined = false;
        ArrayList<String> inputValueID = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            inputValueID.add(token);
            String inputValuesContent = this.mProperties.getProperty(key + ".inputValues." + token);
            StringTokenizer stInner = new StringTokenizer(inputValuesContent, "|");
            ArrayList<String> inputValuesList = new ArrayList<String>();
            while (stInner.hasMoreTokens()) {
                inputValuesList.add(stInner.nextToken().trim());
            }
            if (!sizeDefined) {
                sizeInner = inputValuesList.size();
                sizeDefined = true;
            } else if (sizeInner != inputValuesList.size()) {
                throw new Exception("inputValues for " + key + " should have a count :" + sizeInner);
            }
            allInputValuesList.add(inputValuesList);
        }
        for (int i = 0; i < sizeInner; ++i) {
            String s = inputFileTemplateString;
            for (int j = 0; j < allInputValuesList.size(); ++j) {
                s = this.replaceValue(s, (String)inputValueID.get(j), (String)((List)allInputValuesList.get(j)).get(i));
            }
            File outFile = new File(this.mProperties.getProperty("absoluteinputdir") + File.separator + "input." + key + "." + i + ".xml");
            if (outFile.exists()) {
                outFile.delete();
            }
            outFile.createNewFile();
            FileWriter outputFw = new FileWriter(outFile);
            outputFw.write(s, 0, s.length());
            outputFw.flush();
            outputFw.close();
            HashMap<String, String> singleInvokeMap = new HashMap<String, String>();
            singleInvokeMap.put("inputfile", "input." + key + "." + i + ".xml");
            singleInvokeMap.put("soapaction", soapAction);
            singleInvokeMap.put("destination", destination);
            invokePropertiesMap.put(key + "." + i, singleInvokeMap);
        }
        ArrayList allOutputValuesList = new ArrayList();
        String outputValues = this.mProperties.getProperty(key + ".outputValues");
        sizeInner = 0;
        sizeDefined = false;
        st = new StringTokenizer(outputValues, ",");
        ArrayList<String> outputValueID = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            outputValueID.add(token);
            String outputValuesContent = this.mProperties.getProperty(key + ".outputValues." + token);
            StringTokenizer stInner = new StringTokenizer(outputValuesContent, "|");
            ArrayList<String> outputValuesList = new ArrayList<String>();
            while (stInner.hasMoreTokens()) {
                outputValuesList.add(stInner.nextToken().trim());
            }
            if (!sizeDefined) {
                sizeInner = outputValuesList.size();
                sizeDefined = true;
            } else if (sizeInner != outputValuesList.size()) {
                throw new Exception("outputValues for " + key + " should have a count :" + sizeInner);
            }
            allOutputValuesList.add(outputValuesList);
        }
        for (int i = 0; i < sizeInner; ++i) {
            String s = outputFileTemplateString;
            for (int j = 0; j < allOutputValuesList.size(); ++j) {
                s = this.replaceValue(s, (String)outputValueID.get(j), (String)((List)allOutputValuesList.get(j)).get(i));
            }
            File outFile = new File(this.mProperties.getProperty("absoluteinputdir") + File.separator + "output." + key + "." + i + ".xml");
            if (outFile.exists()) {
                outFile.delete();
            }
            outFile.createNewFile();
            FileWriter outputFw = new FileWriter(outFile);
            outputFw.write(s, 0, s.length());
            outputFw.flush();
            outputFw.close();
            Map singleInvokeMap = (Map)invokePropertiesMap.get(key + "." + i);
            singleInvokeMap.put("outputfile", "output." + key + "." + i + ".xml");
        }
    }

    String replaceValue(String string, String id, String value) {
        return string.replaceFirst("#" + id + "#", value);
    }

    private void filterAttributeOrderChange(List diffs) {
        ArrayList<Difference> removeDiffs = new ArrayList<Difference>();
        for (Difference dif : diffs) {
            Change c;
            if (!(dif instanceof Change) || !(c = (Change)dif).isAttributeChanged() || c.isPositionChanged() || c.isTokenChanged()) continue;
            List attrdiffs = c.getAttrChanges();
            int size = attrdiffs.size();
            ArrayList<Change.AttributeDiff> removeAttrs = new ArrayList<Change.AttributeDiff>();
            for (Change.AttributeDiff attrdif : attrdiffs) {
                Change.AttributeChange attrChange;
                if (!(attrdif instanceof Change.AttributeChange) || !(attrChange = (Change.AttributeChange)attrdif).isPositionChanged() || attrChange.isTokenChanged()) continue;
                removeAttrs.add(attrdif);
            }
            Iterator removeAttrItr = removeAttrs.iterator();
            while (removeAttrItr.hasNext()) {
                c.removeAttrChanges((Change.AttributeDiff)removeAttrItr.next());
            }
            if (size <= 0 || c.getAttrChanges().size() != 0) continue;
            removeDiffs.add(dif);
        }
        Iterator removeItr = removeDiffs.iterator();
        while (removeItr.hasNext()) {
            diffs.remove((Difference)removeItr.next());
        }
    }

    private void filterEnvelopeNSDiffs(List<Difference> diffs) {
        ArrayList<Difference> removeList = new ArrayList<Difference>();
        for (Difference diff : diffs) {
            boolean remove = false;
            NodeInfo oldNodeInfo = diff.getOldNodeInfo();
            NodeInfo newNodeInfo = diff.getNewNodeInfo();
            Node oldNode = oldNodeInfo.getNode();
            Node newNode = newNodeInfo.getNode();
            if (diff instanceof Change && oldNode.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") && oldNode.getLocalName().equals("Envelope") && newNode.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") && newNode.getLocalName().equals("Envelope")) {
                for (Change.AttributeDiff attrDiff : ((Change)diff).getAttrChanges()) {
                    Attribute nonNullAttr;
                    Attribute oldAttr = attrDiff.getOldAttribute();
                    Attribute newAttr = attrDiff.getNewAttribute();
                    if ((oldAttr == null || newAttr != null) && (oldAttr != null || newAttr == null)) continue;
                    Attribute attribute = nonNullAttr = newAttr == null ? oldAttr : newAttr;
                    if (nonNullAttr.getName().startsWith("xmlns:")) {
                        remove = true;
                        continue;
                    }
                    remove = false;
                    break;
                }
            }
            if (!remove) continue;
            removeList.add(diff);
        }
        for (Difference removedDiff : removeList) {
            diffs.remove(removedDiff);
        }
    }

    private void filterNSPrefixDiffs(List diffs) {
        ArrayList<Difference> removeDiffs = new ArrayList<Difference>();
        for (Difference dif : diffs) {
            String oName;
            Change c;
            if (!(dif instanceof Change) || !(c = (Change)dif).isTokenChanged() || c.isPositionChanged()) continue;
            oName = oName.substring((oName = c.getOldNodeInfo().getNode().getNodeName().trim()).indexOf(58) != -1 ? oName.indexOf(58) + 1 : 0);
            String nName = c.getNewNodeInfo().getNode().getNodeName().trim();
            if (!oName.equals(nName = nName.substring(nName.indexOf(58) != -1 ? nName.indexOf(58) + 1 : 0)) || c.isAttributeChanged() && (!c.isAttributeChanged() || !this.removeNSAttrDiffs(c) && !this.removeSchemaLocationAttrDiffs(c))) continue;
            removeDiffs.add(dif);
        }
        Iterator removeItr = removeDiffs.iterator();
        while (removeItr.hasNext()) {
            diffs.remove((Difference)removeItr.next());
        }
    }

    private void filterAttrWhitespaceDiffs(List diffs) {
        ArrayList<Difference> removeDiffs = new ArrayList<Difference>();
        for (Difference dif : diffs) {
            Change c;
            if (!(dif instanceof Change) || !(c = (Change)dif).isAttributeChanged() || c.isPositionChanged() || c.isTokenChanged()) continue;
            List attrdiffs = c.getAttrChanges();
            int size = attrdiffs.size();
            ArrayList<Change.AttributeDiff> removeAttrs = new ArrayList<Change.AttributeDiff>();
            for (Change.AttributeDiff attrdif : attrdiffs) {
                Change.AttributeChange attrChange;
                if (!(attrdif instanceof Change.AttributeChange) || (attrChange = (Change.AttributeChange)attrdif).isPositionChanged()) continue;
                Attribute oldAttr = attrdif.getOldAttribute();
                Attribute newAttr = attrdif.getNewAttribute();
                if (oldAttr == null || newAttr == null || !oldAttr.getNodeValue().trim().equals(newAttr.getNodeValue().trim())) continue;
                removeAttrs.add(attrdif);
            }
            Iterator removeAttrsItr = removeAttrs.iterator();
            while (removeAttrsItr.hasNext()) {
                c.removeAttrChanges((Change.AttributeDiff)removeAttrsItr.next());
            }
            if (size <= 0 || attrdiffs.size() != 0) continue;
            removeDiffs.add(dif);
        }
        Iterator removeItr = removeDiffs.iterator();
        while (removeItr.hasNext()) {
            diffs.remove((Difference)removeItr.next());
        }
    }

    private void filterEmptySoapHeaderElements(List diffs) {
        ArrayList<Difference> removeDiffs = new ArrayList<Difference>();
        for (Difference dif : diffs) {
            Add add;
            Node node;
            if (dif instanceof Delete) {
                Delete d = (Delete)dif;
                node = d.getOldNodeInfo().getNode();
                if (!this.isEmptySoapHeaderNode((org.w3c.dom.Node)node)) continue;
                removeDiffs.add(dif);
                continue;
            }
            if (!(dif instanceof Add) || !this.isEmptySoapHeaderNode((org.w3c.dom.Node)(node = (add = (Add)dif).getNewNodeInfo().getNode()))) continue;
            removeDiffs.add(dif);
        }
        Iterator removeItr = removeDiffs.iterator();
        while (removeItr.hasNext()) {
            diffs.remove((Difference)removeItr.next());
        }
    }

    private boolean isEmptySoapHeaderNode(org.w3c.dom.Node node) {
        return node instanceof Element && "http://schemas.xmlsoap.org/soap/envelope/".equals(node.getNamespaceURI()) && "Header".equals(node.getLocalName()) && node.getChildNodes().getLength() == 0;
    }

    private boolean removeNSAttrDiffs_(Change c) {
        List attrdiffs = c.getAttrChanges();
        int size = attrdiffs.size();
        ArrayList<Change.AttributeDiff> removeAttrs = new ArrayList<Change.AttributeDiff>();
        for (Change.AttributeDiff attrdif : attrdiffs) {
            Attribute oldAttr = attrdif.getOldAttribute();
            Attribute newAttr = attrdif.getNewAttribute();
            if (oldAttr != null && oldAttr.getName().startsWith(NS_PREFIX)) {
                removeAttrs.add(attrdif);
                continue;
            }
            if (newAttr == null || !newAttr.getName().startsWith(NS_PREFIX)) continue;
            removeAttrs.add(attrdif);
        }
        Iterator removeAttrItr = removeAttrs.iterator();
        while (removeAttrItr.hasNext()) {
            c.removeAttrChanges((Change.AttributeDiff)removeAttrItr.next());
        }
        return size > 0 && attrdiffs.size() == 0;
    }

    private boolean removeNSAttrDiffs(Change c) {
        List attrdiffs = c.getAttrChanges();
        int size = attrdiffs.size();
        ArrayList<Change.AttributeDiff> removeAttrs = new ArrayList<Change.AttributeDiff>();
        for (Change.AttributeDiff attrdif : attrdiffs) {
            Attribute oldAttr = attrdif.getOldAttribute();
            Attribute newAttr = attrdif.getNewAttribute();
            if (oldAttr != null && oldAttr.getName().startsWith(NS_PREFIX)) {
                removeAttrs.add(attrdif);
                continue;
            }
            if (newAttr == null || !newAttr.getName().startsWith(NS_PREFIX)) continue;
            removeAttrs.add(attrdif);
        }
        Iterator removeAttrItr = removeAttrs.iterator();
        while (removeAttrItr.hasNext()) {
            c.removeAttrChanges((Change.AttributeDiff)removeAttrItr.next());
        }
        return size > 0 && attrdiffs.size() == 0;
    }

    private boolean removeSchemaLocationAttrDiffs(Change c) {
        List attrdiffs = c.getAttrChanges();
        int size = attrdiffs.size();
        ArrayList<Change.AttributeDiff> removeAttrs = new ArrayList<Change.AttributeDiff>();
        for (Change.AttributeDiff attrdif : attrdiffs) {
            Attribute oldAttr = attrdif.getOldAttribute();
            Attribute newAttr = attrdif.getNewAttribute();
            if (oldAttr != null && oldAttr.getName().endsWith(SCHEMA_LOCATION)) {
                removeAttrs.add(attrdif);
                continue;
            }
            if (newAttr == null || !newAttr.getName().endsWith(SCHEMA_LOCATION)) continue;
            removeAttrs.add(attrdif);
        }
        Iterator removeAttrItr = removeAttrs.iterator();
        while (removeAttrItr.hasNext()) {
            c.removeAttrChanges((Change.AttributeDiff)removeAttrItr.next());
        }
        return size > 0 && attrdiffs.size() == 0;
    }

    private String removeIndent(String inputStr, String indent) {
        int indentSize = indent.length();
        StringBuffer strBuf = new StringBuffer();
        try {
            BufferedReader inLines = new BufferedReader(new StringReader(inputStr));
            String inputLine = inLines.readLine();
            if (inputLine != null) {
                strBuf.append(inputLine + "\n");
            }
            if ((inputLine = inLines.readLine()) != null && inputLine.trim().length() > 0) {
                strBuf.append(inputLine + "\n");
            }
            if ((inputLine = inLines.readLine()) != null) {
                if (inputLine.substring(0, indentSize).equals(indent)) {
                    strBuf.append(inputLine.substring(indentSize) + "\n");
                } else {
                    strBuf.append(inputLine + "\n");
                }
            }
            int chunksize = 512;
            char[] buff = new char[chunksize];
            int len = inLines.read(buff);
            while (len > 0) {
                strBuf.append(buff, 0, len);
                len = inLines.read(buff);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return strBuf.toString();
    }

    private static String[] parseCommand(String command) {
        StringTokenizer st = new StringTokenizer(command, " ");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List loadScript(File scriptFile, Map<String, Input> inputTable) {
        ArrayList<Runnable> taskList = new ArrayList<Runnable>();
        BufferedReader fileIn = null;
        try {
            String line;
            fileIn = new BufferedReader(new InputStreamReader(new FileInputStream(scriptFile)));
            while ((line = fileIn.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] cmd = ConfiguredTest.parseCommand(line);
                if ("send".startsWith(cmd[0])) {
                    taskList.add(new Send(inputTable.get(cmd[1]), cmd[2]));
                    continue;
                }
                if (!"wait".startsWith(cmd[0])) continue;
                taskList.add(new Wait(cmd[1]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fileIn != null) {
                    fileIn.close();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return taskList;
    }

    static void println(Object mesg) {
        System.out.println(mesg);
    }

    static void print(Object mesg) {
        System.out.print(mesg);
    }

    private static ServerInstance getServerInstance(String netBeansUserDir) {
        ServerInstance instance = null;
        if (netBeansUserDir != null) {
            String settingsFileName;
            File settingsFile;
            String j2eeServerInstanceUrl = null;
            try {
                Properties privateProps = ConfiguredTest.loadProperties("nbproject/private/private.properties");
                j2eeServerInstanceUrl = (String)privateProps.get("j2ee.server.instance");
            }
            catch (IOException ex) {
                System.err.println("Error: Failed to load project properties.");
            }
            if (j2eeServerInstanceUrl != null && (settingsFile = new File(settingsFileName = netBeansUserDir + ServerInstanceReader.RELATIVE_FILE_PATH)).exists()) {
                ServerInstanceReader settings = new ServerInstanceReader(settingsFileName);
                List list = settings.getServerInstances();
                for (ServerInstance serverInstance : list) {
                    String url = serverInstance.getUrl();
                    if (!j2eeServerInstanceUrl.equals(url)) continue;
                    instance = serverInstance;
                    break;
                }
            }
        }
        return instance;
    }

    public static final void main(String[] args) {
        try {
            Test test = ConfiguredTest.suite();
            test.run(new TestResult());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void main1(String[] args) throws Exception {
        Properties props = System.getProperties();
        System.out.println(props);
        System.out.println("@@@@@@@@@@@Current path : " + System.getProperty("user.dir"));
        String path = "C:\\Documents and Settings\\jqian\\Desktop\\108234\\AssignNamespacesJBI\\";
        Properties testcasesProps = ConfiguredTest.loadProperties(path + "test/selected-tests.properties");
        String testCasesCSV = (String)testcasesProps.get("testcases");
        String[] testCaseNames = testCasesCSV.split(",");
        List<String> testCases = Arrays.asList(testCaseNames);
        File[] inputDir = new File(path + "test").listFiles();
        if (inputDir != null) {
            for (int count = 0; count < inputDir.length; ++count) {
                String testPropertiesPostfix = ".properties";
                File currentDir = inputDir[count];
                if (!currentDir.isDirectory() || !testCases.contains(currentDir.getName())) continue;
                String inputDirName = inputDir[count].getName();
                String inputDirAbsolutePath = inputDir[count].getAbsolutePath();
                FileFilter testPropertiesFilter = new FileFilter(){

                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return false;
                        }
                        return f.getName().endsWith(".properties");
                    }
                };
                File[] testPropertiesFiles = inputDir[count].listFiles(testPropertiesFilter);
                if (testPropertiesFiles == null) continue;
                for (int testCnt = 0; testCnt < testPropertiesFiles.length; ++testCnt) {
                    String testPropertiesFile = testPropertiesFiles[testCnt].getAbsolutePath();
                    String testName = inputDirName;
                    Properties testProps = ConfiguredTest.loadProperties(testPropertiesFile);
                    testProps.put("testpropertiesfilename", testPropertiesFiles[testCnt].getName());
                    testProps.put("absoluteinputdir", inputDirAbsolutePath);
                    testProps.put("inputdirname", inputDirName);
                    ConfiguredTest ct = new ConfiguredTest(testName, "testConcurrentSOAPRequest", testProps);
                    ct.setUp();
                    ct.testConcurrentCorrelationSOAPRequest();
                }
            }
        }
    }

    class RegexFileFilter
    implements FileFilter {
        private Pattern pattern;

        public RegexFileFilter(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return false;
            }
            Matcher m = this.pattern.matcher(f.getName());
            return m.matches();
        }
    }

    class Wait
    implements Runnable {
        long miliSec = 1000L;

        public Wait(String secondsStr) throws Exception {
            this.miliSec = Math.max(1L, Math.round(1000.0 * Double.parseDouble(secondsStr)));
        }

        public synchronized void run() {
            try {
                this.wait(this.miliSec);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class Send
    implements Runnable {
        String mExpectedHttpWarning;
        String mDestination;
        Input mInput;
        int mBatches;

        public Send(Input input, String batches) throws Exception {
            this.mDestination = ConfiguredTest.this.mProperties.getProperty("destination");
            this.mExpectedHttpWarning = ConfiguredTest.this.mProperties.getProperty("httpwarning");
            this.mInput = input;
            this.mBatches = Integer.parseInt(batches);
        }

        public void run() {
            String action = this.mInput.getAction();
            for (int i = 0; i < this.mBatches; ++i) {
                try {
                    String data = this.mInput.nextData();
                    SOAPMessage message = ConfiguredTest.this.mMessageFactory.createMessage();
                    message.getMimeHeaders().addHeader("soapaction", action);
                    SOAPPart soapPart = message.getSOAPPart();
                    soapPart.setContent((Source)new StreamSource(new StringReader(data)));
                    message.saveChanges();
                    ConfiguredTest.this.sendMessage(this.mInput.getName(), false, this.mDestination, message, null, this.mExpectedHttpWarning, null);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class ConcurrentTestSendOnlyRunnable
    implements Runnable {
        String mInputDirName;
        SOAPMessage mInputMessage;
        SOAPMessage[] mReplies;
        String mExpectedOutputFile;
        String mDestination;
        String mTestPropertiesFile;
        String mSoapAction;
        int mNoOfInvokes;
        Throwable mThrowableEncountered;
        long startTime;
        long endTime;
        int invokeCount;

        ConcurrentTestSendOnlyRunnable(String anInputDirName, SOAPMessage inputMessage, String anExpectedOutputFile, String aDestination, String aTestPropertiesFile, int aNoOfInvokes, String aSoapAction) {
            this.mInputDirName = anInputDirName;
            this.mInputMessage = inputMessage;
            this.mExpectedOutputFile = anExpectedOutputFile;
            this.mDestination = aDestination;
            this.mTestPropertiesFile = aTestPropertiesFile;
            this.mSoapAction = aSoapAction;
            this.mNoOfInvokes = aNoOfInvokes;
            this.mReplies = new SOAPMessage[this.mNoOfInvokes];
        }

        public void run() {
            try {
                String logPrefix = this.mInputDirName + "\\" + this.mTestPropertiesFile + " - " + Thread.currentThread().getName() + ":";
                boolean logDetails = false;
                this.startTime = System.currentTimeMillis();
                while (this.invokeCount < this.mNoOfInvokes) {
                    this.mReplies[this.invokeCount] = ConfiguredTest.this.sendMessage(logPrefix, logDetails, this.mDestination, this.mInputMessage, null, null, this.mSoapAction);
                    ++this.invokeCount;
                }
                this.endTime = System.currentTimeMillis();
            }
            catch (Throwable ex) {
                this.mThrowableEncountered = ex;
                ex.printStackTrace();
            }
        }

        public Throwable getThrowableEncountered() {
            return this.mThrowableEncountered;
        }

        public SOAPMessage[] getReplies() {
            return this.mReplies;
        }

        public String getExpectedOutputFileName() {
            return this.mExpectedOutputFile;
        }

        public long getDuration() {
            return this.endTime - this.startTime;
        }

        public long getInvocationsDone() {
            return this.invokeCount;
        }

        public long getInvocationCount() {
            return this.mNoOfInvokes;
        }
    }

    class CorrelationTestRunnable
    extends ConcurrentTestSendOnlyRunnable {
        CorrelationTestRunnable(String anInputDirName, SOAPMessage inputMessage, String anExpectedOutputFile, String aDestination, String aTestPropertiesFile, int aNoOfInvokes, String aSoapAction) {
            super(anInputDirName, inputMessage, anExpectedOutputFile, aDestination, aTestPropertiesFile, aNoOfInvokes, aSoapAction);
        }
    }
}

