/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import antlr.Token;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.netbeans.modules.cnd.apt.impl.support.APTBaseMacroMap;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroImpl;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroMapSnapshot;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTFileMacroMap
extends APTBaseMacroMap
implements APTMacroMap {
    private APTMacroMap sysMacroMap;
    private Set<String> notMacroIds = new HashSet<String>();
    private Stack<String> expandingMacros = new Stack();

    public APTFileMacroMap() {
    }

    public APTFileMacroMap(APTMacroMap aPTMacroMap, List<String> list) {
        if (aPTMacroMap == null) {
            aPTMacroMap = APTBaseMacroMap.EMPTY;
        }
        this.sysMacroMap = aPTMacroMap;
        this.fill(list);
    }

    public void setSysMacros(APTMacroMap aPTMacroMap) {
        this.sysMacroMap = aPTMacroMap;
    }

    @Override
    public APTMacro getMacro(Token token) {
        String string = token.getText();
        APTMacro aPTMacro = null;
        if (!(this.notMacroIds.contains(string) || (aPTMacro = super.getMacro(token)) != APTMacroMapSnapshot.UNDEFINED_MACRO && aPTMacro != null)) {
            this.notMacroIds.add(string);
        }
        if (aPTMacro == null && this.sysMacroMap != null) {
            aPTMacro = this.sysMacroMap.getMacro(token);
        }
        return aPTMacro != APTMacroMapSnapshot.UNDEFINED_MACRO ? aPTMacro : null;
    }

    @Override
    public void define(Token token, Collection<Token> collection, List<Token> list) {
        super.define(token, collection, list);
        this.notMacroIds.remove(token.getText());
    }

    @Override
    public void undef(Token token) {
        super.undef(token);
        this.notMacroIds.remove(token.getText());
    }

    @Override
    protected APTMacro createMacro(Token token, Collection<Token> collection, List<Token> list) {
        return new APTMacroImpl(token, collection, list, false);
    }

    @Override
    protected APTMacroMapSnapshot makeSnapshot(APTMacroMapSnapshot aPTMacroMapSnapshot) {
        return new APTMacroMapSnapshot(aPTMacroMapSnapshot);
    }

    @Override
    public APTMacroMap.State getState() {
        this.changeActiveSnapshotIfNeeded();
        return new FileStateImpl(this.active.parent, this.sysMacroMap);
    }

    @Override
    public void setState(APTMacroMap.State state) {
        this.active = this.makeSnapshot(((APTBaseMacroMap.StateImpl)state).snap);
        if (state instanceof FileStateImpl) {
            this.sysMacroMap = ((FileStateImpl)state).sysMacroMap;
        }
        this.notMacroIds.clear();
    }

    @Override
    public boolean pushExpanding(Token token) {
        assert (token != null);
        if (!this.isExpanding(token)) {
            this.expandingMacros.push(token.getText());
            return true;
        }
        return false;
    }

    @Override
    public void popExpanding() {
        block2: {
            String string = null;
            try {
                string = this.expandingMacros.pop();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"why pop from empty stack?");
            }
        }
    }

    @Override
    public boolean isExpanding(Token token) {
        try {
            return this.expandingMacros.contains(token.getText());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            assert (false) : "why ask empty stack?";
            return false;
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Own Map:\n");
        stringBuilder.append(super.toString());
        stringBuilder.append("System Map:\n");
        stringBuilder.append(this.sysMacroMap);
        return stringBuilder.toString();
    }

    public static class FileStateImpl
    extends APTBaseMacroMap.StateImpl {
        public final APTMacroMap sysMacroMap;

        public FileStateImpl(APTMacroMapSnapshot aPTMacroMapSnapshot, APTMacroMap aPTMacroMap) {
            super(aPTMacroMapSnapshot);
            this.sysMacroMap = aPTMacroMap;
        }

        private FileStateImpl(FileStateImpl fileStateImpl, boolean bl) {
            super(fileStateImpl, bl);
            this.sysMacroMap = fileStateImpl.sysMacroMap;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("FileState\n");
            stringBuilder.append("Snapshot\n");
            stringBuilder.append(super.toString());
            stringBuilder.append("\nSystem MacroMap\n");
            stringBuilder.append(this.sysMacroMap);
            return stringBuilder.toString();
        }

        public void write(DataOutput dataOutput) throws IOException {
            super.write(dataOutput);
            APTSerializeUtils.writeSystemMacroMap(this.sysMacroMap, dataOutput);
        }

        public FileStateImpl(DataInput dataInput) throws IOException {
            super(dataInput);
            APTMacroMap aPTMacroMap = APTSerializeUtils.readSystemMacroMap(dataInput);
            this.sysMacroMap = aPTMacroMap == null ? APTBaseMacroMap.EMPTY : aPTMacroMap;
        }

        public APTBaseMacroMap.StateImpl copyCleaned() {
            return new FileStateImpl(this, true);
        }
    }
}

