/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import antlr.Token;
import antlr.TokenStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.apt.utils.ListBasedTokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTMacroImpl
implements APTMacro {
    private final Token name;
    private final Token[] paramsArray;
    private final List<Token> body;
    private final boolean system;

    public APTMacroImpl(Token token, Collection<Token> collection, List<Token> list, boolean bl) {
        assert (token != null);
        this.name = token;
        this.paramsArray = collection != null ? collection.toArray(new Token[collection.size()]) : null;
        this.body = list;
        this.system = bl;
    }

    @Override
    public boolean isSystem() {
        return this.system;
    }

    @Override
    public boolean isFunctionLike() {
        return this.paramsArray != null;
    }

    @Override
    public Token getName() {
        return this.name;
    }

    @Override
    public Collection<Token> getParams() {
        if (this.paramsArray == null) {
            return null;
        }
        ArrayList<Token> arrayList = new ArrayList<Token>(this.paramsArray.length);
        for (Token token : this.paramsArray) {
            arrayList.add(token);
        }
        return arrayList;
    }

    @Override
    public TokenStream getBody() {
        return this.body != null ? new ListBasedTokenStream(this.body) : APTUtils.EMPTY_STREAM;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == null || !(object instanceof APTMacro)) {
            bl = false;
        } else {
            APTMacro aPTMacro = (APTMacro)object;
            bl = APTMacroImpl.equals(this, aPTMacro);
        }
        return bl;
    }

    private static final boolean equals(APTMacro aPTMacro, APTMacro aPTMacro2) {
        return aPTMacro.getName().getText().compareTo(aPTMacro2.getName().getText()) == 0;
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.getName().getText().hashCode();
        return n;
    }

    public String toString() {
        TokenStream tokenStream;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.isSystem() ? "<S>" : "<U>");
        stringBuilder.append("#define '");
        stringBuilder.append(this.getName());
        if (this.paramsArray != null) {
            stringBuilder.append("[");
            boolean bl = true;
            for (Token token : this.paramsArray) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                bl = false;
                stringBuilder.append(token);
            }
            stringBuilder.append("]");
        }
        if ((tokenStream = this.getBody()) != null) {
            stringBuilder.append("'='");
            stringBuilder.append(APTUtils.toString(tokenStream));
        }
        return stringBuilder.toString();
    }

    public void write(DataOutput dataOutput) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public APTMacroImpl(DataInput dataInput) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

