/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.hyperlink;

import java.util.Collection;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.services.CsmFunctionDefinitionResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmAbstractHyperlinkProvider;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsmHyperlinkProvider
extends CsmAbstractHyperlinkProvider {
    @Override
    protected void performAction(Document document, JTextComponent jTextComponent, int n) {
        this.goToDeclaration(document, jTextComponent, n);
    }

    @Override
    protected boolean isValidToken(Token<CppTokenId> token) {
        return CsmHyperlinkProvider.isSupportedToken(token);
    }

    public static boolean isSupportedToken(Token<CppTokenId> token) {
        if (token != null) {
            switch ((CppTokenId)token.id()) {
                case IDENTIFIER: 
                case PREPROCESSOR_IDENTIFIER: 
                case OPERATOR: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean goToDeclaration(Document document, JTextComponent jTextComponent, int n) {
        if (!this.preJump(document, jTextComponent, n, "opening-csm-element")) {
            return false;
        }
        Token token = this.getJumpToken();
        CsmOffsetable csmOffsetable = (CsmOffsetable)this.findTargetObject(document, token, n, true);
        return this.postJump(csmOffsetable, "goto_source_source_not_found", "cannot-open-csm-element");
    }

    CsmObject findTargetObject(Document document, Token token, int n, boolean bl) {
        CsmObject csmObject;
        CsmObject csmObject2 = null;
        assert (token != null);
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)true);
        CsmObject csmObject3 = csmObject = csmFile == null ? null : ReferencesSupport.findDeclaration(csmFile, document, token, n);
        if (csmObject != null) {
            csmObject2 = bl ? this.toJumpObject(csmObject, csmFile, n) : csmObject;
        }
        return csmObject2;
    }

    private CsmOffsetable toJumpObject(CsmObject csmObject, CsmFile csmFile, int n) {
        CsmOffsetable csmOffsetable = null;
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            CsmVariableDefinition csmVariableDefinition;
            csmOffsetable = (CsmOffsetable)csmObject;
            if (CsmKindUtilities.isFunctionDeclaration((CsmObject)csmObject)) {
                CsmFunctionDefinition csmFunctionDefinition = ((CsmFunction)csmObject).getDefinition();
                if (csmFunctionDefinition != null) {
                    if (csmFile.equals(csmFunctionDefinition.getContainingFile()) && csmFunctionDefinition.getStartOffset() <= n && n <= csmFunctionDefinition.getBody().getStartOffset()) {
                        if (csmFunctionDefinition.getDeclaration() != null) {
                            csmOffsetable = csmFunctionDefinition.getDeclaration();
                        } else if (csmObject.equals(csmFunctionDefinition)) {
                            csmOffsetable = (CsmOffsetable)csmObject;
                        }
                    } else {
                        csmOffsetable = csmFunctionDefinition;
                    }
                } else {
                    CsmReference csmReference = CsmFunctionDefinitionResolver.getDefault().getFunctionDefinition((CsmFunction)csmObject);
                    if (csmReference != null) {
                        csmOffsetable = csmReference;
                    }
                }
            } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
                CsmFunctionDefinition csmFunctionDefinition = (CsmFunctionDefinition)csmObject;
                if (csmFile.equals(csmFunctionDefinition.getContainingFile()) && csmFunctionDefinition.getStartOffset() <= n && n <= csmFunctionDefinition.getBody().getStartOffset()) {
                    if (csmFunctionDefinition.getDeclaration() != null) {
                        csmOffsetable = csmFunctionDefinition.getDeclaration();
                    } else if (csmObject.equals(csmFunctionDefinition)) {
                        csmOffsetable = (CsmOffsetable)csmObject;
                    }
                }
            } else if (CsmKindUtilities.isVariableDeclaration((CsmObject)csmObject) && (csmVariableDefinition = ((CsmVariable)csmObject).getDefinition()) != null) {
                csmOffsetable = csmVariableDefinition;
                if (csmFile.equals(csmVariableDefinition.getContainingFile()) && csmVariableDefinition.getStartOffset() <= n && n <= csmVariableDefinition.getEndOffset()) {
                    csmOffsetable = (CsmVariable)csmObject;
                }
            }
        } else if (CsmKindUtilities.isNamespace((CsmObject)csmObject)) {
            CsmNamespace csmNamespace = (CsmNamespace)csmObject;
            Collection collection = csmNamespace.getDefinitions();
            CsmNamespaceDefinition csmNamespaceDefinition = null;
            for (CsmNamespaceDefinition csmNamespaceDefinition2 : collection) {
                CsmFile csmFile2;
                if (csmNamespaceDefinition == null) {
                    csmNamespaceDefinition = csmNamespaceDefinition2;
                }
                if (!csmFile.equals(csmFile2 = csmNamespaceDefinition2.getContainingFile())) continue;
                csmNamespaceDefinition = csmNamespaceDefinition2;
                break;
            }
            csmOffsetable = csmNamespaceDefinition;
        }
        return csmOffsetable;
    }

    @Override
    protected String getTooltipText(Document document, Token token, int n) {
        CsmObject csmObject = this.findTargetObject(document, token, n, false);
        CharSequence charSequence = csmObject == null ? null : CsmDisplayUtilities.getTooltipText((CsmObject)csmObject);
        return charSequence == null ? null : ((Object)charSequence).toString();
    }
}

