/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExceptionHandler;
import org.netbeans.modules.cnd.api.model.deep.CsmForStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmSwitchStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmTryCatchStatement;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;

public class CsmStatementResolver {
    private CsmStatementResolver() {
    }

    public static boolean findInnerObject(CsmStatement csmStatement, int n, CsmContext csmContext) {
        if (csmStatement == null) {
            if (CsmUtilities.DEBUG) {
                CsmStatementResolver.print("STATEMENT is null");
            }
            return false;
        }
        if (!CsmOffsetUtilities.isInObject((CsmObject)csmStatement, n)) {
            if (CsmUtilities.DEBUG) {
                CsmStatementResolver.print("Offset " + n + " is not in statement " + csmStatement);
            }
            return false;
        }
        CsmContextUtilities.updateContext((CsmObject)csmStatement, n, csmContext);
        CsmStatement.Kind kind = csmStatement.getKind();
        boolean bl = true;
        switch (kind) {
            case COMPOUND: {
                bl = CsmStatementResolver.findInner((CsmCompoundStatement)csmStatement, n, csmContext);
                break;
            }
            case IF: {
                bl = CsmStatementResolver.findInner((CsmIfStatement)csmStatement, n, csmContext);
                break;
            }
            case TRY_CATCH: {
                bl = CsmStatementResolver.findInner((CsmTryCatchStatement)csmStatement, n, csmContext);
                break;
            }
            case CATCH: {
                bl = CsmStatementResolver.findInner((CsmExceptionHandler)csmStatement, n, csmContext);
                break;
            }
            case DECLARATION: {
                bl = CsmStatementResolver.findInner((CsmDeclarationStatement)csmStatement, n, csmContext);
                break;
            }
            case WHILE: 
            case DO_WHILE: {
                bl = CsmStatementResolver.findInner((CsmLoopStatement)csmStatement, n, csmContext);
                break;
            }
            case FOR: {
                bl = CsmStatementResolver.findInner((CsmForStatement)csmStatement, n, csmContext);
                break;
            }
            case SWITCH: {
                bl = CsmStatementResolver.findInner((CsmSwitchStatement)csmStatement, n, csmContext);
                break;
            }
            case BREAK: 
            case CASE: 
            case CONTINUE: 
            case DEFAULT: 
            case EXPRESSION: 
            case GOTO: 
            case LABEL: 
            case RETURN: {
                break;
            }
            default: {
                if (!CsmUtilities.DEBUG) break;
                CsmStatementResolver.print("unexpected statement kind");
            }
        }
        return bl;
    }

    private static boolean findInner(CsmCompoundStatement csmCompoundStatement, int n, CsmContext csmContext) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)csmCompoundStatement, n)) : "we must be in statement when called";
        if (csmCompoundStatement != null) {
            for (CsmStatement csmStatement : csmCompoundStatement.getStatements()) {
                if (!CsmStatementResolver.findInnerObject(csmStatement, n, csmContext)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean findInner(CsmTryCatchStatement csmTryCatchStatement, int n, CsmContext csmContext) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)csmTryCatchStatement, n)) : "we must be in statement when called";
        if (CsmStatementResolver.findInnerObject(csmTryCatchStatement.getTryStatement(), n, csmContext)) {
            return true;
        }
        Iterator iterator = csmTryCatchStatement.getHandlers().iterator();
        while (iterator.hasNext()) {
            if (!CsmStatementResolver.findInnerObject((CsmStatement)iterator.next(), n, csmContext)) continue;
            return true;
        }
        return false;
    }

    private static boolean findInner(CsmExceptionHandler csmExceptionHandler, int n, CsmContext csmContext) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)csmExceptionHandler, n)) : "we must be in statement when called";
        return CsmStatementResolver.findInner((CsmCompoundStatement)csmExceptionHandler, n, csmContext);
    }

    private static boolean findInner(CsmIfStatement csmIfStatement, int n, CsmContext csmContext) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)csmIfStatement, n)) : "we must be in statement when called";
        if (CsmOffsetUtilities.isInObject((CsmObject)csmIfStatement.getCondition(), n)) {
            if (CsmUtilities.DEBUG) {
                CsmStatementResolver.print("in CONDITION of if statement ");
            }
            CsmContextUtilities.updateContextObject((CsmObject)csmIfStatement.getCondition(), n, csmContext);
            return true;
        }
        if (CsmStatementResolver.findInnerObject(csmIfStatement.getThen(), n, csmContext)) {
            if (CsmUtilities.DEBUG) {
                CsmStatementResolver.print("in THEN: ");
            }
            return true;
        }
        if (CsmStatementResolver.findInnerObject(csmIfStatement.getElse(), n, csmContext)) {
            if (CsmUtilities.DEBUG) {
                CsmStatementResolver.print("in ELSE: ");
            }
            return true;
        }
        return false;
    }

    private static boolean findInner(CsmDeclarationStatement csmDeclarationStatement, int n, CsmContext csmContext) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)csmDeclarationStatement, n)) : "we must be in declaration statement when called";
        List list = csmDeclarationStatement.getDeclarators();
        CsmDeclaration csmDeclaration = (CsmDeclaration)CsmOffsetUtilities.findObject(list, csmContext, n);
        if (csmDeclaration != null) {
            CsmFunction csmFunction;
            Collection collection;
            CsmParameter csmParameter;
            if (CsmUtilities.DEBUG) {
                CsmStatementResolver.print("we have declarator " + csmDeclaration);
            }
            if (CsmKindUtilities.isClass((CsmObject)csmDeclaration)) {
                CsmStatementResolver.findInner((CsmClass)csmDeclaration, n, csmContext);
            }
            if (CsmKindUtilities.isFunction((CsmObject)csmDeclaration) && (csmParameter = (CsmParameter)CsmOffsetUtilities.findObject(collection = (csmFunction = (CsmFunction)csmDeclaration).getParameters(), csmContext, n)) != null) {
                csmContext.add((CsmScope)csmFunction);
                CsmType csmType = csmParameter.getType();
                if (CsmOffsetUtilities.isInObject((CsmObject)csmType, n)) {
                    csmContext.setLastObject((CsmObject)csmType);
                } else {
                    csmContext.setLastObject((CsmObject)csmParameter);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean findInner(CsmClass csmClass, int n, CsmContext csmContext) {
        CsmContextUtilities.updateContext((CsmObject)csmClass, n, csmContext);
        CsmMember csmMember = (CsmMember)CsmOffsetUtilities.findObject(csmClass.getMembers(), csmContext, n);
        if (CsmKindUtilities.isClass((CsmObject)csmMember)) {
            CsmStatementResolver.findInner((CsmClass)csmMember, n, csmContext);
        } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmMember)) {
            CsmContextUtilities.updateContext((CsmObject)csmMember, n, csmContext);
            CsmStatementResolver.findInnerObject((CsmStatement)((CsmFunctionDefinition)csmMember).getBody(), n, csmContext);
        }
        return true;
    }

    private static boolean findInner(CsmLoopStatement csmLoopStatement, int n, CsmContext csmContext) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)csmLoopStatement, n)) : "we must be in statement when called";
        if (CsmOffsetUtilities.isInObject((CsmObject)csmLoopStatement.getCondition(), n)) {
            if (CsmUtilities.DEBUG) {
                CsmStatementResolver.print("in condition of loop statement isPostCheck()=" + csmLoopStatement.isPostCheck());
            }
            CsmContextUtilities.updateContextObject((CsmObject)csmLoopStatement.getCondition(), n, csmContext);
            return true;
        }
        return CsmStatementResolver.findInnerObject(csmLoopStatement.getBody(), n, csmContext);
    }

    private static boolean findInner(CsmForStatement csmForStatement, int n, CsmContext csmContext) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)csmForStatement, n)) : "we must be in statement when called";
        if (CsmStatementResolver.findInnerObject(csmForStatement.getInitStatement(), n, csmContext)) {
            if (CsmUtilities.DEBUG) {
                CsmStatementResolver.print("in INIT of for statement");
            }
            return true;
        }
        if (CsmOffsetUtilities.isInObject((CsmObject)csmForStatement.getIterationExpression(), n)) {
            if (CsmUtilities.DEBUG) {
                CsmStatementResolver.print("in ITERATION  of for statement");
            }
            CsmContextUtilities.updateContextObject((CsmObject)csmForStatement.getIterationExpression(), n, csmContext);
            return true;
        }
        if (CsmOffsetUtilities.isInObject((CsmObject)csmForStatement.getCondition(), n)) {
            if (CsmUtilities.DEBUG) {
                CsmStatementResolver.print("in CONDITION of for statement ");
            }
            CsmContextUtilities.updateContextObject((CsmObject)csmForStatement.getCondition(), n, csmContext);
            return true;
        }
        return CsmStatementResolver.findInnerObject(csmForStatement.getBody(), n, csmContext);
    }

    private static boolean findInner(CsmSwitchStatement csmSwitchStatement, int n, CsmContext csmContext) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)csmSwitchStatement, n)) : "we must be in statement when called";
        if (CsmOffsetUtilities.isInObject((CsmObject)csmSwitchStatement.getCondition(), n)) {
            CsmContextUtilities.updateContextObject((CsmObject)csmSwitchStatement.getCondition(), n, csmContext);
            return true;
        }
        return CsmStatementResolver.findInnerObject(csmSwitchStatement.getBody(), n, csmContext);
    }

    private static void print(String string) {
        if (CsmUtilities.DEBUG) {
            System.out.println(string);
        }
    }
}

