/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.completion.impl.xref.DocOffsPositionImpl;

public class DocOffsetableImpl
implements CsmOffsetable {
    private final CsmUID<CsmFile> uidFile;
    private final DocOffsPositionImpl pos;

    public DocOffsetableImpl(BaseDocument baseDocument, CsmFile csmFile, int n) {
        this.pos = new DocOffsPositionImpl(baseDocument, n);
        assert (csmFile != null) : "null file for document " + baseDocument + " on offset " + n;
        this.uidFile = csmFile.getUID();
    }

    protected BaseDocument getDocument() {
        return this.pos.getDocument();
    }

    public CsmFile getContainingFile() {
        return (CsmFile)this.uidFile.getObject();
    }

    public int getStartOffset() {
        return this.pos.getOffset();
    }

    public int getEndOffset() {
        return this.getStartOffset() + this.getText().length();
    }

    public CsmOffsetable.Position getStartPosition() {
        return this.pos;
    }

    public CsmOffsetable.Position getEndPosition() {
        return new DocOffsPositionImpl(this.getDocument(), this.getEndOffset());
    }

    public CharSequence getText() {
        return "";
    }

    protected final boolean isValid() {
        CsmFile csmFile = this.getContainingFile();
        return csmFile != null && csmFile.isValid();
    }
}

