/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionPointerType;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmGotoStatement;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmLabelResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionProvider;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmHyperlinkProvider;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmIncludeHyperlinkProvider;
import org.netbeans.modules.cnd.completion.csm.CompletionUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.completion.impl.xref.DocOffsetableImpl;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.completion.impl.xref.ReferenceImpl;
import org.netbeans.modules.cnd.completion.impl.xref.ThisReferenceImpl;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Parameters;
import org.openide.util.UserQuestionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReferencesSupport {
    private static ReferencesSupport instance = new ReferencesSupport();
    private final CsmProgressListener progressListener;
    private static final int MAX_CACHE_SIZE = 10;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private Map<CsmFile, Map<Integer, CsmObject>> cache = new HashMap<CsmFile, Map<Integer, CsmObject>>();
    private static CsmObject FAKE = new CsmObject(){};

    private ReferencesSupport() {
        this.progressListener = new CsmProgressAdapter(){

            public void fileParsingStarted(CsmFile csmFile) {
                ReferencesSupport.this.clearFileReferences(csmFile);
            }
        };
        CsmListeners.getDefault().addProgressListener(this.progressListener);
    }

    public static ReferencesSupport instance() {
        return instance;
    }

    public static int getDocumentOffset(BaseDocument baseDocument, int n, int n2) {
        return Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n - 1)) + (n2 - 1);
    }

    public static BaseDocument getBaseDocument(String string) throws DataObjectNotFoundException, IOException {
        File file = new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return null;
        }
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            throw new IllegalStateException("Given file (\"" + dataObject.getName() + "\") does not have EditorCookie.");
        }
        StyledDocument styledDocument = null;
        try {
            styledDocument = editorCookie.openDocument();
        }
        catch (UserQuestionException userQuestionException) {
            userQuestionException.confirmed();
            styledDocument = editorCookie.openDocument();
        }
        return styledDocument instanceof BaseDocument ? (BaseDocument)styledDocument : null;
    }

    public CsmObject findReferencedObject(CsmFile csmFile, BaseDocument baseDocument, int n) {
        return this.findReferencedObject(csmFile, baseDocument, n, null, null);
    }

    static CsmObject findOwnerObject(CsmFile csmFile, BaseDocument baseDocument, int n, Token<CppTokenId> token) {
        CsmObject csmObject = CsmOffsetResolver.findObject(csmFile, n);
        return csmObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CsmObject findReferencedObject(CsmFile csmFile, BaseDocument baseDocument, int n, Token<CppTokenId> token, FileReferencesContext fileReferencesContext) {
        CsmFile csmFile2 = null;
        CsmInclude csmInclude = null;
        if (token == null) {
            baseDocument.readLock();
            try {
                token = CndTokenUtilities.getOffsetTokenCheckPrev((Document)baseDocument, (int)n);
            }
            finally {
                baseDocument.readUnlock();
            }
        }
        if (token != null) {
            switch ((CppTokenId)token.id()) {
                case PREPROCESSOR_SYS_INCLUDE: 
                case PREPROCESSOR_USER_INCLUDE: {
                    csmInclude = ReferencesSupport.findInclude(csmFile, n);
                }
            }
        }
        CsmFile csmFile3 = csmFile2 = csmInclude == null ? null : csmInclude.getIncludeFile();
        if (csmFile2 == null) {
            int n2 = token.offset(null);
            if (n2 < 0) {
                n2 = n;
            }
            if ((csmFile2 = this.getReferencedObject(csmFile, n2)) == null) {
                csmFile2 = ReferencesSupport.findDeclaration(csmFile, (Document)baseDocument, token, n2, fileReferencesContext);
                if (csmFile2 == null) {
                    this.putReferencedObject(csmFile, n2, FAKE);
                } else {
                    this.putReferencedObject(csmFile, n2, (CsmObject)csmFile2);
                }
            } else if (csmFile2 == FAKE) {
                csmFile2 = null;
            }
        }
        return csmFile2;
    }

    public static CsmInclude findInclude(CsmFile csmFile, int n) {
        assert (csmFile != null);
        return (CsmInclude)CsmOffsetUtilities.findObject(csmFile.getIncludes(), null, n);
    }

    public static CsmObject findDeclaration(CsmFile csmFile, Document document, Token token, int n) {
        return ReferencesSupport.findDeclaration(csmFile, document, token, n, null);
    }

    private static CsmObject findDeclaration(CsmFile csmFile, Document document, Token token, int n, FileReferencesContext fileReferencesContext) {
        Collection collection;
        Object object;
        Object object2;
        int[] nArray = null;
        Object object3 = null;
        CsmObject csmObject = CsmOffsetResolver.findObject(csmFile, n, fileReferencesContext);
        if (CsmKindUtilities.isEnumerator((CsmObject)csmObject)) {
            object2 = (CsmEnumerator)csmObject;
            if (object2.getExplicitValue() == null) {
                object3 = object2;
            }
        } else if (CsmKindUtilities.isLabel((CsmObject)csmObject)) {
            object3 = csmObject;
        } else if (CsmKindUtilities.isGotoStatement((CsmObject)csmObject)) {
            object2 = (CsmGotoStatement)csmObject;
            object = object2.getScope();
            while (object != null && CsmKindUtilities.isScopeElement((CsmObject)object) && !CsmKindUtilities.isFunctionDefinition((CsmObject)object)) {
                object = ((CsmScopeElement)object).getScope();
            }
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)object) && !(collection = CsmLabelResolver.getDefault().getLabels((CsmFunctionDefinition)object, object2.getLabel(), CsmLabelResolver.LabelKind.Definiton)).isEmpty()) {
                object3 = ((CsmReference)collection.iterator().next()).getReferencedObject();
            }
            if (object3 == null) {
                return null;
            }
        } else if (CsmKindUtilities.isVariable((CsmObject)csmObject) || CsmKindUtilities.isTypedef((CsmObject)csmObject)) {
            boolean bl;
            object2 = CsmKindUtilities.isVariable((CsmObject)csmObject) ? ((CsmVariable)csmObject).getType() : ((CsmTypedef)csmObject).getType();
            object = null;
            do {
                CsmParameter csmParameter;
                bl = false;
                if (CsmOffsetUtilities.isInObject((CsmObject)object2, n)) {
                    object = null;
                    continue;
                }
                if (!CsmKindUtilities.isFunctionPointerType((CsmObject)object2) || (csmParameter = (CsmParameter)CsmOffsetUtilities.findObject(((CsmFunctionPointerType)object2).getParameters(), null, n)) == null) continue;
                object = csmParameter;
                object2 = csmParameter.getType();
                bl = true;
            } while (bl);
            object3 = object;
        }
        if (object3 == null) {
            try {
                if (document instanceof BaseDocument) {
                    nArray = NbEditorUtilities.getIdentifierAndMethodBlock((BaseDocument)((BaseDocument)document), (int)n);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (nArray != null && nArray.length != 3) {
                object3 = ReferencesSupport.findDeclaration(csmFile, document, (Token<CppTokenId>)token, n, CsmCompletionQuery.QueryScope.SMART_QUERY, fileReferencesContext);
            }
        }
        Object object4 = object3 = object3 != null ? object3 : ReferencesSupport.findDeclaration(csmFile, document, (Token<CppTokenId>)token, n, CsmCompletionQuery.QueryScope.GLOBAL_QUERY, fileReferencesContext);
        if (object3 == null) {
            object2 = CsmFileInfoQuery.getDefault().getMacroUsages(csmFile);
            object = object2.iterator();
            while (object.hasNext()) {
                collection = (CsmReference)object.next();
                if (collection.getStartOffset() > n || n > collection.getEndOffset()) continue;
                object3 = collection.getReferencedObject();
                assert (object3 != null) : "must be referenced macro" + collection;
            }
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CsmObject findDeclaration(CsmFile csmFile, Document document, Token<CppTokenId> token, int n, CsmCompletionQuery.QueryScope queryScope, FileReferencesContext fileReferencesContext) {
        assert (csmFile != null);
        if (token == null && document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
            try {
                token = CndTokenUtilities.getOffsetTokenCheckPrev((Document)document, (int)n);
            }
            finally {
                ((AbstractDocument)document).readUnlock();
            }
        }
        if (token == null) {
            return null;
        }
        CsmObject csmObject = null;
        if (token.id() == CppTokenId.OPERATOR) {
            CsmObject csmObject2 = CsmOffsetResolver.findObject(csmFile, n, fileReferencesContext);
            csmObject = csmObject2;
            if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
                CsmFunction csmFunction = null;
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
                    csmFunction = ((CsmFunctionDefinition)csmObject).getDeclaration();
                } else if (CsmKindUtilities.isFriendMethod((CsmObject)csmObject)) {
                    csmFunction = ((CsmFriendFunction)csmObject).getReferencedFunction();
                }
                if (csmFunction != null) {
                    csmObject = csmFunction;
                }
            } else {
                csmObject = null;
            }
        }
        if (csmObject == null) {
            csmObject = CompletionUtilities.findItemAtCaretPos(null, document, CsmCompletionProvider.getCompletionQuery(csmFile, queryScope, fileReferencesContext), n);
        }
        return csmObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ReferenceImpl createReferenceImpl(CsmFile csmFile, BaseDocument baseDocument, int n) {
        ReferenceImpl referenceImpl = null;
        baseDocument.readLock();
        try {
            Token token = CndTokenUtilities.getOffsetTokenCheckPrev((Document)baseDocument, (int)n);
            if (ReferencesSupport.isSupportedToken((Token<CppTokenId>)token)) {
                referenceImpl = ReferencesSupport.createReferenceImpl(csmFile, baseDocument, n, token, null);
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        return referenceImpl;
    }

    public static ReferenceImpl createReferenceImpl(CsmFile csmFile, BaseDocument baseDocument, int n, Token token, CsmReferenceKind csmReferenceKind) {
        assert (token != null);
        assert (csmFile != null) : "null file for document " + baseDocument + " on offset " + n + " " + token;
        if (token.id() == CppTokenId.THIS) {
            return new ThisReferenceImpl(csmFile, baseDocument, n, token, csmReferenceKind);
        }
        return new ReferenceImpl(csmFile, baseDocument, n, token, csmReferenceKind);
    }

    private static boolean isSupportedToken(Token<CppTokenId> token) {
        return token != null && (CsmIncludeHyperlinkProvider.isSupportedToken(token) || CsmHyperlinkProvider.isSupportedToken(token));
    }

    public static CsmReferenceResolver.Scope fastCheckScope(CsmReference csmReference) {
        Parameters.notNull((CharSequence)"ref", (Object)csmReference);
        CsmObject csmObject = ReferencesSupport.getTargetIfPossible(csmReference);
        if (csmObject == null) {
            int n = ReferencesSupport.getRefOffset(csmReference);
            BaseDocument baseDocument = ReferencesSupport.getRefDocument(csmReference);
            if (baseDocument != null) {
                Token token = ReferencesSupport.getRefTokenIfPossible(csmReference);
                csmObject = ReferencesSupport.findDeclaration(csmReference.getContainingFile(), (Document)baseDocument, (Token<CppTokenId>)token, n, CsmCompletionQuery.QueryScope.LOCAL_QUERY, null);
                ReferencesSupport.setResolvedInfo(csmReference, csmObject);
            }
        }
        return ReferencesSupport.getTargetScope(csmObject);
    }

    private static CsmReferenceResolver.Scope getTargetScope(CsmObject csmObject) {
        if (csmObject == null) {
            return CsmReferenceResolver.Scope.UNKNOWN;
        }
        if (ReferencesSupport.isLocalElement(csmObject)) {
            return CsmReferenceResolver.Scope.LOCAL;
        }
        if (ReferencesSupport.isFileLocalElement(csmObject)) {
            return CsmReferenceResolver.Scope.FILE_LOCAL;
        }
        return CsmReferenceResolver.Scope.GLOBAL;
    }

    private static CsmObject getTargetIfPossible(CsmReference csmReference) {
        if (csmReference instanceof ReferenceImpl) {
            return ((ReferenceImpl)csmReference).getTarget();
        }
        return null;
    }

    static Token getRefTokenIfPossible(CsmReference csmReference) {
        if (csmReference instanceof ReferenceImpl) {
            return ((ReferenceImpl)csmReference).getToken();
        }
        return null;
    }

    private static CsmReferenceKind getRefKindIfPossible(CsmReference csmReference) {
        if (csmReference instanceof ReferenceImpl) {
            return ((ReferenceImpl)csmReference).getKindImpl();
        }
        return null;
    }

    private static BaseDocument getRefDocument(CsmReference csmReference) {
        if (csmReference instanceof DocOffsetableImpl) {
            return ((DocOffsetableImpl)csmReference).getDocument();
        }
        CsmFile csmFile = csmReference.getContainingFile();
        CloneableEditorSupport cloneableEditorSupport = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
        StyledDocument styledDocument = null;
        if (cloneableEditorSupport != null) {
            styledDocument = cloneableEditorSupport.getDocument();
        }
        return styledDocument instanceof BaseDocument ? (BaseDocument)styledDocument : null;
    }

    private static int getRefOffset(CsmReference csmReference) {
        if (csmReference instanceof ReferenceImpl) {
            return ((ReferenceImpl)csmReference).getOffset();
        }
        return (csmReference.getStartOffset() + csmReference.getEndOffset() + 1) / 2;
    }

    private static void setResolvedInfo(CsmReference csmReference, CsmObject csmObject) {
        if (csmObject != null && csmReference instanceof ReferenceImpl) {
            ((ReferenceImpl)csmReference).setTarget(csmObject);
        }
    }

    private static boolean isLocalElement(CsmObject csmObject) {
        assert (csmObject != null);
        CsmObject csmObject2 = csmObject;
        while (CsmKindUtilities.isScopeElement((CsmObject)csmObject2)) {
            CsmScope csmScope = ((CsmScopeElement)csmObject2).getScope();
            if (CsmKindUtilities.isFunction((CsmObject)csmScope)) {
                return true;
            }
            if (!CsmKindUtilities.isScopeElement((CsmObject)csmScope)) break;
            csmObject2 = (CsmScopeElement)csmScope;
        }
        return false;
    }

    private static boolean isFileLocalElement(CsmObject csmObject) {
        assert (csmObject != null);
        if (CsmBaseUtilities.isDeclarationFromUnnamedNamespace((CsmObject)csmObject)) {
            return true;
        }
        if (CsmKindUtilities.isFileLocalVariable((CsmObject)csmObject)) {
            return true;
        }
        if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
            return CsmBaseUtilities.isFileLocalFunction((CsmFunction)((CsmFunction)csmObject));
        }
        return false;
    }

    static BaseDocument getDocument(CsmFile csmFile) {
        BaseDocument baseDocument = null;
        try {
            baseDocument = ReferencesSupport.getBaseDocument(((Object)csmFile.getAbsolutePath()).toString());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        return baseDocument;
    }

    static CsmReferenceKind getReferenceKind(CsmReference csmReference) {
        CsmReferenceKind csmReferenceKind = CsmReferenceKind.UNKNOWN;
        CsmObject csmObject = csmReference.getOwner();
        if (CsmKindUtilities.isType((CsmObject)csmObject) || CsmKindUtilities.isInheritance((CsmObject)csmObject)) {
            csmReferenceKind = ReferencesSupport.getReferenceUsageKind(csmReference);
        } else if (CsmKindUtilities.isInclude((CsmObject)csmObject)) {
            csmReferenceKind = CsmReferenceKind.DIRECT_USAGE;
        } else {
            CsmObject csmObject2 = csmReference.getReferencedObject();
            if (csmObject2 == null) {
                csmReferenceKind = ReferencesSupport.getReferenceUsageKind(csmReference);
            } else {
                CsmObject[] csmObjectArray = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)csmObject2, (boolean)true);
                CsmObject csmObject3 = csmObjectArray[0];
                CsmObject csmObject4 = csmObjectArray[1];
                assert (csmObject3 != null);
                csmReferenceKind = CsmReferenceKind.DIRECT_USAGE;
                if (csmObject != null) {
                    csmReferenceKind = csmObject.equals(csmObject3) ? CsmReferenceKind.DECLARATION : (csmObject.equals(csmObject4) ? CsmReferenceKind.DEFINITION : ReferencesSupport.getReferenceUsageKind(csmReference));
                }
            }
        }
        return csmReferenceKind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static CsmReferenceKind getReferenceUsageKind(CsmReference csmReference) {
        CsmReferenceKind csmReferenceKind = CsmReferenceKind.DIRECT_USAGE;
        if (!(csmReference instanceof ReferenceImpl)) return csmReferenceKind;
        CsmReferenceKind csmReferenceKind2 = ReferencesSupport.getRefKindIfPossible(csmReference);
        if (csmReferenceKind2 != null) {
            return csmReferenceKind2;
        }
        BaseDocument baseDocument = ReferencesSupport.getRefDocument(csmReference);
        baseDocument.readLock();
        try {
            int n = csmReference.getStartOffset();
            Token token = CndTokenUtilities.shiftToNonWhiteBwd((Document)baseDocument, (int)n);
            if (token == null) return csmReferenceKind;
            switch ((CppTokenId)token.id()) {
                case DOT: 
                case DOTMBR: 
                case ARROW: 
                case ARROWMBR: 
                case SCOPE: {
                    csmReferenceKind = CsmReferenceKind.AFTER_DEREFERENCE_USAGE;
                    return csmReferenceKind;
                }
            }
            return csmReferenceKind;
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmObject getReferencedObject(CsmFile csmFile, int n) {
        try {
            this.cacheLock.readLock().lock();
            Map<Integer, CsmObject> map = this.cache.get(csmFile);
            if (map != null) {
                CsmObject csmObject = map.get(n);
                return csmObject;
            }
            CsmObject csmObject = null;
            return csmObject;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putReferencedObject(CsmFile csmFile, int n, CsmObject csmObject) {
        try {
            this.cacheLock.writeLock().lock();
            Map<Integer, CsmObject> map = this.cache.get(csmFile);
            if (map == null) {
                if (this.cache.size() > 10) {
                    this.cache.clear();
                }
                map = new HashMap<Integer, CsmObject>();
                this.cache.put(csmFile, map);
            }
            map.put(n, csmObject);
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFileReferences(CsmFile csmFile) {
        try {
            this.cacheLock.writeLock().lock();
            this.cache.remove(csmFile);
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }
}

