/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.hints.infrastructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintFix;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.PreviewableFix;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.gsfret.hints.infrastructure.DisableHintFix;
import org.netbeans.modules.gsfret.hints.infrastructure.FixWrapper;
import org.netbeans.modules.gsfret.hints.infrastructure.HintsOptionsPanelController;
import org.netbeans.modules.gsfret.hints.infrastructure.HintsSettings;
import org.netbeans.modules.gsfret.hints.infrastructure.HintsTask;
import org.netbeans.modules.gsfret.hints.infrastructure.Pair;
import org.netbeans.modules.gsfret.hints.infrastructure.PreviewHintFix;
import org.netbeans.modules.gsfret.hints.infrastructure.SuggestionsTask;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GsfHintsManager
extends HintsProvider.HintsManager {
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.gsfret.hints.infrastructure");
    private static final String INSTANCE_EXT = ".instance";
    private static final String NON_GUI = "nonGUI";
    private static final String RULES_FOLDER = "gsf-hints/";
    private static final String ERRORS = "/errors";
    private static final String HINTS = "/hints";
    private static final String SUGGESTIONS = "/suggestions";
    private static final String SELECTION = "/selection";
    private Map<?, List<? extends Rule.ErrorRule>> errors = new HashMap();
    private Map<?, List<? extends Rule.AstRule>> hints = new HashMap();
    private Map<?, List<? extends Rule.AstRule>> suggestions = new HashMap();
    private List<Rule.SelectionRule> selectionHints = new ArrayList<Rule.SelectionRule>();
    private TreeModel errorsTreeModel;
    private TreeModel hintsTreeModel;
    private TreeModel suggestionsTreeModel;
    private String mimeType;
    private HintsProvider provider;
    private String id;
    boolean isTest = false;
    private OptionsPanelController panelController;

    public GsfHintsManager(String string, HintsProvider hintsProvider, Language language) {
        this.mimeType = string;
        this.provider = hintsProvider;
        this.id = language.getMimeType().replace('/', '_') + '_';
        this.initErrors();
        this.initHints();
        this.initSuggestions();
        this.initSelectionHints();
        this.initBuiltins();
    }

    public boolean isEnabled(Rule.UserConfigurableRule userConfigurableRule) {
        return HintsSettings.isEnabled(this, userConfigurableRule);
    }

    public Map<?, List<? extends Rule.ErrorRule>> getErrors() {
        return this.errors;
    }

    public Map<?, List<? extends Rule.AstRule>> getHints() {
        return this.hints;
    }

    public List<? extends Rule.SelectionRule> getSelectionHints() {
        return this.selectionHints;
    }

    public Map<?, List<? extends Rule.AstRule>> getHints(boolean bl, RuleContext ruleContext) {
        HashMap hashMap = new HashMap();
        for (Map.Entry<?, List<Rule.AstRule>> entry : this.getHints().entrySet()) {
            LinkedList<Rule.AstRule> linkedList = new LinkedList<Rule.AstRule>();
            for (Rule.AstRule astRule : entry.getValue()) {
                Preferences preferences = HintsSettings.getPreferences(this, (Rule.UserConfigurableRule)astRule, null);
                if (preferences == null) {
                    if (bl || !astRule.appliesTo(ruleContext)) continue;
                    linkedList.add(astRule);
                    continue;
                }
                if (HintsSettings.getSeverity(this, (Rule.UserConfigurableRule)astRule) == HintSeverity.CURRENT_LINE_WARNING) {
                    if (!bl || !astRule.appliesTo(ruleContext)) continue;
                    linkedList.add(astRule);
                    continue;
                }
                if (bl || !astRule.appliesTo(ruleContext)) continue;
                linkedList.add(astRule);
            }
            if (linkedList.isEmpty()) continue;
            hashMap.put(entry.getKey(), linkedList);
        }
        return hashMap;
    }

    public Map<?, List<? extends Rule.AstRule>> getSuggestions() {
        return this.suggestions;
    }

    TreeModel getErrorsTreeModel() {
        return this.errorsTreeModel;
    }

    public TreeModel getHintsTreeModel() {
        return this.hintsTreeModel;
    }

    public String getId() {
        return this.id;
    }

    TreeModel getSuggestionsTreeModel() {
        return this.suggestionsTreeModel;
    }

    private void initErrors() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.errorsTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.getRoot().getFileObject(RULES_FOLDER + this.mimeType + ERRORS);
        List<Pair<Rule, FileObject>> list = GsfHintsManager.readRules(fileObject);
        GsfHintsManager.categorizeErrorRules(list, this.errors, fileObject, defaultMutableTreeNode);
    }

    private void initHints() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.hintsTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.getRoot().getFileObject(RULES_FOLDER + this.mimeType + HINTS);
        List<Pair<Rule, FileObject>> list = GsfHintsManager.readRules(fileObject);
        GsfHintsManager.categorizeAstRules(list, this.hints, fileObject, defaultMutableTreeNode);
    }

    private void initSuggestions() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.suggestionsTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.getRoot().getFileObject(RULES_FOLDER + this.mimeType + SUGGESTIONS);
        List<Pair<Rule, FileObject>> list = GsfHintsManager.readRules(fileObject);
        GsfHintsManager.categorizeAstRules(list, this.suggestions, fileObject, defaultMutableTreeNode);
    }

    private void initSelectionHints() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.suggestionsTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.getRoot().getFileObject(RULES_FOLDER + this.mimeType + SELECTION);
        List<Pair<Rule, FileObject>> list = GsfHintsManager.readRules(fileObject);
        GsfHintsManager.categorizeSelectionRules(list, this.selectionHints, fileObject, defaultMutableTreeNode);
    }

    private void initBuiltins() {
        List list = this.provider.getBuiltinRules();
        if (list != null) {
            Map<?, List<Rule.ErrorRule>> map = this.errors;
            List<Rule.SelectionRule> list2 = this.selectionHints;
            Map<?, List<Rule.AstRule>> map2 = this.hints;
            for (Rule rule : list) {
                List<? extends Rule.ErrorRule> list3;
                Rule.ErrorRule errorRule;
                if (rule instanceof Rule.ErrorRule) {
                    errorRule = (Rule.ErrorRule)rule;
                    for (Object e : errorRule.getCodes()) {
                        list3 = this.errors.get(e);
                        if (list3 == null) {
                            list3 = new ArrayList<Rule.ErrorRule>(2);
                            map.put(e, list3);
                        }
                        list3.add((Rule.ErrorRule)rule);
                    }
                    continue;
                }
                if (rule instanceof Rule.SelectionRule) {
                    list2.add((Rule.SelectionRule)rule);
                    continue;
                }
                if (rule instanceof Rule.AstRule) {
                    errorRule = (Rule.AstRule)rule;
                    for (Object e : errorRule.getKinds()) {
                        list3 = this.hints.get(e);
                        if (list3 == null) {
                            list3 = new ArrayList<Rule.ErrorRule>(2);
                            map2.put(e, list3);
                        }
                        list3.add((Rule.ErrorRule)rule);
                    }
                    continue;
                }
                assert (false) : "Unexpected rule type " + rule;
            }
        }
    }

    private static List<Pair<Rule, FileObject>> readRules(FileObject fileObject) {
        LinkedList<Pair<Rule, FileObject>> linkedList = new LinkedList<Pair<Rule, FileObject>>();
        if (fileObject == null) {
            return linkedList;
        }
        Enumeration enumeration = fileObject.getData(true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            String string = fileObject2.getNameExt().toLowerCase();
            if (!fileObject2.canRead()) continue;
            Rule rule = null;
            if (string.endsWith(INSTANCE_EXT)) {
                rule = GsfHintsManager.instantiateRule(fileObject2);
            }
            if (rule == null) continue;
            linkedList.add(new Pair<Rule, FileObject>(rule, fileObject2));
        }
        return linkedList;
    }

    private static void categorizeErrorRules(List<Pair<Rule, FileObject>> list, Map<?, List<? extends Rule.ErrorRule>> map, FileObject fileObject, DefaultMutableTreeNode defaultMutableTreeNode) {
        HashMap<FileObject, DefaultMutableTreeNode> hashMap = new HashMap<FileObject, DefaultMutableTreeNode>();
        hashMap.put(fileObject, defaultMutableTreeNode);
        for (Pair<Rule, FileObject> pair : list) {
            Rule rule = pair.getA();
            FileObject fileObject2 = pair.getB();
            if (rule instanceof Rule.ErrorRule) {
                GsfHintsManager.addRule((Rule.ErrorRule)rule, map);
                FileObject fileObject3 = fileObject2.getParent();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)hashMap.get(fileObject3);
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(fileObject3);
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    hashMap.put(fileObject3, defaultMutableTreeNode2);
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(rule, false));
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fileObject2.getPath() + "is not instance of ErrorRule");
        }
    }

    private static void categorizeAstRules(List<Pair<Rule, FileObject>> list, Map<?, List<? extends Rule.AstRule>> map, FileObject fileObject, DefaultMutableTreeNode defaultMutableTreeNode) {
        HashMap<FileObject, DefaultMutableTreeNode> hashMap = new HashMap<FileObject, DefaultMutableTreeNode>();
        hashMap.put(fileObject, defaultMutableTreeNode);
        for (Pair<Rule, FileObject> pair : list) {
            Rule rule = pair.getA();
            FileObject fileObject2 = pair.getB();
            if (rule instanceof Rule.AstRule) {
                Object object = fileObject2.getAttribute(NON_GUI);
                boolean bl = true;
                if (object != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
                    bl = false;
                }
                GsfHintsManager.addRule((Rule.AstRule)rule, map);
                FileObject fileObject3 = fileObject2.getParent();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)hashMap.get(fileObject3);
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(fileObject3);
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    hashMap.put(fileObject3, defaultMutableTreeNode2);
                }
                if (!bl) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(rule, false));
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fileObject2.getPath() + "is not instance of AstRule");
        }
    }

    private static void categorizeSelectionRules(List<Pair<Rule, FileObject>> list, List<? extends Rule.SelectionRule> list2, FileObject fileObject, DefaultMutableTreeNode defaultMutableTreeNode) {
        HashMap<FileObject, DefaultMutableTreeNode> hashMap = new HashMap<FileObject, DefaultMutableTreeNode>();
        hashMap.put(fileObject, defaultMutableTreeNode);
        for (Pair<Rule, FileObject> pair : list) {
            Rule rule = pair.getA();
            FileObject fileObject2 = pair.getB();
            if (rule instanceof Rule.SelectionRule) {
                GsfHintsManager.addRule((Rule.SelectionRule)rule, list2);
                FileObject fileObject3 = fileObject2.getParent();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)hashMap.get(fileObject3);
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(fileObject3);
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    hashMap.put(fileObject3, defaultMutableTreeNode2);
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(rule, false));
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fileObject2.getPath() + "is not instance of SelectionRule");
        }
    }

    private static void addRule(Rule.AstRule astRule, Map<? super Object, List<Rule.AstRule>> map) {
        for (Object e : astRule.getKinds()) {
            List<Rule.AstRule> list = map.get(e);
            if (list == null) {
                list = new LinkedList<Rule.AstRule>();
                map.put(e, list);
            }
            list.add(astRule);
        }
    }

    private static void addRule(Rule.ErrorRule errorRule, Map<? super Object, List<Rule.ErrorRule>> map) {
        for (Object e : errorRule.getCodes()) {
            List<Rule.ErrorRule> list = map.get(e);
            if (list == null) {
                list = new LinkedList<Rule.ErrorRule>();
                map.put(e, list);
            }
            list.add(errorRule);
        }
    }

    private static void addRule(Rule.SelectionRule selectionRule, List<? super Rule.SelectionRule> list) {
        list.add((Rule.SelectionRule)selectionRule);
    }

    private static Rule instantiateRule(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            Object object = instanceCookie.instanceCreate();
            if (object instanceof Rule) {
                return (Rule)object;
            }
            return null;
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, null, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.log(Level.INFO, null, classNotFoundException);
        }
        return null;
    }

    public final ErrorDescription createDescription(Hint hint, RuleContext ruleContext, boolean bl) {
        List<Object> list;
        Rule rule = hint.getRule();
        HintSeverity hintSeverity = rule instanceof Rule.UserConfigurableRule ? HintsSettings.getSeverity(this, (Rule.UserConfigurableRule)rule) : rule.getDefaultSeverity();
        OffsetRange offsetRange = hint.getRange();
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        if (hint.getFixes() != null && hint.getFixes().size() > 0) {
            list = new ArrayList(hint.getFixes().size());
            String string = Integer.toString(10000 + hint.getPriority());
            for (HintFix hintFix : hint.getFixes()) {
                PreviewableFix previewableFix;
                list.add(new FixWrapper(hintFix, string));
                if (!(hintFix instanceof PreviewableFix) || !(previewableFix = (PreviewableFix)hintFix).canPreview() || this.isTest) continue;
                list.add(new PreviewHintFix(compilationInfo, previewableFix, string));
            }
            if (rule instanceof Rule.UserConfigurableRule && !this.isTest) {
                list.add(new DisableHintFix(this, ruleContext, (Rule.UserConfigurableRule)rule, string));
            }
        } else if (bl && rule instanceof Rule.UserConfigurableRule && !this.isTest) {
            String string = Integer.toString(10000 + hint.getPriority());
            list = Collections.singletonList(new DisableHintFix(this, ruleContext, (Rule.UserConfigurableRule)rule, string));
        } else {
            list = Collections.emptyList();
        }
        return ErrorDescriptionFactory.createErrorDescription((Severity)hintSeverity.toEditorSeverity(), (String)hint.getDescription(), list, (FileObject)hint.getFile(), (int)offsetRange.getStart(), (int)offsetRange.getEnd());
    }

    public final void refreshHints(RuleContext ruleContext) {
        List<ErrorDescription> list = GsfHintsManager.getHints(this, ruleContext);
        HintsController.setErrors((FileObject)ruleContext.compilationInfo.getFileObject(), (String)(ruleContext.caretOffset == -1 ? HintsTask.class.getName() : SuggestionsTask.class.getName()), list);
    }

    private static final List<ErrorDescription> getHints(GsfHintsManager gsfHintsManager, RuleContext ruleContext) {
        int n = ruleContext.caretOffset;
        HintsProvider hintsProvider = gsfHintsManager.provider;
        ArrayList arrayList = new ArrayList();
        if (n == -1) {
            hintsProvider.computeHints((HintsProvider.HintsManager)gsfHintsManager, ruleContext, arrayList);
            ArrayList<ErrorDescription> arrayList2 = new ArrayList<ErrorDescription>(arrayList.size());
            for (Hint hint : arrayList) {
                boolean bl = true;
                ErrorDescription errorDescription = gsfHintsManager.createDescription(hint, ruleContext, bl);
                arrayList2.add(errorDescription);
            }
            return arrayList2;
        }
        hintsProvider.computeSuggestions((HintsProvider.HintsManager)gsfHintsManager, ruleContext, arrayList, n);
        ArrayList<ErrorDescription> arrayList3 = new ArrayList<ErrorDescription>(arrayList.size());
        for (Hint hint : arrayList) {
            boolean bl = true;
            ErrorDescription errorDescription = gsfHintsManager.createDescription(hint, ruleContext, bl);
            arrayList3.add(errorDescription);
        }
        return arrayList3;
    }

    static final void refreshHints(CompilationController compilationController) {
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        Set<String> set = compilationController.getEmbeddedMimeTypes();
        for (String string : set) {
            HintsProvider hintsProvider;
            Language language = LanguageRegistry.getInstance().getLanguageByMimeType(string);
            if (language == null || (hintsProvider = language.getHintsProvider()) == null) continue;
            GsfHintsManager gsfHintsManager = language.getHintsManager();
            RuleContext ruleContext = gsfHintsManager.createRuleContext(compilationController, language, -1, -1, -1);
            List<ErrorDescription> list = GsfHintsManager.getHints(gsfHintsManager, ruleContext);
            arrayList.addAll(list);
        }
        HintsController.setErrors((FileObject)compilationController.getFileObject(), (String)HintsTask.class.getName(), arrayList);
    }

    public RuleContext createRuleContext(CompilationInfo compilationInfo, Language language, int n, int n2, int n3) {
        RuleContext ruleContext = this.provider.createRuleContext();
        ruleContext.manager = this;
        ruleContext.compilationInfo = compilationInfo;
        ruleContext.caretOffset = n;
        ruleContext.selectionStart = n2;
        ruleContext.selectionEnd = n3;
        ruleContext.doc = (BaseDocument)compilationInfo.getDocument();
        if (ruleContext.doc == null) {
            return null;
        }
        Collection collection = compilationInfo.getEmbeddedResults(language.getMimeType());
        Collection collection2 = ruleContext.parserResults = collection != null ? collection : Collections.EMPTY_LIST;
        if (ruleContext.parserResults.size() > 0) {
            ruleContext.parserResult = (ParserResult)collection.iterator().next();
        }
        return ruleContext;
    }

    public synchronized OptionsPanelController getOptionsController() {
        if (this.panelController == null) {
            this.panelController = new HintsOptionsPanelController(this);
        }
        return this.panelController;
    }

    public void setTestingRules(Map<?, List<? extends Rule.ErrorRule>> map, Map<?, List<? extends Rule.AstRule>> map2, Map<?, List<? extends Rule.AstRule>> map3, List<Rule.SelectionRule> list) {
        this.errors = map;
        this.hints = map2;
        this.suggestions = map3;
        this.selectionHints = list;
        this.isTest = true;
    }

    public Preferences getPreferences(Rule.UserConfigurableRule userConfigurableRule) {
        return HintsSettings.getPreferences(this, userConfigurableRule, null);
    }

    public static class HintsManagerFactory
    extends HintsProvider.Factory {
        public HintsProvider.HintsManager getManagerForMimeType(String string) {
            Language language = LanguageRegistry.getInstance().getLanguageByMimeType(string);
            if (language != null && language.getHintsProvider() != null) {
                return language.getHintsManager();
            }
            return null;
        }
    }
}

