/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.EmbeddingModel;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.ParseEvent;
import org.netbeans.modules.gsf.api.ParseListener;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.SourceFileReader;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.gsfret.source.parsing.SourceFileObject;
import org.netbeans.napi.gsfret.source.StringSourceFileReader;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserTaskImpl {
    private ParseListener listener;
    private Language language;

    public ParserTaskImpl(Language language) {
        this.language = language;
    }

    public void setParseListener(ParseListener parseListener) {
        this.listener = parseListener;
    }

    public Iterable<ParserResult> parse(ParserFile ... parserFileArray) throws IOException {
        ArrayList<ParserResult> arrayList = new ArrayList<ParserResult>(parserFileArray.length);
        for (ParserFile parserFile : parserFileArray) {
            Collection collection;
            BaseDocument baseDocument;
            Object object;
            if (parserFile == null) continue;
            ArrayList<ParserFile> arrayList2 = new ArrayList<ParserFile>(1);
            arrayList2.add(parserFile);
            FileObject fileObject = parserFile.getFileObject();
            if (fileObject == null) {
                Logger.getLogger(ParserTaskImpl.class.getName()).log(Level.WARNING, "No fileobject for " + parserFile);
                continue;
            }
            assert (this.language != null);
            Parser parser = this.language.getParser();
            if (parser == null) continue;
            final ParserResult[] parserResultArray = new ParserResult[1];
            ParseListener parseListener = new ParseListener(){

                public void started(ParseEvent parseEvent) {
                    ParserTaskImpl.this.listener.started(parseEvent);
                }

                public void error(Error error) {
                    ParserTaskImpl.this.listener.error(error);
                }

                public void exception(Exception exception) {
                    ParserTaskImpl.this.listener.exception(exception);
                }

                public void finished(ParseEvent parseEvent) {
                    if (parseEvent.getKind() == ParseEvent.Kind.PARSE) {
                        parserResultArray[0] = parseEvent.getResult();
                    }
                    ParserTaskImpl.this.listener.finished(parseEvent);
                }
            };
            String string = parserFile.getFileObject().getMIMEType();
            LanguageRegistry languageRegistry = LanguageRegistry.getInstance();
            EmbeddingModel embeddingModel = languageRegistry.getEmbedding(this.language.getMimeType(), string);
            if (embeddingModel != null) {
                object = parserFile.getFileObject();
                baseDocument = GsfUtilities.getDocument((FileObject)object, (boolean)true, (boolean)true);
                if (baseDocument == null) continue;
                collection = embeddingModel.translate((Document)baseDocument);
                for (TranslatedSource translatedSource : collection) {
                    String string2 = translatedSource.getSource();
                    StringSourceFileReader stringSourceFileReader = new StringSourceFileReader(string2, (FileObject)object);
                    Parser.Job job = new Parser.Job(arrayList2, parseListener, (SourceFileReader)stringSourceFileReader, translatedSource);
                    parser.parseFiles(job);
                    ParserResult parserResult = parserResultArray[0];
                    parserResult.setTranslatedSource(translatedSource);
                    assert (parserResult != null);
                    arrayList.add(parserResult);
                }
                continue;
            }
            object = new SourceFileReader(){

                public CharSequence read(ParserFile parserFile) throws IOException {
                    if (parserFile.getFileObject() == null) {
                        ErrorManager.getDefault().log("Null fileobject for " + parserFile.getNameExt());
                        return "";
                    }
                    return SourceFileObject.create(parserFile.getFileObject()).getCharContent(false).toString();
                }

                public int getCaretOffset(ParserFile parserFile) {
                    return -1;
                }
            };
            baseDocument = new Parser.Job(arrayList2, parseListener, (SourceFileReader)object, null);
            parser.parseFiles((Parser.Job)baseDocument);
            collection = parserResultArray[0];
            assert (collection != null) : "Parser " + parser.getClass().getName() + " returned null instead of an invalid parser result!";
            arrayList.add((ParserResult)collection);
        }
        return arrayList;
    }
}

