/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.common.dbgp;

import java.io.IOException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import org.netbeans.modules.web.client.tools.common.dbgp.DebuggerProxy;
import org.netbeans.modules.web.client.tools.common.dbgp.Log;

public class DebuggerServer {
    private String sessionID;
    private ServerSocket serverSocket;

    public DebuggerServer(String string) {
        this.sessionID = string;
    }

    public int createSocket() throws IOException {
        return this.createSocket(0);
    }

    public int createSocket(int n) throws IOException {
        this.serverSocket = new ServerSocket(n);
        return this.serverSocket.getLocalPort();
    }

    public void cancelGetDebuggerProxy() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                Log.getLogger().log(Level.INFO, "Unexpected exception while closing socket", iOException);
            }
        }
    }

    public DebuggerProxy getDebuggerProxy() throws IOException {
        Socket socket = this.serverSocket.accept();
        this.serverSocket.close();
        return new DebuggerProxy(socket, this.sessionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findFreePort(int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            Socket socket = null;
            try {
                socket = new Socket("127.0.0.1", i);
                continue;
            }
            catch (ConnectException connectException) {
                int n3 = i;
                return n3;
            }
            catch (IOException iOException) {
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (IOException iOException2) {}
                continue;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return -1;
    }
}

