/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.common.dbgp;

import org.netbeans.modules.web.client.tools.common.dbgp.Command;
import org.netbeans.modules.web.client.tools.common.dbgp.CommandMap;
import org.netbeans.modules.web.client.tools.common.dbgp.ResponseMessage;
import org.w3c.dom.Node;

public class Feature {

    public static class FeatureSetResponse
    extends ResponseMessage {
        private static final String FEATURE = "feature";

        FeatureSetResponse(Node node) {
            super(node);
        }

        public String getFeature() {
            return FeatureSetResponse.getAttribute(this.getNode(), FEATURE);
        }

        public boolean isSuccess() {
            return FeatureSetResponse.getBoolean(this.getNode(), "success");
        }
    }

    public static class FeatureSetCommand
    extends FeatureGetCommand {
        private static final String VALUE_ARG = "-v ";
        private String value;

        public FeatureSetCommand(int n, Name name, String string) {
            super(CommandMap.FEATURE_SET.getCommand(), n, name);
            this.value = string;
        }

        public void setValue(String string) {
            this.value = string;
        }

        protected String getArguments() {
            StringBuilder stringBuilder = new StringBuilder(super.getArguments());
            stringBuilder.append(" ");
            stringBuilder.append(VALUE_ARG);
            stringBuilder.append(this.value);
            return stringBuilder.toString();
        }
    }

    public static class FeatureGetResponse
    extends FeatureSetResponse {
        private static final String SUPPORTED = "supported";

        FeatureGetResponse(Node node) {
            super(node);
        }

        public boolean isSupportedFeatureName() {
            String string = FeatureGetResponse.getAttribute(this.getNode(), SUPPORTED);
            try {
                return Integer.parseInt(string) > 0;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        public String getDetails() {
            return FeatureGetResponse.getNodeValue(this.getNode());
        }
    }

    public static class FeatureGetCommand
    extends Command {
        private static final String NAME_ARG = "-n ";
        private String name;

        public FeatureGetCommand(int n, Name name) {
            this(CommandMap.FEATURE_GET.getCommand(), n, name);
        }

        protected FeatureGetCommand(String string, int n, Name name) {
            super(string, n);
            this.name = name.toDBGPFeatureName();
        }

        public void setFeature(Name name) {
            this.name = name.toDBGPFeatureName();
        }

        public void setFeature(String string) {
            this.name = string;
        }

        protected String getArguments() {
            return NAME_ARG + this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Name {
        LANGUAGE_SUPPORTS_THREADS(false),
        LANGUAGE_NAME(false),
        LANGUAGE_VERSION(false),
        ENCODING(false),
        PROTOCOL_VERSION(false),
        SUPPORTS_ASYNC(false),
        DATA_ENCODING(false),
        BREAKPOINT_LANGUAGES(false),
        MULTIPLE_SESSIONS(true),
        MAX_CHILDREN(true),
        MAX_DATA(true),
        MAX_DEPTH(true),
        SUPPORTS_POSTMORTEM(false),
        SHOW_HIDDEN(true),
        NOTIFY_OK(true),
        HTTP_MONITOR(false){

            public String toDBGPFeatureName() {
                return "http_monitor";
            }
        }
        ,
        SUSPEND_ON_FIRST_LINE(true){

            public String toDBGPFeatureName() {
                return "suspendOnFirstLine";
            }
        }
        ,
        SUSPEND_ON_EXCEPTIONS(true){

            public String toDBGPFeatureName() {
                return "suspendOnExceptions";
            }
        }
        ,
        SUSPEND_ON_ERRORS(true){

            public String toDBGPFeatureName() {
                return "suspendOnErrors";
            }
        }
        ,
        SUSPEND_ON_DEBUGGERKEYWORD(true){

            public String toDBGPFeatureName() {
                return "suspendOnDebuggerKeyword";
            }
        }
        ,
        SHOW_FUNCTIONS(true){

            public String toDBGPFeatureName() {
                return "showFunctions";
            }
        }
        ,
        SHOW_CONSTANTS(true){

            public String toDBGPFeatureName() {
                return "showConstants";
            }
        }
        ,
        IGNORE_QUERY_STRINGS(true){

            public String toDBGPFeatureName() {
                return "ignoreQueryStrings";
            }
        }
        ,
        ENABLE(true){

            public String toDBGPFeatureName() {
                return "enable";
            }
        };

        boolean isSettable;

        private Name(boolean bl) {
            this.isSettable = bl;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public String toDBGPFeatureName() {
            return this.toString();
        }
    }
}

