/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.javascript.debugger.api;

import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSBreakpoint;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSErrorInfo;

public final class JSDebuggerState {
    private State state;
    private Reason reason;
    private JSBreakpoint breakpoint;
    public static final JSDebuggerState NOT_CONNECTED = new JSDebuggerState(State.NOT_CONNECTED);
    public static final JSDebuggerState STARTING_INIT = new JSDebuggerState(State.STARTING, Reason.INIT);
    public static final JSDebuggerState STARTING_READY = new JSDebuggerState(State.STARTING, Reason.READY);
    public static final JSDebuggerState RUNNING = new JSDebuggerState(State.RUNNING);
    public static final JSDebuggerState SUSPENDED_FIRST_LINE = new JSDebuggerState(State.SUSPENDED, Reason.FIRST_LINE);
    public static final JSDebuggerState SUSPENDED_STEP = new JSDebuggerState(State.SUSPENDED, Reason.STEP);
    public static final JSDebuggerState SUSPENDED_DEBUGGER = new JSDebuggerState(State.SUSPENDED, Reason.DEBUGGER);
    public static final JSDebuggerState DISCONNECTED_USER = new JSDebuggerState(State.DISCONNECTED, Reason.USER);
    public static final JSDebuggerState DISCONNECTED = new JSDebuggerState(State.DISCONNECTED);

    public static JSDebuggerState getDebuggerState(JSBreakpoint jSBreakpoint) {
        JSDebuggerState jSDebuggerState = new JSDebuggerState(State.SUSPENDED, Reason.BREAKPOINT);
        jSDebuggerState.setBreakpoint(jSBreakpoint);
        return jSDebuggerState;
    }

    public static JSDebuggerState getDebuggerState(JSBreakpoint jSBreakpoint, Reason reason) {
        JSDebuggerState jSDebuggerState = new JSDebuggerState(State.SUSPENDED, reason);
        jSDebuggerState.setBreakpoint(jSBreakpoint);
        return jSDebuggerState;
    }

    public static JSDebuggerState getDebuggerState(JSErrorInfo jSErrorInfo) {
        JSDebuggerState jSDebuggerState = new JSDebuggerState(State.SUSPENDED, Reason.EXCEPTION);
        return jSDebuggerState;
    }

    private JSDebuggerState(State state) {
        this(state, Reason.NONE);
    }

    private JSDebuggerState(State state, Reason reason) {
        this.state = state;
        this.reason = reason;
    }

    public State getState() {
        return this.state;
    }

    public Reason getReason() {
        return this.reason;
    }

    public JSBreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    private void setBreakpoint(JSBreakpoint jSBreakpoint) {
        assert (this.state == State.SUSPENDED && this.reason == Reason.BREAKPOINT);
        this.breakpoint = jSBreakpoint;
    }

    public String toString() {
        return "State: " + (Object)((Object)this.getState()) + " Reason: " + (Object)((Object)this.getReason());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reason {
        NONE,
        INIT,
        READY,
        FIRST_LINE,
        BREAKPOINT,
        STEP,
        DEBUGGER,
        ERROR,
        EXCEPTION,
        USER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NOT_CONNECTED,
        STARTING,
        RUNNING,
        SUSPENDED,
        DISCONNECTED;

    }
}

