/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.javascript.debugger.impl;

import java.util.Collections;
import java.util.Map;
import org.netbeans.modules.web.client.tools.common.dbgp.HttpMessage;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSHttpMessage;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSHttpRequest
implements JSHttpMessage {
    private final String id;
    private final JSHttpMessage.MethodType method;
    private final String timeStamp;
    private final String urlParams;
    private final Map<String, String> headerData;
    private final String postText;
    private final String url;
    private final boolean loadTriggeredByUser;

    public JSHttpRequest(HttpMessage httpMessage) {
        this.id = httpMessage.getId();
        assert (this.id != null);
        this.method = JSFactory.getHttpMessageMethodType(httpMessage.getMethodType());
        this.timeStamp = httpMessage.getTimeStamp();
        this.headerData = Collections.unmodifiableMap(httpMessage.getHeader());
        this.urlParams = httpMessage.getUrlParams();
        this.postText = httpMessage.getChildValue("postText");
        this.url = httpMessage.getUrl();
        this.loadTriggeredByUser = httpMessage.isLoadTriggerByUser();
    }

    public boolean isLoadTriggeredByUser() {
        return this.loadTriggeredByUser;
    }

    public String getPostText() {
        return this.postText;
    }

    public String getUrlParams() {
        return this.urlParams.toString();
    }

    public JSHttpMessage.MethodType getMethod() {
        return this.method;
    }

    public static final JSHttpMessage.Type getType() {
        return JSHttpMessage.Type.REQUEST;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Map<String, String> getHeader() {
        return Collections.unmodifiableMap(this.headerData);
    }

    @Override
    public String getTimeStamp() {
        return this.timeStamp;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return this.url;
    }
}

