/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.javascript.debugger.impl;

import java.util.Collections;
import java.util.Map;
import org.netbeans.modules.web.client.tools.common.dbgp.HttpMessage;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSHttpMessage;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSHttpResponse
implements JSHttpMessage {
    private final String id;
    private final String timeStamp;
    private final Map<String, String> headerData;
    private final String status;
    private final String url;
    private final String mimeType;
    private final String responseText;
    private final String category;

    public JSHttpResponse(HttpMessage httpMessage) {
        assert (httpMessage != null);
        this.id = httpMessage.getId();
        this.timeStamp = httpMessage.getTimeStamp();
        this.headerData = Collections.unmodifiableMap(httpMessage.getHeader());
        this.status = httpMessage.getChildValue("status");
        String string = httpMessage.getChildValue("mimeType");
        this.url = httpMessage.getUrl();
        this.responseText = httpMessage.getResponseText();
        this.category = httpMessage.getChildValue("category");
        assert (this.id != null);
        assert (this.timeStamp != null);
        if (string == null || string.equals("null")) {
            Log.getLogger().warning("JSHttpResponse - MIME type is null for url:" + this.url);
            string = "text/html";
        }
        this.mimeType = string;
    }

    public String getCategory() {
        return this.category;
    }

    public String getResponseText() {
        return this.responseText;
    }

    public String getUrl() {
        return this.url;
    }

    public static final JSHttpMessage.Type getType() {
        return JSHttpMessage.Type.RESPONSE;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Map<String, String> getHeader() {
        return Collections.unmodifiableMap(this.headerData);
    }

    @Override
    public String getTimeStamp() {
        return this.timeStamp;
    }

    public String getStatus() {
        return this.status;
    }
}

