/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.java.navigation.ClassMemberFilters;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.actions.OpenAction;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementNode
extends AbstractNode {
    private static Node WAIT_NODE;
    private OpenAction openAction;
    private Description description;

    public ElementNode(Description description) {
        super((Children)(description.subs == null ? Children.LEAF : new ElementChilren(description.subs, description.ui.getFilters())), description.treePathHandle == null ? null : Lookups.singleton((Object)description.treePathHandle));
        this.description = description;
        this.setDisplayName(description.name);
    }

    public Image getIcon(int n) {
        return this.description.kind == null ? super.getIcon(n) : ImageUtilities.icon2Image((Icon)ElementIcons.getElementIcon((ElementKind)this.description.kind, this.description.modifiers));
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public String getDisplayName() {
        if (this.description.name != null) {
            return this.description.name;
        }
        if (this.description.fileObject != null) {
            return this.description.fileObject.getNameExt();
        }
        return null;
    }

    public String getHtmlDisplayName() {
        return this.description.htmlHeader;
    }

    public Action[] getActions(boolean bl) {
        if (bl || this.description.name == null) {
            return this.description.ui.getActions();
        }
        Action[] actionArray = this.description.ui.getActions();
        Action[] actionArray2 = new Action[4 + actionArray.length];
        actionArray2[0] = this.getOpenAction();
        actionArray2[1] = RefactoringActionsFactory.whereUsedAction();
        actionArray2[2] = RefactoringActionsFactory.popupSubmenuAction();
        actionArray2[3] = null;
        for (int i = 0; i < actionArray.length; ++i) {
            actionArray2[4 + i] = actionArray[i];
        }
        return actionArray2;
    }

    public Action getPreferredAction() {
        return this.getOpenAction();
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public PasteType getDropType(Transferable transferable, int n, int n2) {
        return null;
    }

    public Transferable drag() throws IOException {
        return null;
    }

    protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
    }

    private synchronized Action getOpenAction() {
        if (this.openAction == null) {
            FileObject fileObject = this.description.getFileObject();
            this.openAction = new OpenAction(this.description.elementHandle, fileObject, this.description.name);
        }
        return this.openAction;
    }

    static synchronized Node getWaitNode() {
        if (WAIT_NODE == null) {
            WAIT_NODE = new WaitNode();
        }
        return WAIT_NODE;
    }

    public void refreshRecursively() {
        Children children = this.getChildren();
        if (children instanceof ElementChilren) {
            boolean bl = this.description.ui.getScrollOnExpand();
            this.description.ui.setScrollOnExpand(false);
            ((ElementChilren)children).resetKeys(this.description.subs, this.description.ui.getFilters());
            for (Node node : children.getNodes()) {
                this.description.ui.expandNode(node);
                ((ElementNode)node).refreshRecursively();
            }
            this.description.ui.setScrollOnExpand(bl);
        }
    }

    public ElementNode getNodeForElement(ElementHandle<Element> elementHandle) {
        if (this.getDescritption().elementHandle != null && elementHandle.signatureEquals(this.getDescritption().elementHandle)) {
            return this;
        }
        Children children = this.getChildren();
        if (children instanceof ElementChilren) {
            for (Node node : children.getNodes()) {
                ElementNode elementNode = ((ElementNode)node).getNodeForElement(elementHandle);
                if (elementNode == null) continue;
                return elementNode;
            }
        }
        return null;
    }

    public void updateRecursively(Description description) {
        Object object;
        Children children = this.getChildren();
        if (children instanceof ElementChilren) {
            object = new HashSet<Description>(this.description.subs);
            Node[] nodeArray = children.getNodes(true);
            HashMap<Description, ElementNode> hashMap = new HashMap<Description, ElementNode>();
            for (Node node : nodeArray) {
                hashMap.put(((ElementNode)node).description, (ElementNode)node);
            }
            ((ElementChilren)children).resetKeys(description.subs, description.ui.getFilters());
            nodeArray = children.getNodes(true);
            for (Description description2 : description.subs) {
                ElementNode elementNode = (ElementNode)((Object)hashMap.get(description2));
                if (elementNode == null) continue;
                if (!((HashSet)object).contains(description2) && elementNode.getChildren() != Children.LEAF) {
                    this.description.ui.expandNode((Node)elementNode);
                }
                elementNode.updateRecursively(description2);
            }
        }
        object = this.description;
        this.description = description;
        if (((Description)object).htmlHeader != null && !((Description)object).htmlHeader.equals(this.description.htmlHeader)) {
            this.fireDisplayNameChange(((Description)object).htmlHeader, this.description.htmlHeader);
        }
        if (((Description)object).modifiers != null && !((Object)((Description)object).modifiers).equals(description.modifiers)) {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }
    }

    public Description getDescritption() {
        return this.description;
    }

    private static class WaitNode
    extends AbstractNode {
        private Image waitIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/wait.gif");

        WaitNode() {
            super(Children.LEAF);
        }

        public Image getIcon(int n) {
            return this.waitIcon;
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(ElementNode.class, (String)"LBL_WaitNode");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Description {
        public static final Comparator<Description> ALPHA_COMPARATOR = new DescriptionComparator(true);
        public static final Comparator<Description> POSITION_COMPARATOR = new DescriptionComparator(false);
        ClassMemberPanelUI ui;
        FileObject fileObject;
        final String name;
        final ElementHandle<? extends Element> elementHandle;
        final TreePathHandle treePathHandle;
        final ElementKind kind;
        Set<Modifier> modifiers;
        List<Description> subs;
        String htmlHeader;
        long pos;
        boolean isInherited;
        ClasspathInfo cpInfo;

        Description(ClassMemberPanelUI classMemberPanelUI) {
            this.ui = classMemberPanelUI;
            this.name = null;
            this.elementHandle = null;
            this.treePathHandle = null;
            this.kind = null;
            this.isInherited = false;
        }

        Description(ClassMemberPanelUI classMemberPanelUI, String string, ElementHandle<? extends Element> elementHandle, ElementKind elementKind, TreePathHandle treePathHandle, boolean bl) {
            this.ui = classMemberPanelUI;
            this.name = string;
            this.elementHandle = elementHandle;
            this.kind = elementKind;
            this.isInherited = bl;
            this.treePathHandle = treePathHandle;
        }

        public FileObject getFileObject() {
            if (!this.isInherited) {
                return this.ui.getFileObject();
            }
            return SourceUtils.getFile(this.elementHandle, (ClasspathInfo)this.cpInfo);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Description)) {
                return false;
            }
            Description description = (Description)object;
            if (this.kind != description.kind) {
                return false;
            }
            if (!this.name.equals(description.name)) {
                return false;
            }
            return this.elementHandle.signatureEquals(description.elementHandle);
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.name != null ? this.name.hashCode() : 0);
            n = 29 * n + (this.kind != null ? this.kind.hashCode() : 0);
            return n;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class DescriptionComparator
        implements Comparator<Description> {
            boolean alpha;

            DescriptionComparator(boolean bl) {
                this.alpha = bl;
            }

            @Override
            public int compare(Description description, Description description2) {
                if (this.alpha) {
                    return this.alphaCompare(description, description2);
                }
                if (description.isInherited && !description2.isInherited) {
                    return 1;
                }
                if (!description.isInherited && description2.isInherited) {
                    return -1;
                }
                if (description.isInherited && description2.isInherited) {
                    return this.alphaCompare(description, description2);
                }
                return description.pos == description2.pos ? 0 : (description.pos < description2.pos ? -1 : 1);
            }

            int alphaCompare(Description description, Description description2) {
                if (this.k2i(description.kind) != this.k2i(description2.kind)) {
                    return this.k2i(description.kind) - this.k2i(description2.kind);
                }
                return description.name.compareTo(description2.name);
            }

            int k2i(ElementKind elementKind) {
                switch (elementKind) {
                    case CONSTRUCTOR: {
                        return 1;
                    }
                    case METHOD: {
                        return 2;
                    }
                    case FIELD: {
                        return 3;
                    }
                    case CLASS: 
                    case INTERFACE: 
                    case ENUM: 
                    case ANNOTATION_TYPE: {
                        return 4;
                    }
                }
                return 100;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ElementChilren
    extends Children.Keys<Description> {
        public ElementChilren(List<Description> list, ClassMemberFilters classMemberFilters) {
            this.resetKeys(list, classMemberFilters);
        }

        protected Node[] createNodes(Description description) {
            return new Node[]{new ElementNode(description)};
        }

        void resetKeys(List<Description> list, ClassMemberFilters classMemberFilters) {
            this.setKeys(classMemberFilters.filter(list));
        }
    }
}

