/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.ide;

import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.ide.Hk2DeploymentStatus;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;

public class MonitorProgressObject
implements ProgressObject,
OperationStateListener {
    private final Hk2DeploymentManager dm;
    private final TargetModuleID moduleId;
    private final CommandType commandType;
    private volatile DeploymentStatus operationStatus;
    private CopyOnWriteArrayList<ProgressListener> listeners = new CopyOnWriteArrayList();

    public MonitorProgressObject(Hk2DeploymentManager hk2DeploymentManager, TargetModuleID targetModuleID) {
        this(hk2DeploymentManager, targetModuleID, CommandType.DISTRIBUTE);
    }

    public MonitorProgressObject(Hk2DeploymentManager hk2DeploymentManager, TargetModuleID targetModuleID, CommandType commandType) {
        this.dm = hk2DeploymentManager;
        this.moduleId = targetModuleID;
        this.commandType = commandType;
        this.operationStatus = new Hk2DeploymentStatus(commandType, StateType.RUNNING, ActionType.EXECUTE, "Initializing...");
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.operationStatus;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[]{this.moduleId};
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("GFV3: Cancel not supported yet.");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("GFV3: Stop not supported yet.");
    }

    public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
        this.fireHandleProgressEvent(new Hk2DeploymentStatus(this.commandType, this.translateState(operationState), ActionType.EXECUTE, string));
    }

    private StateType translateState(GlassfishModule.OperationState operationState) {
        if (operationState == GlassfishModule.OperationState.RUNNING) {
            return StateType.RUNNING;
        }
        if (operationState == GlassfishModule.OperationState.COMPLETED) {
            return StateType.COMPLETED;
        }
        return StateType.FAILED;
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.listeners.add(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.listeners.remove(progressListener);
    }

    public void fireHandleProgressEvent(DeploymentStatus deploymentStatus) {
        this.operationStatus = deploymentStatus;
        ProgressEvent progressEvent = new ProgressEvent((Object)this.dm, this.moduleId, deploymentStatus);
        for (ProgressListener progressListener : this.listeners) {
            progressListener.handleProgressEvent(progressEvent);
        }
    }
}

