/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.mozilla.nb.javascript.Node;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.EditList;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.PreviewableFix;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.BrowserVersion;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.SupportedBrowsers;
import org.netbeans.modules.javascript.editing.embedding.JsModel;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.javascript.hints.MoreInfoFix;
import org.netbeans.modules.javascript.hints.infrastructure.JsErrorRule;
import org.netbeans.modules.javascript.hints.infrastructure.JsRuleContext;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrictWarning
extends JsErrorRule {
    public static final String ANON_NO_RETURN_VALUE = "msg.anon.no.return.value";
    public static final String BAD_OCTAL_LITERAL = "msg.bad.octal.literal";
    public static final String DUP_PARAMS = "msg.dup.parms";
    public static final String NO_RETURN_VALUE = "msg.no.return.value";
    public static final String NO_SIDE_EFFECTS = "msg.no.side.effects";
    public static final String RESERVED_KEYWORD = "msg.reserved.keyword";
    public static final String RETURN_INCONSISTENT = "msg.return.inconsistent";
    public static final String TRAILING_COMMA = "msg.trailing.comma";
    public static final String VAR_HIDES_ARG = "msg.var.hides.arg";
    public static final String VAR_REDECL = "msg.var.redecl";
    public static final String[] KNOWN_STRICT_ERROR_KEYS = new String[]{"msg.trailing.comma", "msg.bad.octal.literal", "msg.reserved.keyword", "msg.dup.parms", "msg.return.inconsistent", "msg.no.return.value", "msg.anon.no.return.value", "msg.var.hides.arg", "msg.var.redecl", "msg.no.side.effects"};
    private String key;
    private HintSeverity defaultSeverity = HintSeverity.WARNING;

    public StrictWarning(String string) {
        this.key = string;
    }

    @Override
    public Set<String> getCodes() {
        return Collections.singleton(this.key);
    }

    @Override
    public void run(JsRuleContext jsRuleContext, Error error, List<Hint> list) {
        Node node;
        CompilationInfo compilationInfo = jsRuleContext.compilationInfo;
        BaseDocument baseDocument = jsRuleContext.doc;
        OffsetRange offsetRange = null;
        int n = error.getStartPosition();
        int n2 = LexUtilities.getLexerOffset((CompilationInfo)compilationInfo, (int)n);
        if (n2 == -1) {
            return;
        }
        if (TRAILING_COMMA.equals(this.key)) {
            if (!SupportedBrowsers.getInstance().isSupported(BrowserVersion.IE7)) {
                jsRuleContext.remove = true;
                return;
            }
            n = (Integer)error.getParameters()[0];
            n2 = LexUtilities.getLexerOffset((CompilationInfo)compilationInfo, (int)n);
            if (n2 == -1) {
                return;
            }
            offsetRange = new OffsetRange(n2, n2 + 1);
        } else if (RESERVED_KEYWORD.equals(this.key)) {
            String string = (String)error.getParameters()[1];
            if ("debugger".equals(string)) {
                jsRuleContext.remove = true;
                return;
            }
            offsetRange = new OffsetRange(n2 - string.length(), n2);
        } else if (error.getParameters() != null) {
            JsParseResult jsParseResult;
            OffsetRange offsetRange2;
            Node node2 = (Node)error.getParameters()[0];
            boolean bl = RETURN_INCONSISTENT.equals(this.key);
            if (bl) {
                for (node = node2; node != null; node = node.getParentNode()) {
                    if (node.getType() != 4) continue;
                    node2 = node;
                    break;
                }
            }
            if (this.key.equals(NO_SIDE_EFFECTS) && node2.hasChildren() && node2.getFirstChild().getType() == 38 && "debugger".equals(node2.getFirstChild().getString())) {
                jsRuleContext.remove = true;
                return;
            }
            if (!"text/javascript".equals(compilationInfo.getFileObject().getMIMEType())) {
                jsRuleContext.remove = true;
                return;
            }
            if (node2.getType() == 129 && (node = node2.getFirstChild()) != null && node.getType() == 38 && JsModel.isGeneratedIdentifier((String)node.getString())) {
                jsRuleContext.remove = true;
                return;
            }
            node = AstUtilities.getRange((Node)node2);
            offsetRange = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)node);
            if (offsetRange.getLength() == 0) {
                int n3 = Math.min(baseDocument.getLength(), offsetRange.getStart());
                offsetRange = new OffsetRange(n3, Math.min(baseDocument.getLength(), n3 + 1));
            }
            if (this.key.equals(NO_SIDE_EFFECTS) && ((offsetRange2 = (jsParseResult = (JsParseResult)jsRuleContext.parserResult).getSanitizedRange()).overlaps(offsetRange) || offsetRange2.containsInclusive(offsetRange.getStart()) || offsetRange2.containsInclusive(offsetRange.getEnd()))) {
                jsRuleContext.remove = true;
                return;
            }
        } else {
            int n4 = n2;
            n4 = Math.min(n4, baseDocument.getLength());
            try {
                int n5 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n4);
                if (n5 <= n4 && n4 == (n5 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n4))) {
                    n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n4);
                    n5 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n4) + 1;
                }
                offsetRange = new OffsetRange(n4, n5);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                offsetRange = OffsetRange.NONE;
            }
        }
        if (offsetRange != OffsetRange.NONE) {
            List<Object> list2;
            offsetRange = StrictWarning.limitErrorToLine(baseDocument, offsetRange, n2);
            if (this.key.equals(TRAILING_COMMA)) {
                list2 = new ArrayList<RemoveTrailingCommaFix>(2);
                list2.add(new RemoveTrailingCommaFix(jsRuleContext, n2));
                list2.add(new MoreInfoFix(this.key));
            } else if (this.key.equals(NO_SIDE_EFFECTS)) {
                Node node3 = (Node)error.getParameters()[0];
                if (node3.getType() == 129) {
                    list2 = new ArrayList(2);
                    list2.add(new AssignToVar(jsRuleContext, node3, true));
                    node = node3.getNext();
                    if (node != null && node.getType() == 4 && !node.hasChildren() && node.getSourceStart() == node.getSourceEnd()) {
                        list2.add(new AssignToVar(jsRuleContext, node3, false));
                    }
                    list2.add(new MoreInfoFix(this.key));
                } else {
                    list2 = Collections.singletonList(new MoreInfoFix(this.key));
                }
            } else {
                list2 = Collections.singletonList(new MoreInfoFix(this.key));
            }
            String string = this.getDisplayName();
            if (string.indexOf("{0}") != -1) {
                string = error.getDisplayName();
            }
            node = new Hint((Rule)this, string, compilationInfo.getFileObject(), offsetRange, list2, 500);
            list.add((Hint)node);
        }
    }

    static OffsetRange limitErrorToLine(BaseDocument baseDocument, OffsetRange offsetRange, int n) {
        try {
            offsetRange = offsetRange.boundTo(0, baseDocument.getLength());
            if (offsetRange.getStart() == 0) {
                n = Math.min(n, baseDocument.getLength());
                int n2 = Math.max(offsetRange.getStart(), Utilities.getRowStart((BaseDocument)baseDocument, (int)n));
                int n3 = Math.max(n2, Math.min(offsetRange.getEnd(), baseDocument.getLength()));
                if ((n3 = Math.min(n3, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2))) == n2) {
                    n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3);
                }
                offsetRange = new OffsetRange(n2, n3);
            } else {
                int n4 = offsetRange.getStart();
                int n5 = Math.min(Utilities.getRowEnd((BaseDocument)baseDocument, (int)n4), offsetRange.getEnd());
                offsetRange = new OffsetRange(Math.min(n4, n5), n5);
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return offsetRange;
    }

    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(StrictWarning.class, (String)this.key);
    }

    public void setDefaultSeverity(HintSeverity hintSeverity) {
        this.defaultSeverity = hintSeverity;
    }

    public boolean showInTasklist() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return this.defaultSeverity;
    }

    public String getId() {
        return this.key;
    }

    public String getDescription() {
        return NbBundle.getMessage(StrictWarning.class, (String)(this.key + ".desc"));
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    private static class AssignToVar
    implements PreviewableFix {
        private final boolean assign;
        private final JsRuleContext context;
        private final Node node;
        private int varOffset;
        private String varName;

        public AssignToVar(JsRuleContext jsRuleContext, Node node, boolean bl) {
            this.context = jsRuleContext;
            this.node = node;
            this.assign = bl;
        }

        public String getDescription() {
            return this.assign ? NbBundle.getMessage(StrictWarning.class, (String)"AssignToVarFix") : NbBundle.getMessage(StrictWarning.class, (String)"AssignToReturnFix");
        }

        public EditList getEditList() throws Exception {
            OffsetRange offsetRange;
            BaseDocument baseDocument = this.context.doc;
            EditList editList = new EditList(baseDocument);
            OffsetRange offsetRange2 = AstUtilities.getRange((Node)this.node);
            if (offsetRange2 != OffsetRange.NONE && (offsetRange = LexUtilities.getLexerOffsets((CompilationInfo)this.context.compilationInfo, (OffsetRange)offsetRange2)) != OffsetRange.NONE) {
                if (this.assign) {
                    int n = offsetRange.getStart();
                    StringBuilder stringBuilder = new StringBuilder();
                    this.varName = NbBundle.getMessage(StrictWarning.class, (String)"VarName");
                    stringBuilder.append(this.varName);
                    stringBuilder.append(" = ");
                    this.varOffset = n;
                    editList.replace(n, 0, stringBuilder.toString(), false, 0);
                } else if (this.node.getNext() != null && this.node.getNext().getType() == 4 && !this.node.getNext().hasChildren()) {
                    Node node = this.node.getNext();
                    int n = node.getSourceEnd();
                    int n2 = node.getSourceStart();
                    boolean bl = n2 == n;
                    int n3 = offsetRange.getStart();
                    editList.replace(n3, 0, "return ", false, 0);
                    if (!bl) {
                        int n4 = n - n2;
                        if (n < baseDocument.getLength() && "return;".equals(baseDocument.getText(n2, n4 + 1))) {
                            ++n4;
                        }
                        editList.replace(n2, n4, "", false, 0);
                    }
                }
            }
            return editList;
        }

        public void implement() throws Exception {
            JTextComponent jTextComponent;
            EditList editList = this.getEditList();
            Position position = editList.createPosition(this.varOffset);
            editList.apply();
            if (position != null && position.getOffset() != -1 && (jTextComponent = GsfUtilities.getPaneFor((FileObject)this.context.compilationInfo.getFileObject())) != null) {
                int n = position.getOffset();
                int n2 = n + this.varName.length();
                jTextComponent.select(n, n2);
            }
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }

    private static class RemoveTrailingCommaFix
    implements PreviewableFix {
        private final JsRuleContext context;
        private final int offset;

        public RemoveTrailingCommaFix(JsRuleContext jsRuleContext, int n) {
            this.context = jsRuleContext;
            this.offset = n;
        }

        public String getDescription() {
            return NbBundle.getMessage(StrictWarning.class, (String)"RemoveTrailingCommaFix");
        }

        public void implement() throws Exception {
            EditList editList = this.getEditList();
            if (editList != null) {
                editList.apply();
            }
        }

        public EditList getEditList() throws Exception {
            BaseDocument baseDocument = this.context.doc;
            EditList editList = new EditList(baseDocument);
            editList.replace(this.offset, 1, null, false, 0);
            return editList;
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

