/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.netbeans.modules.websvc.saas.model.WsdlSaasPort;
import org.netbeans.modules.websvc.saas.model.jaxb.Method;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasServices;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.util.WsdlUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlSaas
extends Saas
implements PropertyChangeListener {
    private WsdlData wsData;
    private List<WsdlSaasPort> ports;

    public WsdlSaas(SaasGroup saasGroup, SaasServices saasServices) {
        super(saasGroup, saasServices);
    }

    public WsdlSaas(SaasGroup saasGroup, String string, String string2, String string3) {
        super(saasGroup, string, string2, string3);
        this.getDelegate().setType("http://schemas.xmlsoap.org/wsdl/");
    }

    protected void setWsdlData(WsdlData wsdlData) {
        this.wsData = wsdlData;
        if (this.wsData.isReady()) {
            this.setState(Saas.State.READY);
        } else {
            this.setState(Saas.State.UNINITIALIZED);
        }
    }

    public WsdlData getWsdlData() {
        Saas.State state = this.getState();
        if (state == Saas.State.RETRIEVED || state == Saas.State.READY) {
            return this.wsData;
        }
        throw new IllegalStateException("Current state: " + (Object)((Object)state));
    }

    @Override
    protected void refresh() {
        if (this.getState() == Saas.State.INITIALIZING) {
            throw new IllegalStateException(NbBundle.getMessage(WsdlSaas.class, (String)"MSG_CantRefreshWhileInitializing"));
        }
        super.refresh();
        this.ports = null;
        if (this.wsData == null) {
            this.wsData = WsdlUtil.findWsdlData(this.getUrl(), null);
            if (this.wsData == null) {
                this.toStateReady(false);
                return;
            }
            this.wsData = null;
            this.toStateReady(true);
        }
        WsdlUtil.refreshWsdlData(this.wsData);
    }

    public String getDefaultServiceName() {
        if (this.getMethods().size() > 0) {
            return this.getMethods().get(0).getMethod().getServiceName();
        }
        return "";
    }

    @Override
    public String getPackageName() {
        String string = this.getDelegate().getSaasMetadata().getCodeGen().getPackageName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public void toStateReady(boolean bl) {
        if (this.getState() == Saas.State.REMOVED) {
            return;
        }
        if (this.wsData == null) {
            String string = this.getDefaultServiceName();
            this.wsData = WsdlUtil.getWsdlData(this.getUrl(), string, bl);
            if (this.wsData == null) {
                this.wsData = WsdlUtil.addWsdlData(this.getUrl(), this.getPackageName());
                if (this.wsData != null && bl) {
                    int n = 0;
                    while (!this.wsData.isReady() && n < 100) {
                        try {
                            Thread.sleep(100L);
                            ++n;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            if (this.wsData != null) {
                this.wsData.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.wsData));
                if (this.wsData.isReady()) {
                    this.setState(Saas.State.READY);
                } else {
                    this.setState(Saas.State.INITIALIZING);
                }
            } else {
                this.setState(Saas.State.UNINITIALIZED);
            }
        }
    }

    private List<WSPort> filterNonSoapPorts(List<WSPort> list) {
        ArrayList<WSPort> arrayList = new ArrayList<WSPort>(list.size());
        for (WSPort wSPort : list) {
            if (wSPort.getAddress() == null) continue;
            arrayList.add(wSPort);
        }
        return arrayList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        if (string.equals("resolved") && this.getState() == Saas.State.INITIALIZING) {
            if (Boolean.FALSE.equals(object)) {
                this.setState(Saas.State.RETRIEVED);
            } else if (this.wsData.isReady()) {
                this.setState(Saas.State.READY);
            }
        } else if (WsdlData.Status.WSDL_SERVICE_COMPILED.equals(object)) {
            this.setState(Saas.State.READY);
        } else if (WsdlData.Status.WSDL_SERVICE_COMPILE_FAILED.equals(object)) {
            this.setState(Saas.State.RETRIEVED);
        } else if (WsdlData.Status.WSDL_UNRETRIEVED.equals(object)) {
            this.setState(Saas.State.UNINITIALIZED);
        }
    }

    public WSService getWsdlModel() {
        return this.getWsdlData().getWsdlService();
    }

    public FileObject getLocalWsdlFile() {
        return FileUtil.toFileObject((File)new File(this.getWsdlData().getWsdlFile()));
    }

    public List<WsdlSaasPort> getPorts() {
        if (this.ports == null) {
            this.ports = new ArrayList<WsdlSaasPort>();
            for (WSPort wSPort : this.filterNonSoapPorts(this.getWsdlModel().getPorts())) {
                this.ports.add(new WsdlSaasPort(this, wSPort));
            }
        }
        return new ArrayList<WsdlSaasPort>(this.ports);
    }

    @Override
    protected WsdlSaasMethod createSaasMethod(Method method) {
        return new WsdlSaasMethod(this, method);
    }

    @Override
    public FileObject getSaasFolder() {
        if (this.saasFolder == null) {
            String string = WsdlUtil.getServiceDirName(this.getUrl());
            FileObject fileObject = SaasServicesModel.getWebServiceHome();
            this.saasFolder = fileObject.getFileObject(string);
            if (this.saasFolder == null) {
                try {
                    this.saasFolder = fileObject.createFolder(string);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        return this.saasFolder;
    }
}

