/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.netbeans.modules.cnd.dwarfdump.Magic;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;

public class FileMagic {
    private RandomAccessFile reader;
    private Magic magic;

    public FileMagic(String string) throws FileNotFoundException, WrongFileFormatException {
        this.reader = new RandomAccessFile(string, "r");
        this.readMagic();
    }

    public RandomAccessFile getReader() {
        return this.reader;
    }

    public Magic getMagic() {
        return this.magic;
    }

    private void readMagic() throws WrongFileFormatException {
        byte[] byArray = new byte[8];
        try {
            this.reader.readFully(byArray);
        }
        catch (IOException iOException) {
            this.dispose();
            throw new WrongFileFormatException("Not an ELF/PE/COFF/MACH-O file");
        }
        if (FileMagic.isElfMagic(byArray)) {
            this.magic = Magic.Elf;
        } else if (FileMagic.isCoffMagic(byArray)) {
            this.magic = Magic.Coff;
        } else if (FileMagic.isExeMagic(byArray)) {
            this.magic = Magic.Exe;
        } else if (FileMagic.isPeMagic(byArray)) {
            this.magic = Magic.Pe;
        } else if (FileMagic.isMachoMagic(byArray)) {
            this.magic = Magic.Macho;
        } else if (FileMagic.isArchiveMagic(byArray)) {
            this.magic = Magic.Arch;
        } else {
            this.dispose();
            throw new WrongFileFormatException("Not an ELF/PE/COFF/MACH-O file");
        }
    }

    public void dispose() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.reader = null;
        }
    }

    public static boolean isExeMagic(byte[] byArray) {
        return byArray[0] == 77 && byArray[1] == 90;
    }

    public static boolean isPeMagic(byte[] byArray) {
        return byArray[0] == 80 && byArray[1] == 69 && byArray[2] == 0 && byArray[3] == 0;
    }

    public static boolean isCoffMagic(byte[] byArray) {
        return byArray[0] == 76 && byArray[1] == 1;
    }

    public static boolean isElfMagic(byte[] byArray) {
        return byArray[0] == 127 && byArray[1] == 69 && byArray[2] == 76 && byArray[3] == 70;
    }

    public static boolean isMachoMagic(byte[] byArray) {
        return (byArray[0] == -50 || byArray[0] == -49) && byArray[1] == -6 && byArray[2] == -19 && byArray[3] == -2;
    }

    public static boolean isArchiveMagic(byte[] byArray) {
        return byArray[0] == 33 && byArray[1] == 60 && byArray[2] == 97 && byArray[3] == 114 && byArray[4] == 99 && byArray[5] == 104 && byArray[6] == 62 && byArray[7] == 10;
    }
}

