/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.openide.util.Lookup;

public abstract class CsmClassifierResolver {
    private static CsmClassifierResolver DEFAULT = new Default();

    public abstract CsmClassifier getOriginalClassifier(CsmClassifier var1);

    public CsmClassifier findClassifierUsedInFile(CharSequence charSequence, CsmFile csmFile, boolean bl) {
        CsmProject csmProject;
        if (csmFile != null && (csmProject = csmFile.getProject()) != null) {
            return csmProject.findClassifier(charSequence);
        }
        return null;
    }

    protected CsmClassifierResolver() {
    }

    public static synchronized CsmClassifierResolver getDefault() {
        return DEFAULT;
    }

    private static final class Default
    extends CsmClassifierResolver {
        private final Lookup.Result<CsmClassifierResolver> res = Lookup.getDefault().lookupResult(CsmClassifierResolver.class);
        private static final boolean FIX_SERVICE = true;
        private CsmClassifierResolver fixedResolver;

        Default() {
        }

        private CsmClassifierResolver getService() {
            CsmClassifierResolver csmClassifierResolver = this.fixedResolver;
            if (csmClassifierResolver == null) {
                Iterator iterator = this.res.allInstances().iterator();
                if (iterator.hasNext()) {
                    CsmClassifierResolver csmClassifierResolver2;
                    csmClassifierResolver = csmClassifierResolver2 = (CsmClassifierResolver)iterator.next();
                }
                if (csmClassifierResolver != null) {
                    this.fixedResolver = csmClassifierResolver;
                }
            }
            return csmClassifierResolver;
        }

        public CsmClassifier getOriginalClassifier(CsmClassifier csmClassifier) {
            CsmClassifierResolver csmClassifierResolver = this.getService();
            if (csmClassifierResolver != null) {
                return csmClassifierResolver.getOriginalClassifier(csmClassifier);
            }
            return csmClassifier;
        }

        public CsmClassifier findClassifierUsedInFile(CharSequence charSequence, CsmFile csmFile, boolean bl) {
            CsmClassifierResolver csmClassifierResolver = this.getService();
            if (csmClassifierResolver != null) {
                return csmClassifierResolver.findClassifierUsedInFile(charSequence, csmFile, bl);
            }
            return super.findClassifierUsedInFile(charSequence, csmFile, bl);
        }
    }
}

