/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.actions.AbstractExecutorRunAction;
import org.netbeans.modules.cnd.api.execution.ExecutionListener;
import org.netbeans.modules.cnd.api.execution.NativeExecutor;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.loaders.ShellDataObject;
import org.openide.LifecycleManager;
import org.openide.cookies.SaveCookie;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;

public class ShellRunAction
extends AbstractExecutorRunAction {
    public String getName() {
        return ShellRunAction.getString("BTN_Run");
    }

    protected boolean accept(DataObject dataObject) {
        return dataObject instanceof ShellDataObject;
    }

    protected void performAction(Node[] nodeArray) {
        LifecycleManager.getDefault().saveAll();
        for (int i = 0; i < nodeArray.length; ++i) {
            ShellRunAction.performAction(nodeArray[i]);
        }
    }

    public static void performAction(Node node) {
        int n;
        int n2;
        ShellExecSupport shellExecSupport = (ShellExecSupport)node.getCookie(ShellExecSupport.class);
        if (shellExecSupport == null) {
            return;
        }
        SaveCookie saveCookie = (SaveCookie)node.getLookup().lookup(SaveCookie.class);
        if (saveCookie != null) {
            try {
                saveCookie.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        File file = FileUtil.toFile((FileObject)fileObject);
        String string = shellExecSupport.getRunDirectory();
        File file2 = string.length() == 0 || string.equals(".") ? file.getParentFile() : (IpeUtils.isPathAbsolute(string) ? new File(string) : new File(file.getParentFile(), string));
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string2 = ShellRunAction.getString("RUN_LABEL", node.getName());
        String[] stringArray = shellExecSupport.getShellCommandAndArgs(fileObject);
        String string3 = stringArray[0];
        String string4 = IpeUtils.toRelativePath(file2.getPath(), file.getPath());
        String[] stringArray2 = shellExecSupport.getArguments();
        String string5 = ShellRunAction.getDevelopmentHost(fileObject);
        if (PlatformInfo.getDefault(string5).isWindows() && string3.length() > 0 && (n2 = string3.lastIndexOf("/")) >= 0) {
            string3 = string3.substring(n2 + 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray[0].length() > 0) {
            for (n = 1; n < stringArray.length; ++n) {
                stringBuilder.append(" ");
                stringBuilder.append(stringArray[n]);
            }
        }
        stringBuilder.append(string4);
        for (n = 0; n < stringArray2.length; ++n) {
            stringBuilder.append(" ");
            stringBuilder.append(stringArray2[n]);
        }
        NativeExecutor nativeExecutor = new NativeExecutor(string5, file2.getPath(), string3, stringBuilder.toString(), ShellRunAction.prepareEnv(string5), string2, "Run", false, true, false);
        new ShellExecuter(nativeExecutor).execute();
    }

    private static ProgressHandle createPogressHandle(final AbstractAction abstractAction, final NativeExecutor nativeExecutor) {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)nativeExecutor.getTabeName(), (Cancellable)new Cancellable(){

            public boolean cancel() {
                abstractAction.actionPerformed(null);
                return true;
            }
        }, (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                nativeExecutor.getTab().select();
            }
        });
        progressHandle.setInitialDelay(0);
        return progressHandle;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static final class StopAction
    extends AbstractAction {
        private final ShellExecuter shellExecutor;

        public StopAction(ShellExecuter shellExecuter) {
            this.shellExecutor = shellExecuter;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setEnabled(false);
            if (this.shellExecutor.getExecutorTask() != null) {
                this.shellExecutor.getExecutorTask().stop();
            }
        }
    }

    private static class ShellExecuter
    implements ExecutionListener {
        private final NativeExecutor nativeExecutor;
        private final ProgressHandle progressHandle;
        private ExecutorTask executorTask = null;

        public ShellExecuter(NativeExecutor nativeExecutor) {
            this.nativeExecutor = nativeExecutor;
            nativeExecutor.addExecutionListener(this);
            this.progressHandle = ShellRunAction.createPogressHandle(new StopAction(this), nativeExecutor);
        }

        public void execute() {
            try {
                this.executorTask = this.nativeExecutor.execute();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void executionFinished(int n) {
            this.progressHandle.finish();
        }

        public void executionStarted() {
            this.progressHandle.start();
        }

        public ExecutorTask getExecutorTask() {
            return this.executorTask;
        }
    }
}

