/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.compilers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.utils.RemoteUtils;

public class CompilerSetManagerEvents {
    private static final Map<String, CompilerSetManagerEvents> map = new HashMap<String, CompilerSetManagerEvents>();
    private final String hkey;
    private boolean isCodeModelInfoReady;
    private List<Runnable> tasks = new ArrayList<Runnable>();

    public static synchronized CompilerSetManagerEvents get(String string) {
        CompilerSetManagerEvents compilerSetManagerEvents = map.get(string);
        if (compilerSetManagerEvents == null) {
            compilerSetManagerEvents = new CompilerSetManagerEvents(string);
            map.put(string, compilerSetManagerEvents);
        }
        return compilerSetManagerEvents;
    }

    public CompilerSetManagerEvents(String string) {
        this.hkey = string;
        this.isCodeModelInfoReady = CompilerSetManager.getDefault(string).isComplete();
    }

    public void runOnCodeModelReadiness(Runnable runnable) {
        if (RemoteUtils.isLocalhost(this.hkey) || this.isCodeModelInfoReady) {
            runnable.run();
        } else {
            this.tasks.add(runnable);
        }
    }

    void runTasks() {
        this.isCodeModelInfoReady = true;
        if (this.tasks != null) {
            for (Runnable runnable : this.tasks) {
                runnable.run();
            }
        }
        this.tasks = null;
    }
}

