/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.remote;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.remote.InteractiveCommandProvider;
import org.netbeans.modules.cnd.api.utils.RemoteUtils;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public abstract class InteractiveCommandProviderFactory {
    protected abstract InteractiveCommandProvider createInstance(String var1);

    protected InteractiveCommandProviderFactory() {
    }

    public static InteractiveCommandProvider create(String string) {
        InteractiveCommandProviderFactory interactiveCommandProviderFactory = null;
        interactiveCommandProviderFactory = RemoteUtils.isLocalhost(string) ? Default.instance : (InteractiveCommandProviderFactory)Lookup.getDefault().lookup(InteractiveCommandProviderFactory.class);
        return interactiveCommandProviderFactory == null ? null : interactiveCommandProviderFactory.createInstance(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LocalInteractiveCommandProvider
    implements InteractiveCommandProvider {
        private Process process;
        int exitStatus = -1;

        private LocalInteractiveCommandProvider() {
        }

        @Override
        public boolean run(List<String> list, String string, Map<String, String> map) {
            ProcessBuilder processBuilder = new ProcessBuilder(list);
            Map<String, String> map2 = processBuilder.environment();
            for (String string2 : map.keySet()) {
                map2.put(string2, map.get(string2));
            }
            processBuilder.directory(new File(string));
            processBuilder.redirectErrorStream(true);
            try {
                this.process = processBuilder.start();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return false;
            }
            return false;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.process == null ? null : this.process.getInputStream();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.process == null ? null : this.process.getOutputStream();
        }

        @Override
        public void disconnect() {
        }

        @Override
        public int waitFor() {
            if (this.process != null) {
                try {
                    this.exitStatus = this.process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            return this.exitStatus;
        }

        @Override
        public int getExitStatus() {
            return this.exitStatus;
        }

        @Override
        public boolean run(String string, String string2, Map<String, String> map) {
            throw new UnsupportedOperationException("deprecated.");
        }
    }

    private static class Default
    extends InteractiveCommandProviderFactory {
        private static InteractiveCommandProviderFactory instance = new Default();

        private Default() {
        }

        public InteractiveCommandProvider createInstance(String string) {
            if (RemoteUtils.isLocalhost(string)) {
                return new LocalInteractiveCommandProvider();
            }
            return null;
        }
    }
}

