/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.xml;

import java.io.BufferedWriter;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.netbeans.modules.cnd.api.xml.AttrValuePair;
import org.openide.xml.XMLUtil;

public class XMLEncoderStream {
    private String indentElement = "  ";
    private int indent;
    private PrintWriter writer;
    private OutputStream os;

    XMLEncoderStream(OutputStream outputStream, int n, String string) {
        this.os = outputStream;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string));
            this.writer = new PrintWriter(bufferedWriter);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            this.writer = new PrintWriter(outputStream);
        }
        this.makeIndentElement(n);
    }

    private void makeIndentElement(int n) {
        this.indentElement = "";
        if (n > 20) {
            n = 20;
        }
        for (int i = 0; i < n; ++i) {
            this.indentElement = this.indentElement + " ";
        }
    }

    public void elementOpen(String string, int n, AttrValuePair[] attrValuePairArray) {
        this.writeIndent();
        this.writer.print("<" + string);
        this.writeAttrs(string, n, attrValuePairArray, true);
        this.writer.println(">");
        ++this.indent;
    }

    public void elementOpen(String string, AttrValuePair[] attrValuePairArray) {
        this.elementOpen(string, -1, attrValuePairArray);
    }

    public void elementOpen(String string, int n) {
        this.elementOpen(string, n, null);
    }

    public void elementOpen(String string) {
        this.elementOpen(string, -1, null);
    }

    public void elementClose(String string) {
        --this.indent;
        if (this.indent < 0) {
            this.indent = 0;
        }
        this.writeIndent();
        this.writer.println("</" + string + ">");
    }

    public void element(String string, AttrValuePair[] attrValuePairArray) {
        this.element(string, -1, attrValuePairArray, null);
    }

    public void element(String string, String string2) {
        this.element(string, -1, null, string2);
    }

    public void element(String string, int n, AttrValuePair[] attrValuePairArray, String string2) {
        this.writeIndent();
        this.writer.print("<" + string);
        this.writeAttrs(string, n, attrValuePairArray, true);
        if (string2 == null) {
            this.writer.print("/>");
        } else {
            this.writer.print(">");
        }
        if (string2 != null) {
            this.writer.print(XMLEncoderStream.escapeContent(string2));
            this.writer.print("</" + string + ">");
        }
        this.writer.println();
    }

    void close() throws IOException {
        this.writer.flush();
        this.writer.close();
        this.writer = null;
        this.os.close();
    }

    void println(String string) {
        this.writer.println(string);
    }

    private void writeIndent(int n) {
        int n2;
        for (n2 = 0; n2 < this.indent; ++n2) {
            this.writer.print(this.indentElement);
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.writer.print(' ');
        }
    }

    private void writeIndent() {
        this.writeIndent(0);
    }

    private boolean needFormat(String string, int n, AttrValuePair[] attrValuePairArray, boolean bl) {
        int n2;
        if (!bl) {
            return false;
        }
        int n3 = n2 = 1 + string.length() + 1;
        if (n >= 0) {
            n3 += " version=\"\"".length();
            n3 += ("" + n).length();
        }
        if (n3 > 80) {
            return true;
        }
        if (attrValuePairArray != null) {
            for (int i = 0; i < attrValuePairArray.length; ++i) {
                AttrValuePair attrValuePair = attrValuePairArray[i];
                n3 += " ".length();
                n3 += attrValuePair.getAttr().length();
                n3 += "=\"".length();
                n3 += attrValuePair.getValue().length();
                if ((n3 += "\"".length()) <= 80) continue;
                return true;
            }
        }
        return false;
    }

    private void writeAttrs(String string, int n, AttrValuePair[] attrValuePairArray, boolean bl) {
        int n2 = 0;
        bl = this.needFormat(string, n, attrValuePairArray, bl);
        if (n != -1) {
            this.writer.print(" version=\"");
            this.writer.print(n);
            this.writer.print("\"");
            ++n2;
        }
        if (attrValuePairArray != null) {
            int n3 = 1 + string.length() + 1;
            for (int i = 0; i < attrValuePairArray.length; ++i) {
                AttrValuePair attrValuePair = attrValuePairArray[i];
                if (n2 >= 1 && bl) {
                    this.writer.println();
                    this.writeIndent(n3);
                } else {
                    this.writer.print(" ");
                }
                this.writer.print(attrValuePair.getAttr());
                this.writer.print("=\"");
                this.writer.print(XMLEncoderStream.escapeAttributeValue(attrValuePair.getValue()));
                this.writer.print("\"");
                ++n2;
            }
        }
    }

    public static String escapeAttributeValue(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string;
        try {
            string2 = XMLUtil.toAttributeValue((String)string);
        }
        catch (CharConversionException charConversionException) {
            // empty catch block
        }
        return string2;
    }

    public static String escapeContent(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string;
        try {
            string2 = XMLUtil.toElementContent((String)string);
        }
        catch (CharConversionException charConversionException) {
            // empty catch block
        }
        return string2;
    }
}

