/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.editor.filecreation.CndExtensionList;
import org.netbeans.modules.cnd.editor.filecreation.CndHandlableExtensions;
import org.openide.util.NbPreferences;

public class ExtensionsSettings {
    private final String name;
    private CndExtensionList savedExtensionsList;
    private static final Map<String, ExtensionsSettings> settingsAccessors = new HashMap<String, ExtensionsSettings>();
    private static final Preferences preferences = NbPreferences.forModule(ExtensionsSettings.class);
    private final String defaultExtensionKey;
    private static final String EXTENSIONS_LIST_PREFIX = "ext-list-";
    private static final String DELIMITER = ",";
    public static final String HEADER = "CndHeader";
    public static final String C_FILE = "CndCFile";
    public static final String CPP_FILE = "CndCppFile";
    public static final String MAKEFILE = "CndMakefile";
    public static final String SHELL = "CndShellFile";
    public static final String FORTRAN = "CndFortranFile";
    public static final String ASM = "CndAsmFile";
    private static final Map<String, String[]> defaultExtensions = new HashMap<String, String[]>();

    private ExtensionsSettings(String string, CndHandlableExtensions cndHandlableExtensions) {
        this.name = string;
        this.defaultExtensionKey = "def-ext-" + string;
        String string2 = preferences.get(EXTENSIONS_LIST_PREFIX + string, null);
        if (string2 == null) {
            this.savedExtensionsList = (CndExtensionList)cndHandlableExtensions.getDefaultExtensionList();
            String string3 = this.savedExtensionsList.extensions().nextElement();
            this.setDefaultExtension(string3, false);
        } else {
            this.savedExtensionsList = new CndExtensionList(string2.split(DELIMITER));
        }
        assert (this.savedExtensionsList.extensions().hasMoreElements());
    }

    public static boolean isRegistered(String string, String string2) {
        String string3 = preferences.get(EXTENSIONS_LIST_PREFIX + string2, null);
        String[] stringArray = string3 == null ? ExtensionsSettings.getCndDefaultExtensions(string2) : string3.split(DELIMITER);
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (!string4.equals(string)) continue;
            return true;
        }
        return false;
    }

    private ExtensionsSettings(ExtensionsSettings extensionsSettings, String string) {
        this.name = extensionsSettings.name;
        this.defaultExtensionKey = string + this.name;
        this.savedExtensionsList = extensionsSettings.savedExtensionsList;
        String string2 = this.getDefaultExtension(extensionsSettings.getDefaultExtension());
        this.setDefaultExtension(this.isKnownExtension(string2) ? string2 : extensionsSettings.getDefaultExtension());
    }

    public static synchronized ExtensionsSettings getInstance(CndHandlableExtensions cndHandlableExtensions) {
        String string = cndHandlableExtensions.getSettingsName();
        ExtensionsSettings extensionsSettings = settingsAccessors.get(string);
        if (extensionsSettings == null) {
            extensionsSettings = new ExtensionsSettings(string, cndHandlableExtensions);
            settingsAccessors.put(string, extensionsSettings);
        }
        return extensionsSettings;
    }

    public String getDefaultExtension() {
        String string = this.getDefaultExtension("");
        assert (string.length() > 0);
        return string;
    }

    private String getDefaultExtension(String string) {
        return preferences.get(this.defaultExtensionKey, string);
    }

    public synchronized void setDefaultExtension(String string) {
        this.setDefaultExtension(string, true);
    }

    public void addExtension(String string) {
        if (!this.isKnownExtension(string)) {
            CndExtensionList cndExtensionList = this.getExtensionList();
            cndExtensionList.addExtension(string);
            this.setExtensionList(cndExtensionList);
        }
    }

    private void setDefaultExtension(String string, boolean bl) {
        if (bl) {
            this.addExtension(string);
        }
        preferences.put(this.defaultExtensionKey, string);
    }

    public synchronized CndExtensionList getExtensionList() {
        return this.savedExtensionsList;
    }

    public synchronized void setExtensionList(CndExtensionList cndExtensionList) {
        String string = "";
        Enumeration<String> enumeration = cndExtensionList.extensions();
        assert (enumeration.hasMoreElements());
        while (enumeration.hasMoreElements()) {
            if (string.length() > 0) {
                string = string + DELIMITER;
            }
            string = string + enumeration.nextElement();
        }
        this.savedExtensionsList = cndExtensionList;
        if (!this.isKnownExtension(this.getDefaultExtension())) {
            this.setDefaultExtension(this.savedExtensionsList.extensions().nextElement(), false);
        }
        preferences.put(EXTENSIONS_LIST_PREFIX + this.name, string);
    }

    public boolean isKnownExtension(String string) {
        if (string == null) {
            return false;
        }
        return this.getExtensionList().isRegistered(string);
    }

    ExtensionsSettings getSpecializedInstance(String string) {
        return new ExtensionsSettings(this, string);
    }

    private static CndExtensionList arrayToExtensionList(String[] stringArray) {
        return new CndExtensionList(stringArray);
    }

    private static String[] getCndDefaultExtensions(String string) {
        return defaultExtensions.get(string);
    }

    public static CndExtensionList getDefaultExtensionList(String string) {
        return ExtensionsSettings.arrayToExtensionList(ExtensionsSettings.getCndDefaultExtensions(string));
    }

    static {
        defaultExtensions.put(HEADER, new String[]{"h", "H", "hpp", "hxx", "SUNWCCh", "tcc"});
        defaultExtensions.put(C_FILE, new String[]{"c", "i", "m"});
        defaultExtensions.put(CPP_FILE, new String[]{"cpp", "cc", "c++", "cxx", "C", "mm"});
        defaultExtensions.put(MAKEFILE, new String[]{"mk"});
        defaultExtensions.put(ASM, new String[]{"s", "as", "asm"});
        defaultExtensions.put(SHELL, new String[]{"bash", "csh", "ksh", "sh", "zsh", "bat", "cmd"});
        defaultExtensions.put(FORTRAN, new String[]{"f", "F", "f90", "F90", "f95", "F95", "f03", "F03", "for", "il", "mod"});
    }
}

