/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran;

import java.io.IOException;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.modules.cnd.editor.fortran.FFormatSupport;
import org.netbeans.modules.cnd.editor.fortran.FSyntax;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

public class FFormatter
extends ExtFormatter {
    public FFormatter(Class clazz) {
        super(clazz);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof FSyntax;
    }

    protected void initFormatLayers() {
        this.addFormatLayer((FormatLayer)new FortranLayer());
    }

    public Writer reformat(BaseDocument baseDocument, int n, int n2, boolean bl) throws BadLocationException, IOException {
        return super.reformat(baseDocument, n, n2, bl);
    }

    public int reformat(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        return super.reformat(baseDocument, n, n2);
    }

    public void shiftLine(BaseDocument baseDocument, int n, boolean bl) throws BadLocationException {
        StatusDisplayer.getDefault().setStatusText(NbBundle.getBundle(FFormatter.class).getString("MSG_NoFortranShifting"));
    }

    public int[] getReformatBlock(JTextComponent jTextComponent, String string) {
        int[] nArray = null;
        BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
        int n = jTextComponent.getCaret().getDot();
        if (baseDocument != null && (nArray = this.getKeywordBasedReformatBlock(baseDocument, n, string)) == null) {
            nArray = super.getReformatBlock(jTextComponent, string);
        }
        return nArray;
    }

    private int[] getKeywordBasedReformatBlock(BaseDocument baseDocument, int n, String string) {
        int[] nArray = null;
        if ("e".equals(string) || "E".equals(string)) {
            try {
                int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                if (this.checkCase(baseDocument, n2, "else")) {
                    nArray = new int[]{n2, n2 + 4};
                } else if (this.checkCase(baseDocument, n2, "endsubroutine")) {
                    nArray = new int[]{n2, n2 + 13};
                } else if (this.checkCase(baseDocument, n2, "end subroutine")) {
                    nArray = new int[]{n2, n2 + 14};
                }
            }
            catch (BadLocationException badLocationException) {}
        } else if ("o".equals(string) || "O".equals(string)) {
            try {
                int n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                if (this.checkCase(baseDocument, n3, "enddo")) {
                    nArray = new int[]{n3, n3 + 5};
                } else if (this.checkCase(baseDocument, n3, "end do")) {
                    nArray = new int[]{n3, n3 + 6};
                }
            }
            catch (BadLocationException badLocationException) {}
        } else if ("f".equals(string) || "F".equals(string)) {
            try {
                int n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                if (this.checkCase(baseDocument, n4, "endif")) {
                    nArray = new int[]{n4, n4 + 5};
                } else if (this.checkCase(baseDocument, n4, "end if")) {
                    nArray = new int[]{n4, n4 + 6};
                }
            }
            catch (BadLocationException badLocationException) {}
        } else if ("m".equals(string) || "M".equals(string)) {
            try {
                int n5 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                if (this.checkCase(baseDocument, n5, "endprogram")) {
                    nArray = new int[]{n5, n5 + 10};
                } else if (this.checkCase(baseDocument, n5, "end program")) {
                    nArray = new int[]{n5, n5 + 11};
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (nArray == null && string != null && string.length() == 1 && Character.isLetter(string.charAt(0))) {
            try {
                int n6 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                if (this.checkCase(baseDocument, n6, string + "\n") || n == baseDocument.getLength() && this.checkCase(baseDocument, n6, string)) {
                    nArray = new int[]{n6, n6 + 1};
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return nArray;
    }

    private boolean checkCase(BaseDocument baseDocument, int n, String string) throws BadLocationException {
        return n >= 0 && n + string.length() <= baseDocument.getLength() && string.equalsIgnoreCase(baseDocument.getText(n, string.length()));
    }

    public class FortranLayer
    extends AbstractFormatLayer {
        public FortranLayer() {
            super("fortran-layer");
        }

        protected FormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new FFormatSupport(formatWriter);
        }

        public void format(FormatWriter formatWriter) {
            block6: {
                try {
                    FFormatSupport fFormatSupport = (FFormatSupport)this.createFormatSupport(formatWriter);
                    FormatTokenPosition formatTokenPosition = fFormatSupport.getFormatStartPosition();
                    if (fFormatSupport.isIndentOnly()) {
                        fFormatSupport.indentLine(formatTokenPosition);
                        break block6;
                    }
                    while (formatTokenPosition != null) {
                        fFormatSupport.indentLine(formatTokenPosition);
                        FormatTokenPosition formatTokenPosition2 = fFormatSupport.findLineEnd(formatTokenPosition);
                        if (formatTokenPosition2 != null && formatTokenPosition2.getToken() != null && (formatTokenPosition = fFormatSupport.getNextPosition(formatTokenPosition2, Position.Bias.Forward)) != formatTokenPosition2 && formatTokenPosition != null && formatTokenPosition.getToken() != null) {
                            FormatTokenPosition formatTokenPosition3 = fFormatSupport.findLineFirstNonWhitespace(formatTokenPosition);
                            if (formatTokenPosition3 != null) {
                                formatTokenPosition = formatTokenPosition3;
                                continue;
                            }
                            formatTokenPosition = fFormatSupport.findLineStart(formatTokenPosition);
                            continue;
                        }
                        break;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }
}

