/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.parser;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.editor.parser.BlockDataNode;
import org.netbeans.modules.cnd.editor.parser.CtagsParser;
import org.netbeans.modules.cnd.editor.parser.CtagsTokenEvent;
import org.netbeans.modules.cnd.editor.parser.CtagsTokenListener;
import org.netbeans.modules.cnd.editor.parser.FuncSubNode;
import org.netbeans.modules.cnd.editor.parser.LabelNode;
import org.netbeans.modules.cnd.editor.parser.ModulesNode;
import org.netbeans.modules.cnd.editor.parser.OtherNode;
import org.netbeans.modules.cnd.editor.parser.ProgramNode;
import org.netbeans.modules.cnd.editor.parser.SourceFileNode;
import org.netbeans.modules.cnd.editor.parser.TypesNode;
import org.netbeans.modules.cnd.editor.parser.VarNode;
import org.netbeans.modules.cnd.editor.parser.ViewNode;
import org.netbeans.modules.cnd.loaders.CppEditorSupport;
import org.netbeans.modules.cnd.loaders.FortranDataObject;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ChoiceView;
import org.openide.explorer.view.NodeListModel;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class NavigationView
extends ChoiceView {
    SelectionManager selManager;
    private DataObject sourceObject = null;
    private CppEditorSupport cppEditorSupport = null;
    ArrayList indexLineNumber = null;
    private Timer checkModifiedTimer = null;
    private long lastModified = 0L;
    private Timer checkCursorTimer = null;
    private int lastCursorPos = -1;
    private int lastCursorPosWhenChecked = 0;
    private static int CLUSTER_FILE = 0;
    private static int CLUSTER_FORTRAN_PROGRAM = 1;
    private static int CLUSTER_FORTRAN_LABEL = 2;
    private static int CLUSTER_FORTRAN_TYPES = 3;
    private static int CLUSTER_FORTRAN_OTHER = 4;
    private static int CLUSTER_FORTRAN_VAR = 5;
    private static int CLUSTER_FORTRAN_FUNCSUB = 6;
    private static int CLUSTER_FORTRAN_MODULES = 7;
    private static int CLUSTER_FORTRAN_BLOCK_DATA = 8;
    ExplorerManager manager;
    TopComponent topComponent = null;
    static ResourceBundle bundle = null;
    private AbstractNode comboboxRootNode = null;
    private Node[] comboboxChildren = null;
    private static boolean isLinuxTestDone = false;
    private static boolean isLinux = false;

    public NavigationView() {
        this.initComponents();
    }

    private void initComponents() {
        ((NodeListModel)this.getModel()).setDepth(8);
        this.selManager = new SelectionManager();
        this.setKeySelectionManager(this.selManager);
        this.getAccessibleContext().setAccessibleDescription(NavigationView.getString("ACSD_NavigationView"));
        this.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        if (CppSettings.getDefault().getParsingDelay() > 0) {
            this.checkModifiedTimer = new Timer(CppSettings.getDefault().getParsingDelay(), new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NavigationView.this.checkModified();
                }
            });
            this.checkCursorTimer = new Timer(250, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NavigationView.this.checkCursor();
                }
            });
        }
        this.setRenderer((ListCellRenderer)((Object)new MyNodeRenderer()));
    }

    private void checkCursor() {
        JEditorPane jEditorPane;
        if (this.sourceObject == null) {
            return;
        }
        if (this.isPopupVisible()) {
            return;
        }
        if (CppSettings.getDefault().getParsingDelay() <= 0) {
            return;
        }
        if (this.checkCursorTimer != null) {
            this.checkCursorTimer.stop();
        }
        if ((jEditorPane = this.findCurrentJEditorPane()) != null) {
            Caret caret = jEditorPane.getCaret();
            if (caret.getDot() != this.lastCursorPos && caret.getDot() == this.lastCursorPosWhenChecked) {
                this.lastCursorPos = caret.getDot();
                this.lastCursorPosWhenChecked = caret.getDot();
                Document document = jEditorPane.getDocument();
                int n = 1;
                try {
                    n = Utilities.getLineOffset((BaseDocument)((BaseDocument)document), (int)caret.getDot()) + 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n2 = 0;
                int n3 = Collections.binarySearch(this.indexLineNumber, new IndexLineNumber(0, n), new IndexLineNumberComparator());
                if (n3 < 0) {
                    n3 = -n3 - 2;
                }
                n2 = ((IndexLineNumber)this.indexLineNumber.get(n3)).getIndex();
                this.setSelectedIndex(n2);
            }
            this.lastCursorPosWhenChecked = caret.getDot();
        }
        if (this.checkCursorTimer != null) {
            this.checkCursorTimer.restart();
        }
    }

    private void checkModified() {
        if (this.sourceObject == null) {
            return;
        }
        if (this.isPopupVisible()) {
            return;
        }
        this.stopTimers();
        JEditorPane jEditorPane = this.findCurrentJEditorPane();
        if (jEditorPane != null) {
            this.updateNodesIfModified(this.getCppEditorSupport(), this.sourceObject, jEditorPane);
        }
        this.restartTimers();
    }

    private void updateNodesIfModified(CppEditorSupport cppEditorSupport, DataObject dataObject, JEditorPane jEditorPane) {
        File file = null;
        if (cppEditorSupport.getLastModified() <= this.lastModified) {
            return;
        }
        long l = System.currentTimeMillis() - cppEditorSupport.getLastModified();
        if (l < (long)CppSettings.getDefault().getParsingDelay()) {
            return;
        }
        this.lastModified = cppEditorSupport.getLastModified();
        this.lastCursorPos = -1;
        this.lastCursorPosWhenChecked = 0;
        try {
            file = File.createTempFile(dataObject.getPrimaryFile().getName() + "__", "." + dataObject.getPrimaryFile().getExt());
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            printWriter.print(jEditorPane.getText());
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().annotate((Throwable)exception, "Problems creating tmp file for " + dataObject.getPrimaryFile().getPath());
            ErrorManager.getDefault().notify((Throwable)exception);
            file.delete();
            return;
        }
        this.updateChildren(file.getPath());
        file.delete();
    }

    public void addNotify() {
        super.addNotify();
        this.topComponent = this.findParentTopComponent();
        this.setRoot(this.getActivatedNode());
        this.restartTimers();
    }

    public void removeNotify() {
        this.stopTimers();
        super.removeNotify();
    }

    private void restartTimers() {
        if (this.checkModifiedTimer != null) {
            this.checkModifiedTimer.restart();
        }
        if (this.checkCursorTimer != null) {
            this.checkCursorTimer.restart();
        }
    }

    private void stopTimers() {
        if (this.checkModifiedTimer != null) {
            this.checkModifiedTimer.stop();
        }
        if (this.checkCursorTimer != null) {
            this.checkCursorTimer.stop();
        }
    }

    private ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = ExplorerManager.find((Component)((Object)this));
        }
        return this.manager;
    }

    private TopComponent findParentTopComponent() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof TopComponent); container = container.getParent()) {
        }
        return (TopComponent)container;
    }

    public void setPopupVisible(boolean bl) {
        boolean bl2 = this.isPopupVisible() && this.isVisible();
        super.setPopupVisible(bl);
        if (!bl && bl2) {
            this.choiceItemSelected(this.getExplorerManager().getSelectedNodes());
        }
    }

    private Node getActivatedNode() {
        Node[] nodeArray = this.topComponent == null ? TopComponent.getRegistry().getActivatedNodes() : this.topComponent.getActivatedNodes();
        if (nodeArray == null || nodeArray.length == 0) {
            return null;
        }
        return nodeArray[0];
    }

    private void setRoot(Node node) {
        if (node == null) {
            return;
        }
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return;
        }
        if (!(dataObject instanceof FortranDataObject)) {
            return;
        }
        if (this.sourceObject == null || this.sourceObject != dataObject) {
            this.sourceObject = dataObject;
            this.cppEditorSupport = null;
            File file = FileUtil.toFile((FileObject)this.sourceObject.getPrimaryFile());
            if (file != null) {
                this.updateChildren(file.getPath());
            } else {
                this.sourceObject = null;
            }
        }
    }

    private void updateChildren(String string) {
        this.removeComboboxChildren();
        MyCtagsTokenListener myCtagsTokenListener = new MyCtagsTokenListener();
        if (CppSettings.getDefault().getParsingDelay() > 0) {
            CtagsParser ctagsParser = new CtagsParser(string);
            ctagsParser.setCtagsTokenListener(myCtagsTokenListener);
            try {
                ctagsParser.parse();
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        this.addComboboxChildren((Node[])myCtagsTokenListener.getNodes());
        this.indexLineNumber = myCtagsTokenListener.getIndexLineNumbers();
    }

    private void choiceItemSelected(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            nodeArray = this.getExplorerManager().getSelectedNodes();
        }
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        Node node = nodeArray[0];
        if (node instanceof ViewNode) {
            ViewNode viewNode = (ViewNode)node;
            JEditorPane jEditorPane = this.findCurrentJEditorPane();
            if (jEditorPane != null) {
                viewNode.goToOffset(jEditorPane);
            }
        }
    }

    private JEditorPane findCurrentJEditorPane() {
        JEditorPane jEditorPane = null;
        JEditorPane[] jEditorPaneArray = this.getCppEditorSupport().getOpenedPanes();
        if (jEditorPaneArray == null) {
            return null;
        }
        if (jEditorPaneArray.length == 1) {
            jEditorPane = jEditorPaneArray[0];
        } else if (jEditorPaneArray != null && this.topComponent != null) {
            for (int i = 0; i < jEditorPaneArray.length; ++i) {
                if (!this.topComponent.isAncestorOf((Component)jEditorPaneArray[i])) continue;
                jEditorPane = jEditorPaneArray[i];
                break;
            }
        }
        return jEditorPane;
    }

    private CppEditorSupport getCppEditorSupport() {
        if (this.cppEditorSupport == null) {
            this.cppEditorSupport = (CppEditorSupport)this.sourceObject.getCookie(CppEditorSupport.class);
        }
        return this.cppEditorSupport;
    }

    private AbstractNode newRootNode() {
        AbstractNode abstractNode = new AbstractNode((Children)new Children.Array());
        abstractNode.setIconBaseWithExtension("org/netbeans/modules/java/resources/class.gif");
        abstractNode.setDisplayName(NavigationView.getString("NAME_NothingSelected"));
        return abstractNode;
    }

    private AbstractNode getComboboxRootNode() {
        if (this.comboboxRootNode == null) {
            this.comboboxRootNode = this.newRootNode();
            this.getExplorerManager().setRootContext((Node)this.comboboxRootNode);
            this.comboboxChildren = null;
        }
        return this.comboboxRootNode;
    }

    private Node[] getComboboxChildren() {
        if (this.comboboxChildren == null) {
            this.comboboxChildren = this.getComboboxRootNode().getChildren().getNodes();
        }
        return this.comboboxChildren;
    }

    private void removeComboboxChildren() {
        this.getComboboxRootNode().getChildren().remove(this.getComboboxRootNode().getChildren().getNodes());
        this.comboboxChildren = null;
    }

    private void addComboboxChildren(Node[] nodeArray) {
        this.getComboboxRootNode().getChildren().add(nodeArray);
        this.comboboxChildren = nodeArray;
    }

    private static boolean isLinux() {
        if (!isLinuxTestDone) {
            isLinux = System.getProperty("os.name", "").toLowerCase().indexOf("linux") >= 0;
            isLinuxTestDone = true;
        }
        return isLinux;
    }

    static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(NavigationView.class);
        }
        return bundle.getString(string);
    }

    private class SelectionManager
    extends KeyAdapter
    implements JComboBox.KeySelectionManager {
        private SelectionManager() {
        }

        public int selectionForKey(char c, ComboBoxModel comboBoxModel) {
            Node[] nodeArray = NavigationView.this.getComboboxChildren();
            boolean bl = false;
            int n = 0;
            if (NavigationView.this.getSelectedIndex() >= 0) {
                n = NavigationView.this.getSelectedIndex() + 1;
                if (n >= nodeArray.length) {
                    n = 1;
                }
            } else {
                n = 1;
            }
            int n2 = n;
            while (!bl && n < nodeArray.length) {
                ViewNode viewNode = (ViewNode)nodeArray[n];
                if (c == viewNode.getName().charAt(0) || c == viewNode.getDisplayName().charAt(0)) {
                    bl = true;
                    break;
                }
                if (++n == n2) {
                    bl = false;
                    break;
                }
                if (n != nodeArray.length) continue;
                n = 1;
            }
            if (!bl) {
                n = -1;
            }
            return n;
        }
    }

    class MyCtagsTokenListener
    implements CtagsTokenListener {
        private ArrayList nodes = null;
        private ArrayList lineNumberIndex = null;
        private Vector scopeList = new Vector(0);

        MyCtagsTokenListener() {
            this.nodes = new ArrayList(5);
            this.nodes.add(new SourceFileNode(NavigationView.this.sourceObject, NavigationView.getString("NAME_StartOfFile"), 1, ' ', null, 0, CLUSTER_FILE));
        }

        private int findFortranScopeCluster(String string, int n) {
            int n2 = 0;
            if (string != null) {
                if (n == 4) {
                    n2 = CLUSTER_FORTRAN_MODULES;
                } else if (n == 5) {
                    n2 = CLUSTER_FORTRAN_TYPES;
                } else if (n == 6) {
                    n2 = CLUSTER_FORTRAN_FUNCSUB;
                } else if (n == 7) {
                    n2 = CLUSTER_FORTRAN_BLOCK_DATA;
                } else {
                    System.err.println("Illegal scopeKind " + n);
                }
            }
            return n2;
        }

        private boolean checkInScopeList(String string) {
            if (string != null) {
                Enumeration enumeration = this.scopeList.elements();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (!string2.equals(string)) continue;
                    return true;
                }
            }
            return false;
        }

        public void gotToken(CtagsTokenEvent ctagsTokenEvent) {
            String string = ctagsTokenEvent.getToken();
            int n = ctagsTokenEvent.getLineNo();
            char c = ctagsTokenEvent.getKind();
            String string2 = ctagsTokenEvent.getScope();
            int n2 = ctagsTokenEvent.getScopeKind();
            if (NavigationView.this.sourceObject instanceof FortranDataObject) {
                ViewNode viewNode;
                int n3 = this.findFortranScopeCluster(string2, n2);
                switch (ctagsTokenEvent.getKind()) {
                    case 'l': {
                        viewNode = new LabelNode(NavigationView.this.sourceObject, string, n, c, string2, n3, CLUSTER_FORTRAN_LABEL);
                        break;
                    }
                    case 'f': 
                    case 's': {
                        viewNode = new FuncSubNode(NavigationView.this.sourceObject, string, n, c, string2, n3, CLUSTER_FORTRAN_FUNCSUB);
                        break;
                    }
                    case 'L': 
                    case 'v': {
                        viewNode = new VarNode(NavigationView.this.sourceObject, string, n, c, string2, n3, CLUSTER_FORTRAN_VAR);
                        break;
                    }
                    case 'm': {
                        viewNode = new ModulesNode(NavigationView.this.sourceObject, string, n, c, string2, n3, CLUSTER_FORTRAN_MODULES);
                        break;
                    }
                    case 't': {
                        viewNode = new TypesNode(NavigationView.this.sourceObject, string, n, c, string2, n3, CLUSTER_FORTRAN_TYPES);
                        break;
                    }
                    case 'p': {
                        viewNode = new ProgramNode(NavigationView.this.sourceObject, string, n, c, string2, n3, CLUSTER_FORTRAN_PROGRAM);
                        break;
                    }
                    case 'b': {
                        viewNode = new BlockDataNode(NavigationView.this.sourceObject, string, n, c, string2, n3, CLUSTER_FORTRAN_BLOCK_DATA);
                        break;
                    }
                    default: {
                        viewNode = new OtherNode(NavigationView.this.sourceObject, string, n, c, string2, n3, CLUSTER_FORTRAN_OTHER);
                    }
                }
                this.nodes.add(viewNode);
            }
        }

        ViewNode[] getNodes() {
            Collections.sort(this.nodes, new NodesComparator());
            return this.nodes.toArray(new ViewNode[this.nodes.size()]);
        }

        private ArrayList getIndexLineNumbers() {
            this.lineNumberIndex = new ArrayList(5);
            for (int i = 0; i < this.nodes.size(); ++i) {
                this.lineNumberIndex.add(new IndexLineNumber(i, ((ViewNode)((Object)this.nodes.get(i))).getLineNo()));
            }
            Collections.sort(this.lineNumberIndex, new IndexLineNumberComparator());
            return this.lineNumberIndex;
        }
    }

    class NodesComparator
    implements Comparator {
        NodesComparator() {
        }

        public int compare(Object object, Object object2) {
            ViewNode viewNode = (ViewNode)((Object)object);
            ViewNode viewNode2 = (ViewNode)((Object)object2);
            return viewNode.getSortName().compareTo(viewNode2.getSortName());
        }
    }

    class IndexLineNumberComparator
    implements Comparator {
        IndexLineNumberComparator() {
        }

        public int compare(Object object, Object object2) {
            IndexLineNumber indexLineNumber = (IndexLineNumber)object;
            IndexLineNumber indexLineNumber2 = (IndexLineNumber)object2;
            if (indexLineNumber.getLineNumber() < indexLineNumber2.getLineNumber()) {
                return -1;
            }
            if (indexLineNumber.getLineNumber() > indexLineNumber2.getLineNumber()) {
                return 1;
            }
            return 0;
        }
    }

    class IndexLineNumber {
        private int index;
        private int lineNumber;

        public IndexLineNumber(int n, int n2) {
            this.index = n;
            this.lineNumber = n2;
        }

        public int getIndex() {
            return this.index;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }

    class MyNodeRenderer
    extends NodeRenderer {
        Border focusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        Border emptyBorder = new EmptyBorder(1, 1, 1, 1);

        MyNodeRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (n < 0) {
                return jLabel;
            }
            Border border = bl2 ? this.focusBorder : this.emptyBorder;
            ViewNode viewNode = (ViewNode)Visualizer.findNode((Object)NavigationView.this.getItemAt(n));
            if (viewNode.getScopeLevel() > 0) {
                border = new CompoundBorder(new EmptyBorder(0, jLabel.getIcon().getIconWidth() * viewNode.getScopeLevel(), 0, 0), border);
            }
            jLabel.setBorder(border);
            return jLabel;
        }
    }
}

