/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.loaders;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.Format;
import java.util.Collection;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.editor.filecreation.CndHandlableExtensions;
import org.netbeans.modules.cnd.loaders.CndAbstractDataLoader;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CndAbstractDataLoaderExt
extends CndAbstractDataLoader {
    protected CndAbstractDataLoaderExt(String string) {
        super(string);
    }

    @Override
    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new CndFormatExt(multiDataObject, fileObject);
    }

    public void addExtensions(Collection<String> collection) {
        ExtensionList extensionList = this.getExtensions();
        ExtensionList extensionList2 = (ExtensionList)extensionList.clone();
        for (String string : collection) {
            extensionList2.addExtension(string);
        }
        this.setExtensions(extensionList2);
    }

    private static class CndFormatExt
    extends CndAbstractDataLoader.CndFormat {
        public CndFormatExt(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
            String string2;
            Collection collection = Lookup.getDefault().lookupAll(CndHandlableExtensions.class);
            if (collection.contains(this.getDataObject().getLoader())) {
                string2 = FileUtil.getExtension((String)string);
                if (string2.length() != 0) {
                    string = string.substring(0, string.length() - string2.length() - 1);
                }
            } else {
                string2 = this.getFile().getExt();
            }
            FileObject fileObject2 = fileObject.createData(string, string2);
            Format format = this.createFormat(fileObject, string, string2);
            EditorKit editorKit = this.createEditorKit(this.getFile().getMIMEType());
            Document document = editorKit.createDefaultDocument();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getFile().getInputStream()));
            try {
                FileLock fileLock = fileObject2.lock();
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject2.getOutputStream(fileLock)));
                    try {
                        String string3;
                        String string4 = null;
                        int n = 0;
                        while ((string3 = bufferedReader.readLine()) != null) {
                            if (string4 != null) {
                                document.insertString(n, "\n", null);
                                ++n;
                            }
                            string4 = format.format(string3);
                            document.insertString(n, string4, null);
                            n += string4.length();
                        }
                        document.insertString(document.getLength(), "\n", null);
                        ++n;
                        if (document instanceof BaseDocument) {
                            BaseDocument baseDocument = (BaseDocument)document;
                            baseDocument.getFormatter().reformatLock();
                            try {
                                baseDocument.getFormatter().reformat(baseDocument, 0, n);
                            }
                            finally {
                                baseDocument.getFormatter().reformatUnlock();
                            }
                        }
                        bufferedWriter.write(document.getText(0, document.getLength()));
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                    finally {
                        bufferedWriter.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
            finally {
                bufferedReader.close();
            }
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fileObject2);
            CndFormatExt.setTemplate(fileObject2, false);
            return fileObject2;
        }

        private static boolean setTemplate(FileObject fileObject, boolean bl) throws IOException {
            boolean bl2 = false;
            Object object = fileObject.getAttribute("template");
            if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                bl2 = true;
            }
            if (bl2 == bl) {
                return false;
            }
            fileObject.setAttribute("template", (Object)(bl ? Boolean.TRUE : null));
            return true;
        }

        private EditorKit createEditorKit(String string) {
            EditorKit editorKit = JEditorPane.createEditorKitForContentType(string);
            if (editorKit == null) {
                editorKit = new DefaultEditorKit();
            }
            return editorKit;
        }
    }
}

