/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.loaders;

import org.netbeans.modules.cnd.editor.filecreation.ExtensionsSettings;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.MIMEResolver;

public class CndMIMEResolver
extends MIMEResolver {
    public CndMIMEResolver() {
        super(new String[]{"text/x-c", "text/x-c++", "text/x-make", "text/sh", "text/x-fortran", "text/x-asm"});
    }

    public static boolean isHeaderExtension(String string) {
        return ExtensionsSettings.isRegistered(string, "CndHeader");
    }

    public static boolean isMimeTypeExtension(String string, String string2) {
        if ("text/x-c".equals(string)) {
            return ExtensionsSettings.isRegistered(string2, "CndCFile");
        }
        if ("text/x-c++".equals(string)) {
            return ExtensionsSettings.isRegistered(string2, "CndCppFile");
        }
        return false;
    }

    public String findMIMEType(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return null;
        }
        String string = fileObject.getExt();
        if (ExtensionsSettings.isRegistered(string, "CndCFile")) {
            return "text/x-c";
        }
        if (ExtensionsSettings.isRegistered(string, "CndCppFile")) {
            return "text/x-c++";
        }
        if (ExtensionsSettings.isRegistered(string, "CndHeader")) {
            return "text/x-c++";
        }
        if (ExtensionsSettings.isRegistered(string, "CndMakefile")) {
            return "text/x-make";
        }
        if (ExtensionsSettings.isRegistered(string, "CndShellFile")) {
            return "text/sh";
        }
        if (ExtensionsSettings.isRegistered(string, "CndFortranFile")) {
            return "text/x-fortran";
        }
        if (ExtensionsSettings.isRegistered(string, "CndAsmFile")) {
            return "text/x-asm";
        }
        if (string.length() == 0) {
            String string2 = fileObject.getName().toLowerCase();
            if (string2.startsWith("makefile") || string2.endsWith("makefile") || string2.startsWith("gnumakefile")) {
                return "text/x-make";
            }
            string2 = fileObject.getName();
            if (string2.indexOf(".") < 0 && string2.indexOf("Makefile") >= 0) {
                return "text/x-make";
            }
        }
        return null;
    }
}

