/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;

public class LinkReader {
    private RandomAccessFile reader;
    private String sourcePath;
    private String path;
    private boolean isLSB = true;
    private boolean isShellItemPresent;
    private boolean isFileLocationItemPresent;
    private boolean isDescriptionPresent;
    private boolean isRelativePathPresent;

    public LinkReader(String string) throws FileNotFoundException, WrongFileFormatException {
        this.reader = new RandomAccessFile(string, "r");
        this.path = string;
        this.readMagic();
    }

    public String getSource() {
        return this.sourcePath;
    }

    private void readMagic() throws WrongFileFormatException {
        block14: {
            byte[] byArray = new byte[4];
            try {
                this.reader.readFully(byArray);
                if (this.isLinkMagic(byArray)) {
                    int n;
                    this.reader.seek(20L);
                    this.reader.readFully(byArray);
                    this.readFlags(byArray);
                    int n2 = 76;
                    this.reader.seek(n2);
                    if (this.isShellItemPresent) {
                        n = (int)this.readNumber(2);
                        this.reader.seek(n2 += n);
                    }
                    n = (int)this.readNumber(2);
                    this.reader.seek(n2 += n + 2);
                    if (this.isShellItemPresent) {
                        // empty if block
                    }
                    if (this.isDescriptionPresent) {
                        n = (int)this.readNumber(2);
                        this.reader.seek(n2 += n + 2);
                    }
                    if (this.isRelativePathPresent) {
                        n = (int)this.readNumber(2);
                        this.sourcePath = this.getString(n);
                        if (this.sourcePath.length() > 1 && this.sourcePath.charAt(1) != ':') {
                            int n3 = this.path.lastIndexOf(92);
                            if (n3 < 0) {
                                n3 = this.path.lastIndexOf(47);
                            }
                            if (n3 > 0) {
                                this.sourcePath = this.path.substring(0, n3 + 1) + this.sourcePath;
                            }
                        }
                        return;
                    }
                    break block14;
                }
                throw new WrongFileFormatException();
            }
            catch (IOException iOException) {
                throw new WrongFileFormatException("Not an link file");
            }
            finally {
                this.dispose();
            }
        }
    }

    public void dispose() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.reader = null;
        }
    }

    private boolean isLinkMagic(byte[] byArray) {
        return byArray[0] == 76 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0;
    }

    private void readFlags(byte[] byArray) {
        byte by = byArray[0];
        if ((by & 1) != 0) {
            this.isShellItemPresent = true;
        }
        if ((by & 2) != 0) {
            this.isFileLocationItemPresent = true;
        }
        if ((by & 4) != 0) {
            this.isDescriptionPresent = true;
        }
        if ((by & 8) != 0) {
            this.isRelativePathPresent = true;
        }
    }

    private long readNumber(int n) throws IOException {
        byte[] byArray = new byte[n];
        long l = 0L;
        this.reader.readFully(byArray);
        for (int i = 0; i < n; ++i) {
            long l2 = 0L;
            l2 = this.isLSB ? (long)(0xFF & byArray[i]) : (long)(0xFF & byArray[n - i - 1]);
            l |= l2 << i * 8;
        }
        return l;
    }

    private String getString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.reader.readFully(byArray);
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n && byArray[i] != 0; ++i) {
            stringBuilder.append((char)byArray[i]);
        }
        return stringBuilder.toString();
    }
}

