/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.xml.cookies;

import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.netbeans.api.xml.parsers.DocumentInputSource;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.spi.xml.cookies.Util;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public final class DataObjectAdapters {
    private static final String SAX_FEATURES_NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static SAXParserFactory saxParserFactory;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    private DataObjectAdapters() {
    }

    public static InputSource inputSource(DataObject dataObject) {
        if (dataObject == null) {
            throw new NullPointerException();
        }
        return new DataObjectInputSource(dataObject);
    }

    public static Source source(DataObject dataObject) {
        if (dataObject == null) {
            throw new NullPointerException();
        }
        return new DataObjectSAXSource(dataObject);
    }

    private static String getSystemId(DataObject dataObject) {
        String string;
        block4: {
            string = null;
            try {
                FileObject fileObject = dataObject.getPrimaryFile();
                URL uRL = fileObject.getURL();
                try {
                    string = new URI(uRL.toString()).toASCIIString();
                }
                catch (URISyntaxException uRISyntaxException) {
                    string = uRL.toExternalForm();
                    Util.THIS.debug(uRISyntaxException);
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                if (!Util.THIS.isLoggable()) break block4;
                Util.THIS.debug(fileStateInvalidException);
            }
        }
        return string;
    }

    private static synchronized SAXParserFactory getSAXParserFactory() throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (saxParserFactory == null) {
            saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setFeature(SAX_FEATURES_NAMESPACES, true);
        }
        return saxParserFactory;
    }

    private static XMLReader newXMLReader() throws ParserConfigurationException, SAXException {
        SAXParser sAXParser = DataObjectAdapters.getSAXParserFactory().newSAXParser();
        return sAXParser.getXMLReader();
    }

    private static EntityResolver getEntityResolver() {
        UserCatalog userCatalog = UserCatalog.getDefault();
        EntityResolver entityResolver = userCatalog == null ? null : userCatalog.getEntityResolver();
        return entityResolver;
    }

    private static class DataObjectSAXSource
    extends SAXSource {
        private final DataObject dataObject;

        public DataObjectSAXSource(DataObject dataObject) {
            this.dataObject = dataObject;
        }

        public String getSystemId() {
            return DataObjectAdapters.getSystemId(this.dataObject);
        }

        public XMLReader getXMLReader() {
            try {
                XMLReader xMLReader = DataObjectAdapters.newXMLReader();
                xMLReader.setEntityResolver(DataObjectAdapters.getEntityResolver());
                return xMLReader;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Util.THIS.debug(parserConfigurationException);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                Util.THIS.debug(sAXNotRecognizedException);
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                Util.THIS.debug(sAXNotSupportedException);
            }
            catch (SAXException sAXException) {
                Util.THIS.debug(sAXException);
            }
            return null;
        }

        public InputSource getInputSource() {
            return DataObjectAdapters.inputSource(this.dataObject);
        }
    }

    private static class DataObjectInputSource
    extends InputSource {
        private final DataObject dataObject;

        public DataObjectInputSource(DataObject dataObject) {
            this.dataObject = dataObject;
        }

        public String getSystemId() {
            return DataObjectAdapters.getSystemId(this.dataObject);
        }

        public Reader getCharacterStream() {
            StyledDocument styledDocument;
            EditorCookie editorCookie = (EditorCookie)this.dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = DataObjectAdapters.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
            if (editorCookie != null && (styledDocument = editorCookie.getDocument()) != null) {
                return new DocumentInputSource(styledDocument).getCharacterStream();
            }
            return null;
        }
    }
}

