/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.netbeans.modules.bpel.core.helper.api.BusinessProcessHelper;
import org.netbeans.modules.bpel.design.CopyPasteHandler;
import org.netbeans.modules.bpel.design.DiagramFontUtil;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.DnDHandler;
import org.netbeans.modules.bpel.design.ErrorPanel;
import org.netbeans.modules.bpel.design.NavigationTools;
import org.netbeans.modules.bpel.design.OverlayPanel;
import org.netbeans.modules.bpel.design.PartnerlinksView;
import org.netbeans.modules.bpel.design.ProcessView;
import org.netbeans.modules.bpel.design.RightStripe;
import org.netbeans.modules.bpel.design.SelectionBridge;
import org.netbeans.modules.bpel.design.TriScrollPane;
import org.netbeans.modules.bpel.design.ZoomManager;
import org.netbeans.modules.bpel.design.actions.CancelAction;
import org.netbeans.modules.bpel.design.actions.CollapseCurrentPatternAction;
import org.netbeans.modules.bpel.design.actions.DeleteAction;
import org.netbeans.modules.bpel.design.actions.ExpandAllPatternsAction;
import org.netbeans.modules.bpel.design.actions.ExpandCurrentPatternAction;
import org.netbeans.modules.bpel.design.actions.FindUsagesAction;
import org.netbeans.modules.bpel.design.actions.GoToLoggingAction;
import org.netbeans.modules.bpel.design.actions.GoToMapperAction;
import org.netbeans.modules.bpel.design.actions.GoToSourceAction;
import org.netbeans.modules.bpel.design.actions.RenameAction;
import org.netbeans.modules.bpel.design.actions.ScrollToOperationAction;
import org.netbeans.modules.bpel.design.actions.ShowContextMenuAction;
import org.netbeans.modules.bpel.design.actions.TabToNextComponentAction;
import org.netbeans.modules.bpel.design.decoration.Decoration;
import org.netbeans.modules.bpel.design.decoration.DecorationManager;
import org.netbeans.modules.bpel.design.decoration.DecorationProviderFactory;
import org.netbeans.modules.bpel.design.decoration.components.DiagramButton;
import org.netbeans.modules.bpel.design.decoration.components.GlassPane;
import org.netbeans.modules.bpel.design.decoration.providers.CollapseExpandDecorationProvider;
import org.netbeans.modules.bpel.design.decoration.providers.DebuggerDecorationProvider;
import org.netbeans.modules.bpel.design.decoration.providers.LinkToolDecorationProvider;
import org.netbeans.modules.bpel.design.decoration.providers.SelectionDecorationProvider;
import org.netbeans.modules.bpel.design.decoration.providers.ToolbarDecorationProvider;
import org.netbeans.modules.bpel.design.decoration.providers.ValidationDecorationProvider;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.geometry.FDimension;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.layout.LayoutManager;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.PartnerRole;
import org.netbeans.modules.bpel.design.model.connections.ConnectionManager;
import org.netbeans.modules.bpel.design.model.connections.MessageConnection;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.model.patterns.ProcessPattern;
import org.netbeans.modules.bpel.design.model.patterns.SequencePattern;
import org.netbeans.modules.bpel.design.selection.EntitySelectionModel;
import org.netbeans.modules.bpel.design.selection.FlowlinkTool;
import org.netbeans.modules.bpel.editors.api.EditorUtil;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.editors.multiview.DesignerMultiViewElement;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.nodes.actions.GoToAction;
import org.netbeans.modules.bpel.nodes.actions.ShowBpelMapperAction;
import org.netbeans.modules.bpel.properties.NodeUtils;
import org.netbeans.modules.bpel.properties.PropertyNodeFactory;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.soa.ui.nodes.NodeFactory;
import org.netbeans.modules.soa.validation.core.Controller;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class DesignView
extends JPanel
implements HelpCtx.Provider {
    public static double CORNER45 = 0.7853981633974483;
    private static final long serialVersionUID = 1L;
    private double zoom = 1.0;
    private Lookup lookup;
    private DiagramModel diagramModel;
    private EntitySelectionModel selectionModel;
    private LayoutManager layoutManager;
    private ConnectionManager connectionManager;
    private DnDHandler dndHandler;
    private CopyPasteHandler copyPasteHandler;
    private FlowlinkTool flowLinkTool;
    private ErrorPanel errorPanel;
    private ZoomManager zoomManager;
    private DecorationManager decorationManager;
    private SelectionDecorationProvider selectionDecorationProvider;
    private ValidationDecorationProvider validationDecorationProvider;
    private DebuggerDecorationProvider debuggerDecorationProvider;
    private ToolbarDecorationProvider toolbarDecorationProvider;
    private LinkToolDecorationProvider linkToolDecorationProvider;
    private CollapseExpandDecorationProvider collapseExpandDectorationProvider;
    private SelectionBridge selectionBridge;
    private NavigationTools navigationTools;
    private RightStripe rightStripe;
    private PartnerlinksView consumersView;
    private PartnerlinksView providersView;
    private ProcessView processView;
    private OverlayPanel overlayView;
    private TriScrollPane scrollPane;
    private boolean printMode = false;
    private static final Logger TIMERS = Logger.getLogger("TIMER.bpel");

    public DesignView(Lookup lookup) {
        if (TIMERS.isLoggable(Level.FINE)) {
            LogRecord logRecord = new LogRecord(Level.FINE, "BPEL DesignView");
            logRecord.setParameters(new Object[]{this});
            TIMERS.log(logRecord);
        }
        this.zoomManager = new ZoomManager(this);
        this.rightStripe = new RightStripe(this);
        this.setBackground(new Color(16579317));
        this.lookup = lookup;
        this.diagramModel = new DiagramModel(this);
        this.selectionModel = new EntitySelectionModel(this.diagramModel);
        this.overlayView = new OverlayPanel(this);
        this.consumersView = new PartnerlinksView(this, PartnerRole.CONSUMER);
        this.consumersView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DesignView.class, (String)"ACSN_ConsumersPLPanel"));
        this.consumersView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DesignView.class, (String)"ACSD_ConsumersPLPanel"));
        this.providersView = new PartnerlinksView(this, PartnerRole.PROVIDER);
        this.providersView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DesignView.class, (String)"ACSN_ProvidersPLPanel"));
        this.providersView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DesignView.class, (String)"ACSD_ProvidersPLPanel"));
        this.processView = new ProcessView(this);
        this.processView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DesignView.class, (String)"ACSN_ProcessPanel"));
        this.processView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DesignView.class, (String)"ACSD_ProcessPanel"));
        this.navigationTools = new NavigationTools(this);
        this.scrollPane = new TriScrollPane(this.processView, this.consumersView, this.providersView, this.navigationTools, this.overlayView);
        this.add((java.awt.Component)this.scrollPane, 0);
        this.dndHandler = new DnDHandler(this);
        this.flowLinkTool = new FlowlinkTool(this);
        this.copyPasteHandler = new CopyPasteHandler(this);
        this.layoutManager = new LayoutManager();
        this.connectionManager = new ConnectionManager();
        this.selectionBridge = new SelectionBridge(this);
        this.setFocusable(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.registerActions();
        this.errorPanel = new ErrorPanel(this);
        this.decorationManager = new DecorationManager(this);
        this.loadDecorationProviders();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalKeysEnabled(false);
        this.scrollPane.addScrollListener(new TriScrollPane.ScrollListener(){

            public void viewScrolled(JComponent jComponent) {
                DesignView.this.overlayView.revalidate();
                DesignView.this.overlayView.repaint();
            }
        });
        this.reloadModel();
        this.diagramChanged();
    }

    public AccessibleContext getAccessibleContext() {
        EntitySelectionModel entitySelectionModel = this.getSelectionModel();
        Pattern pattern = null;
        if (entitySelectionModel != null) {
            pattern = entitySelectionModel.getSelectedPattern();
        }
        DiagramView diagramView = null;
        if (pattern != null) {
            diagramView = pattern.getView();
        }
        return diagramView != null ? diagramView.getAccessibleContext() : super.getAccessibleContext();
    }

    public DiagramView getConsumersView() {
        return this.consumersView;
    }

    public Object getMouseHandler() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public DiagramView getProcessView() {
        return this.processView;
    }

    public DiagramView getProvidersView() {
        return this.providersView;
    }

    public OverlayPanel getOverlayView() {
        return this.overlayView;
    }

    public NavigationTools getNavigationTools() {
        return this.navigationTools;
    }

    public CopyPasteHandler getCopyPasteHandler() {
        return this.copyPasteHandler;
    }

    public RightStripe getRightStripe() {
        return this.rightStripe;
    }

    public boolean getPrintMode() {
        return this.printMode;
    }

    public void setPrintMode(boolean bl) {
        this.printMode = bl;
    }

    public TriScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void doLayout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (java.awt.Component component : this.getComponents()) {
            component.setBounds(0, 0, n, n2);
        }
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public void reloadModel() {
        if (this.getBPELModel().getState().equals((Object)Model.State.VALID)) {
            BpelEntity bpelEntity = this.selectionModel.getSelected();
            Process process = this.getProcessModel();
            try {
                this.diagramModel.setRootPattern(process != null ? this.diagramModel.createPattern((BpelEntity)process) : null);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(4096, (Throwable)exception);
            }
            this.selectionModel.setSelected(bpelEntity);
        } else {
            this.diagramModel.setRootPattern(null);
            this.selectionModel.clear();
        }
    }

    public void closeView() {
        if (this.diagramModel != null) {
            this.diagramModel.release();
            this.diagramModel = null;
        }
        this.getDecorationManager().release();
        this.selectionBridge.release();
    }

    public Controller getValidationController() {
        return (Controller)this.getLookup().lookup(Controller.class);
    }

    public EntitySelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public FlowlinkTool getFlowLinkTool() {
        return this.flowLinkTool;
    }

    public DecorationManager getDecorationManager() {
        return this.decorationManager;
    }

    public ZoomManager getZoomManager() {
        return this.zoomManager;
    }

    public BpelModel getBPELModel() {
        return (BpelModel)this.getLookup().lookup(BpelModel.class);
    }

    public Process getProcessModel() {
        try {
            BpelModel bpelModel = this.getBPELModel();
            return bpelModel.getProcess();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(4096, (Throwable)exception);
            return null;
        }
    }

    public NodeFactory getNodeFactory() {
        return PropertyNodeFactory.getInstance();
    }

    public BusinessProcessHelper getProcessHelper() {
        return (BusinessProcessHelper)this.lookup.lookup(BusinessProcessHelper.class);
    }

    public Node getNodeForPattern(Pattern pattern) {
        if (pattern == null) {
            return null;
        }
        NodeType nodeType = EditorUtil.getBasicNodeType((Component)pattern.getOMReference());
        NodeFactory nodeFactory = this.getNodeFactory();
        if (nodeFactory != null) {
            return nodeFactory.createNode((Object)nodeType, (Object)pattern.getOMReference(), this.getLookup());
        }
        return null;
    }

    public DiagramView getView(Point point) {
        return (DiagramView)this.scrollPane.getComponent(point);
    }

    public Pattern findPattern(Point point) {
        DiagramView diagramView = this.getView(point);
        if (diagramView != null) {
            FPoint fPoint = diagramView.convertPointFromParent(point);
            return diagramView.findPattern(fPoint.x, fPoint.y);
        }
        return null;
    }

    public void performDefaultAction(Pattern pattern) {
        Node node = this.getNodeForPattern(pattern);
        if (node == null) {
            return;
        }
        Action action = node.getPreferredAction();
        if (action != null) {
            action.actionPerformed(new ActionEvent(this, 0, "DBC"));
        }
    }

    public boolean showCustomEditor(Pattern pattern, CustomNodeEditor.EditingMode editingMode) {
        Node node = this.getNodeForPattern(pattern);
        if (node == null) {
            return false;
        }
        if (this.getModel().isReadOnly()) {
            return false;
        }
        return NodeUtils.showNodeCustomEditor(node, editingMode);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private void registerActions() {
        InputMap inputMap = this.getInputMap(0);
        InputMap inputMap2 = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(113, 0), "rename-something");
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "delete-something");
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel-something");
        inputMap2.put(KeyStroke.getKeyStroke(83, 576), "scroll-to-operation");
        KeyStroke keyStroke = GoToAction.getKeyStroke(org.netbeans.modules.bpel.nodes.actions.GoToSourceAction.class);
        KeyStroke keyStroke2 = GoToAction.getKeyStroke(ShowBpelMapperAction.class);
        KeyStroke keyStroke3 = GoToAction.getKeyStroke(org.netbeans.modules.bpel.nodes.actions.GoToLoggingAction.class);
        if (keyStroke != null) {
            inputMap.put(keyStroke, "gotosource-something");
            inputMap2.put(keyStroke, "gotosource-something");
        }
        if (keyStroke2 != null) {
            inputMap.put(keyStroke2, "gotomapper-something");
            inputMap2.put(keyStroke2, "gotomapper-something");
        }
        if (keyStroke3 != null) {
            inputMap.put(keyStroke3, "gotologging-something");
            inputMap2.put(keyStroke3, "gotologging-something");
        }
        inputMap.put(KeyStroke.getKeyStroke(77, 128), "find_next_mex_peer");
        inputMap.put(KeyStroke.getKeyStroke(525, 0), "show_context_menu");
        inputMap.put(KeyStroke.getKeyStroke(121, 64), "show_context_menu");
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "go_next_hierarchy_component");
        inputMap.put(KeyStroke.getKeyStroke(9, 64), "go_previous_hierarchy_component");
        inputMap.put(KeyStroke.getKeyStroke(10, 64), "collapse-current-pattern");
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "expand-current-pattern");
        inputMap.put(KeyStroke.getKeyStroke(10, 512), "expand-all-patterns");
        inputMap.put(KeyStroke.getKeyStroke(67, 128), "copy-pattern");
        inputMap.put(KeyStroke.getKeyStroke(86, 128), "paste-pattern");
        inputMap.put(KeyStroke.getKeyStroke(88, 128), "cut-pattern");
        inputMap2.put(KeyStroke.getKeyStroke(113, 0), "rename-something");
        inputMap2.put(KeyStroke.getKeyStroke(127, 0), "delete-something");
        inputMap2.put(KeyStroke.getKeyStroke(27, 0), "cancel-something");
        inputMap2.put(KeyStroke.getKeyStroke(77, 128), "find_next_mex_peer");
        inputMap2.put(KeyStroke.getKeyStroke(525, 0), "show_context_menu");
        inputMap2.put(KeyStroke.getKeyStroke(121, 64), "show_context_menu");
        inputMap2.put(KeyStroke.getKeyStroke(39, 64), "go_nearest_right_component");
        inputMap2.put(KeyStroke.getKeyStroke(37, 64), "go_nearest_left_component");
        inputMap2.put(KeyStroke.getKeyStroke(40, 64), "go_nearest_down_component");
        inputMap2.put(KeyStroke.getKeyStroke(38, 64), "go_nearest_up_component");
        inputMap2.put(KeyStroke.getKeyStroke(9, 0), "go_next_hierarchy_component");
        inputMap2.put(KeyStroke.getKeyStroke(9, 64), "go_previous_hierarchy_component");
        inputMap2.put(KeyStroke.getKeyStroke(10, 64), "collapse-current-pattern");
        inputMap2.put(KeyStroke.getKeyStroke(10, 0), "expand-current-pattern");
        inputMap2.put(KeyStroke.getKeyStroke(10, 512), "expand-all-patterns");
        inputMap2.put(KeyStroke.getKeyStroke(67, 128), "copy-pattern");
        inputMap2.put(KeyStroke.getKeyStroke(86, 128), "paste-pattern");
        inputMap2.put(KeyStroke.getKeyStroke(88, 128), "cut-pattern");
        actionMap.put("rename-something", new RenameAction(this));
        actionMap.put("delete-something", new DeleteAction(this));
        actionMap.put("cancel-something", new CancelAction(this));
        actionMap.put("gotosource-something", new GoToSourceAction(this));
        actionMap.put("gotomapper-something", new GoToMapperAction(this));
        actionMap.put("gotologging-something", new GoToLoggingAction(this));
        actionMap.put("findusages-something", new FindUsagesAction(this));
        actionMap.put("show_context_menu", new ShowContextMenuAction(this));
        actionMap.put("go_next_hierarchy_component", new TabToNextComponentAction(this, true));
        actionMap.put("go_previous_hierarchy_component", new TabToNextComponentAction(this, false));
        actionMap.put("scroll-to-operation", new ScrollToOperationAction(this));
        actionMap.put("expand-current-pattern", new ExpandCurrentPatternAction(this));
        actionMap.put("collapse-current-pattern", new CollapseCurrentPatternAction(this));
        actionMap.put("expand-all-patterns", new ExpandAllPatternsAction(this));
        actionMap.put("copy-pattern", this.getCopyPasteHandler().getCopyAction());
        actionMap.put("cut-pattern", this.getCopyPasteHandler().getCutAction());
        actionMap.put("paste-pattern", this.getCopyPasteHandler().getPasteAction());
    }

    public CollapseExpandDecorationProvider getCollapseExpandDecorationProvider() {
        return this.collapseExpandDectorationProvider;
    }

    public DiagramModel getModel() {
        return this.diagramModel;
    }

    public FDimension getDiagramSize() {
        FDimension fDimension = this.getModel().getRootPattern().getBounds().getSize();
        return fDimension;
    }

    public void updateAccordingToViewFiltersStatus() {
        if (this.getRootPattern() != null) {
            this.updateAccordingToViewFiltersStatus(this.getRootPattern());
            this.diagramChanged();
        }
    }

    private void updateAccordingToViewFiltersStatus(Pattern pattern) {
        if (pattern instanceof SequencePattern) {
            ((SequencePattern)pattern).updateAccordingToViewFiltersStatus();
        } else if (pattern instanceof ProcessPattern) {
            ((ProcessPattern)pattern).updateAccordingToViewFiltersStatus();
        }
        if (pattern instanceof CompositePattern) {
            for (Pattern pattern2 : ((CompositePattern)pattern).getNestedPatterns()) {
                this.updateAccordingToViewFiltersStatus(pattern2);
            }
        }
    }

    public void diagramChanged() {
        if (this.getProcessModel() != null && this.getBPELModel().getState() == Model.State.VALID && this.getModel().getRootPattern() != null) {
            double d = this.getCorrectedZoom();
            this.setToolBarEnabled(true);
            this.layoutManager.layout(this.getModel().getRootPattern());
            this.connectionManager.reconnectAll(this.getModel().getRootPattern());
            this.connectionManager.layoutConnections(this.getModel().getRootPattern());
            FDimension fDimension = this.getModel().getRootPattern().getBounds().getSize();
            int n = Math.round(fDimension.width + 2.0f);
            int n2 = Math.round(fDimension.height + 2.0f);
            this.processView.revalidate();
            this.consumersView.revalidate();
            this.providersView.revalidate();
            this.repaint();
            this.installErrorPanel(false);
            this.rightStripe.repaint();
        } else {
            this.setToolBarEnabled(false);
            this.installErrorPanel(true);
        }
    }

    private void installErrorPanel(boolean bl) {
        if (bl) {
            this.errorPanel.updateErrorMessage();
            this.remove(this.scrollPane);
            this.add(this.errorPanel);
        } else {
            this.remove(this.errorPanel);
            this.add(this.scrollPane);
        }
    }

    private void setToolBarEnabled(final boolean bl) {
        this.zoomManager.setEnabled(bl);
        this.navigationTools.setEnabled(bl);
        JComponent jComponent = this.findToolBar();
        if (jComponent != null) {
            this.setToolBarEnabled(jComponent, bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DesignView.this.setToolBarEnabled(DesignView.this.findToolBar(), bl);
                }
            });
        }
    }

    private void setToolBarEnabled(JComponent jComponent, boolean bl) {
        if (jComponent == null) {
            return;
        }
        for (java.awt.Component component : jComponent.getComponents()) {
            component.setEnabled(bl);
        }
    }

    private JComponent findToolBar() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof DesignerMultiViewElement)) continue;
            return ((DesignerMultiViewElement)((Object)container)).getToolbarRepresentation();
        }
        return null;
    }

    public TopComponent getTopComponent() {
        return (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
    }

    public Font getZoomedDiagramFont() {
        Font font = DiagramFontUtil.getFont();
        return font.deriveFont(font.getSize2D() * (float)this.getCorrectedZoom());
    }

    public double getZoom() {
        return this.zoomManager.getScale();
    }

    public double getCorrectedZoom() {
        return this.zoomManager.getScale() * DiagramFontUtil.getZoomCorrection();
    }

    public Pattern getRootPattern() {
        return this.diagramModel.getRootPattern();
    }

    protected void printChildren(Graphics graphics) {
    }

    public FPoint convertScreenToDiagram(Point point) {
        return new FPoint(0.0, 0.0);
    }

    public Point convertDiagramToScreen(FPoint fPoint) {
        return new Point(0, 0);
    }

    public static Point convertDiagramToScreen(FPoint fPoint, double d) {
        return new Point(0, 0);
    }

    public Decoration getDecoration(Pattern pattern) {
        return this.decorationManager.getDecoration(pattern);
    }

    public HelpCtx getHelpCtx() {
        HelpCtx helpCtx = new HelpCtx(DesignView.class);
        Pattern pattern = this.getSelectionModel().getSelectedPattern();
        if (pattern == null) {
            return helpCtx;
        }
        Node node = this.getNodeForPattern(pattern);
        if (node == null) {
            return helpCtx;
        }
        HelpCtx helpCtx2 = node.getHelpCtx();
        return helpCtx2 == null ? helpCtx : helpCtx2;
    }

    public void scrollPatternToView(Pattern pattern) {
        this.consumersView.scrollPatternToView(pattern);
        this.processView.scrollPatternToView(pattern);
        this.providersView.scrollPatternToView(pattern);
    }

    public void scrollToOperation(MessageConnection messageConnection) {
        VisualElement visualElement;
        VisualElement visualElement2;
        VisualElement visualElement3 = messageConnection.getSource();
        VisualElement visualElement4 = messageConnection.getTarget();
        Pattern pattern = visualElement3.getPattern();
        DiagramView diagramView = this.getProcessView();
        if (pattern.getView() == diagramView) {
            visualElement2 = visualElement3;
            visualElement = visualElement4;
        } else {
            visualElement2 = visualElement4;
            visualElement = visualElement3;
        }
        DiagramView diagramView2 = visualElement.getPattern().getView();
        FBounds fBounds = visualElement2.getBounds();
        Point point = diagramView.convertDiagramToScreen(fBounds.getTopLeft());
        Point point2 = diagramView.convertDiagramToScreen(fBounds.getBottomRight());
        FBounds fBounds2 = visualElement.getBounds();
        Point point3 = diagramView.convertDiagramToScreen(fBounds2.getTopLeft());
        Point point4 = diagramView.convertDiagramToScreen(fBounds2.getBottomRight());
        Rectangle rectangle = diagramView.getVisibleRect();
        Rectangle rectangle2 = diagramView2.getVisibleRect();
        int n = (point2.y + point.y) / 2 - rectangle.y;
        int n2 = (point3.y + point4.y) / 2 - rectangle2.y;
        rectangle2.y += n2 - n;
        diagramView2.scrollRectToVisible(rectangle2);
    }

    protected void addImpl(java.awt.Component component, Object object, int n) {
        int n2 = this.getComponentCount();
        if (component instanceof GlassPane) {
            n = 0;
            for (int i = 0; i < n2; ++i) {
                java.awt.Component component2 = this.getComponent(i);
                if (!(component2 instanceof GlassPane) && !(component2 instanceof DiagramButton)) continue;
                n = i;
                break;
            }
        } else if (component instanceof DiagramButton) {
            n = -1;
            for (int i = 0; i < n2; ++i) {
                java.awt.Component component3 = this.getComponent(i);
                if (!(component3 instanceof DiagramButton)) continue;
                n = i;
                break;
            }
        }
        super.addImpl(component, object, n);
    }

    public void scrollSelectedToView() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DesignView.this.scrollPatternToView(DesignView.this.getSelectionModel().getSelectedPattern());
            }
        });
    }

    public ValidationDecorationProvider getValidationDecorationProvider() {
        return this.validationDecorationProvider;
    }

    private void loadDecorationProviders() {
        this.selectionDecorationProvider = new SelectionDecorationProvider(this);
        this.validationDecorationProvider = new ValidationDecorationProvider(this);
        this.debuggerDecorationProvider = new DebuggerDecorationProvider(this);
        this.toolbarDecorationProvider = new ToolbarDecorationProvider(this);
        this.linkToolDecorationProvider = new LinkToolDecorationProvider(this);
        this.collapseExpandDectorationProvider = new CollapseExpandDecorationProvider(this);
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(DecorationProviderFactory.class));
        for (Object e : result.allInstances()) {
            if (e instanceof DecorationProviderFactory) {
                ((DecorationProviderFactory)e).createInstance(this);
            }
            if (!(e instanceof DebuggerDecorationProvider)) continue;
            this.debuggerDecorationProvider = (DebuggerDecorationProvider)e;
        }
    }

    public DnDHandler getDndHandler() {
        return this.dndHandler;
    }
}

