/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.decoration.components.LinkToolButton;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.DnDTool;
import org.netbeans.modules.bpel.design.selection.FlowlinkTool;
import org.netbeans.modules.bpel.model.api.BPELElementsBuilder;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.For;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.Pick;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.Sequence;
import org.netbeans.modules.bpel.model.api.TimeEvent;
import org.netbeans.modules.bpel.model.api.Wait;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.api.support.TBoolean;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.properties.ImportRegistrationHelper;
import org.netbeans.modules.websvc.core.WebServiceReference;
import org.openide.ErrorManager;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class DnDHandler
implements DragSourceListener,
DragGestureListener,
DropTargetListener {
    private DesignView designView;
    private DragSource dragSource;
    private String status;
    private MessageFlowDataFlavor flowDataFlavor = new MessageFlowDataFlavor();
    private BpelDataFlavor bpelDataFlavor = new BpelDataFlavor();
    private List<DiagramView> views;

    public DnDHandler(DesignView designView) {
        this.designView = designView;
        this.views = new ArrayList<DiagramView>(3);
        this.views.add(designView.getProcessView());
        this.views.add(designView.getConsumersView());
        this.views.add(designView.getProvidersView());
        this.dragSource = DragSource.getDefaultDragSource();
        for (DiagramView diagramView : this.views) {
            this.dragSource.createDefaultDragGestureRecognizer(diagramView, 2, this);
            new DropTarget(diagramView, 2, this, true);
        }
    }

    public DesignView getDesignView() {
        return this.designView;
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.clear();
        if (dragSourceDropEvent.getDropAction() == 2) {
            // empty if block
        }
    }

    public String getStatus() {
        return this.status;
    }

    private void setStatus(String string) {
        this.status = string;
    }

    public void clear() {
        this.setStatus(null);
        for (DiagramView diagramView : this.views) {
            diagramView.getPlaceholderManager().clear();
        }
        this.getFlowLinkTool().clear();
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Object object = dragGestureEvent.getTriggerEvent().getSource();
        if (object instanceof LinkToolButton) {
            dragGestureEvent.startDrag(DragSource.DefaultLinkDrop, new BufferedImage(1, 1, 2), new Point(0, 0), new MessageFlowTransferable((LinkToolButton)object), this);
        } else if (dragGestureEvent.getComponent() instanceof DiagramView) {
            DiagramView diagramView = (DiagramView)dragGestureEvent.getComponent();
            Pattern pattern = diagramView.findPattern(dragGestureEvent.getDragOrigin());
            Pattern pattern2 = this.designView.getSelectionModel().getSelectedPattern();
            if (pattern == null) {
                return;
            }
            if (!pattern.isDraggable()) {
                return;
            }
            if ((pattern == pattern2 || pattern.isNestedIn(pattern2)) && !this.getDesignView().getModel().isReadOnly()) {
                dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, new BufferedImage(1, 1, 2), new Point(0, 0), new BpelTransferable(pattern2), this);
            }
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        Transferable transferable = dropTargetDragEvent.getTransferable();
        if (transferable.isDataFlavorSupported(this.flowDataFlavor)) {
            try {
                LinkToolButton linkToolButton = (LinkToolButton)transferable.getTransferData(this.flowDataFlavor);
                this.getFlowLinkTool().init(linkToolButton);
                if (this.designView.getModel().isReadOnly()) {
                    this.setStatus(NbBundle.getMessage(this.getClass(), (String)"LBL_ReadOnly"));
                    dropTargetDragEvent.rejectDrag();
                    return;
                }
                if (!this.designView.getModel().getFilters().showPartnerlinks()) {
                    this.setStatus(NbBundle.getMessage(this.getClass(), (String)"LBL_CanNotCreateMessageFlow"));
                    dropTargetDragEvent.rejectDrag();
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            BpelEntity bpelEntity = this.getBpelEntity(transferable);
            if (bpelEntity == null) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            if (bpelEntity.getModel() != this.getDesignView().getBPELModel()) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            if (this.designView.getModel().isReadOnly()) {
                this.setStatus(NbBundle.getMessage(this.getClass(), (String)"LBL_ReadOnly"));
                dropTargetDragEvent.rejectDrag();
                return;
            }
            if (!this.designView.getModel().getFilters().showImplicitSequences() && bpelEntity instanceof Sequence) {
                this.setStatus(NbBundle.getMessage(this.getClass(), (String)"LBL_CanNotAddSequence"));
                dropTargetDragEvent.rejectDrag();
            } else if (!this.designView.getModel().getFilters().showPartnerlinks() && bpelEntity instanceof PartnerLink) {
                this.setStatus(NbBundle.getMessage(this.getClass(), (String)"LBL_CanNotAddPartnerLink"));
                dropTargetDragEvent.rejectDrag();
            } else {
                Pattern pattern = this.designView.getModel().getPattern(bpelEntity);
                if (pattern == null) {
                    pattern = this.designView.getModel().createPattern(bpelEntity);
                }
                for (DiagramView diagramView : this.views) {
                    diagramView.getPlaceholderManager().init(pattern);
                }
                dropTargetDragEvent.acceptDrag(2);
            }
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Transferable transferable = dropTargetDragEvent.getTransferable();
        DnDTool dnDTool = null;
        if (transferable.isDataFlavorSupported(this.flowDataFlavor)) {
            dnDTool = this.getFlowLinkTool();
            dnDTool.move(null);
        } else {
            DiagramView diagramView = (DiagramView)dropTargetDragEvent.getDropTargetContext().getComponent();
            if (diagramView != null) {
                FPoint fPoint = diagramView.convertScreenToDiagram(dropTargetDragEvent.getLocation());
                dnDTool = diagramView.getPlaceholderManager();
                dnDTool.move(fPoint);
            }
        }
        if (dnDTool != null && dnDTool.isValidLocation()) {
            dropTargetDragEvent.acceptDrag(2);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.clear();
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.getDesignView().getTopComponent().requestActive();
        this.getDesignView().requestFocusInWindow();
        final DiagramView diagramView = (DiagramView)dropTargetDropEvent.getDropTargetContext().getComponent();
        if (diagramView == null) {
            return;
        }
        final FPoint fPoint = diagramView.convertScreenToDiagram(dropTargetDropEvent.getLocation());
        Callable<Object> callable = null;
        callable = dropTargetDropEvent.isDataFlavorSupported(this.flowDataFlavor) ? new Callable<Object>(){

            @Override
            public Object call() {
                DnDHandler.this.getFlowLinkTool().drop(fPoint);
                return null;
            }
        } : new Callable<Object>(){

            @Override
            public Object call() {
                diagramView.getPlaceholderManager().drop(fPoint);
                DnDHandler.this.clear();
                return null;
            }
        };
        try {
            if (callable != null) {
                this.designView.getBPELModel().invoke((Callable)callable, (Object)this);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
    }

    private BpelEntity getBpelEntity(Transferable transferable) {
        BpelEntity bpelEntity = null;
        try {
            for (DataFlavor dataFlavor : transferable.getTransferDataFlavors()) {
                Object object;
                Class<?> clazz = dataFlavor.getRepresentationClass();
                Object object2 = transferable.getTransferData(dataFlavor);
                if (BpelNode.class.isAssignableFrom(clazz)) {
                    object = ((BpelNode)((Object)object2)).getReference();
                    if (object instanceof BpelEntity) {
                        bpelEntity = (BpelEntity)object;
                    }
                } else if (Node.class.isAssignableFrom(clazz)) {
                    bpelEntity = this.getPaletteItem((Node)object2);
                } else if (WebServiceReference.class.isAssignableFrom(clazz)) {
                    bpelEntity = this.designView.getBPELModel().getBuilder().createPartnerLink();
                    bpelEntity.setCookie(DnDHandler.class, object2);
                } else if (DataObject.class.isAssignableFrom(clazz)) {
                    object = (DataObject)object2;
                    String string = object.getPrimaryFile().getExt();
                    if (string.compareToIgnoreCase("wsdl") == 0) {
                        bpelEntity = this.designView.getBPELModel().getBuilder().createPartnerLink();
                        bpelEntity.setCookie(DnDHandler.class, (Object)object.getPrimaryFile());
                    } else if (string.compareToIgnoreCase("xsd") == 0) {
                        bpelEntity = new ImportRegistrationHelper(this.designView.getBPELModel()).createImport(object.getPrimaryFile());
                    }
                }
                if (bpelEntity == null) {
                    continue;
                }
                break;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bpelEntity;
    }

    private BpelEntity getPaletteItem(Node node) {
        String string = node.getName();
        int n = string.indexOf("_");
        if (n != -1) {
            string = string.substring(0, n);
        }
        BPELElementsBuilder bPELElementsBuilder = this.designView.getBPELModel().getBuilder();
        if (string.equals("reply")) {
            return bPELElementsBuilder.createReply();
        }
        if (string.equals("invoke")) {
            return bPELElementsBuilder.createInvoke();
        }
        if (string.equals("receive")) {
            Receive receive = bPELElementsBuilder.createReceive();
            receive.setCookie(DnDHandler.class, DnDHandler.class);
            return receive;
        }
        if (string.equals("pick")) {
            Pick pick = bPELElementsBuilder.createPick();
            pick.addOnMessage(bPELElementsBuilder.createOnMessage());
            return pick;
        }
        if (string.equals("assign")) {
            return bPELElementsBuilder.createAssign();
        }
        if (string.equals("sequence")) {
            return bPELElementsBuilder.createSequence();
        }
        if (string.equals("flow")) {
            return bPELElementsBuilder.createFlow();
        }
        if (string.equals("while")) {
            return bPELElementsBuilder.createWhile();
        }
        if (string.equals("repeatuntil")) {
            return bPELElementsBuilder.createRepeatUntil();
        }
        if (string.equals("foreach")) {
            ForEach forEach = bPELElementsBuilder.createForEach();
            forEach.setParallel(TBoolean.NO);
            try {
                forEach.setCounterName(forEach.getName() + "Counter");
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
            return forEach;
        }
        if (string.equals("scope")) {
            return bPELElementsBuilder.createScope();
        }
        if (string.equals("if")) {
            return bPELElementsBuilder.createIf();
        }
        if (string.equals("wait")) {
            Wait wait = bPELElementsBuilder.createWait();
            For for_ = bPELElementsBuilder.createFor();
            try {
                for_.setContent("'P0Y0M0DT0H0M0S'");
            }
            catch (VetoException vetoException) {
                ErrorManager.getDefault().notify(1, (Throwable)vetoException);
            }
            wait.setTimeEvent((TimeEvent)for_);
            return wait;
        }
        if (string.equals("throw")) {
            return bPELElementsBuilder.createThrow();
        }
        if (string.equals("rethrow")) {
            return bPELElementsBuilder.createRethrow();
        }
        if (string.equals("compensate")) {
            return bPELElementsBuilder.createCompensate();
        }
        if (string.equals("compensatescope")) {
            return bPELElementsBuilder.createCompensateScope();
        }
        if (string.equals("empty")) {
            return bPELElementsBuilder.createEmpty();
        }
        if (string.equals("partner")) {
            return bPELElementsBuilder.createPartnerLink();
        }
        if (string.equals("exit")) {
            return bPELElementsBuilder.createExit();
        }
        return null;
    }

    public FlowlinkTool getFlowLinkTool() {
        return this.designView.getFlowLinkTool();
    }

    class BpelTransferable
    implements Transferable {
        private BpelNode draggedNode;

        public BpelTransferable(BpelNode bpelNode) {
            this.draggedNode = bpelNode;
        }

        public BpelTransferable(Pattern pattern) {
            BpelEntity bpelEntity = pattern.getOMReference();
            assert (bpelEntity != null);
            this.draggedNode = (BpelNode)DnDHandler.this.designView.getNodeForPattern(pattern);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DnDHandler.this.bpelDataFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.getRepresentationClass() == BpelNode.class;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.draggedNode;
        }
    }

    class BpelDataFlavor
    extends DataFlavor {
        private static final long serialVersionUID = 1L;

        public BpelDataFlavor() {
            super(BpelNode.class, "Bpel element");
        }
    }

    class MessageFlowTransferable
    implements Transferable {
        private LinkToolButton button;

        public MessageFlowTransferable(LinkToolButton linkToolButton) {
            this.button = linkToolButton;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DnDHandler.this.flowDataFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.getRepresentationClass() == FlowlinkTool.class;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.button;
        }
    }

    class MessageFlowDataFlavor
    extends DataFlavor {
        private static final long serialVersionUID = 1L;

        public MessageFlowDataFlavor() {
            super(FlowlinkTool.class, "Message flow link");
        }
    }
}

