/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.GUtils;
import org.netbeans.modules.bpel.design.decoration.components.AbstractGlassPaneButton;
import org.netbeans.modules.bpel.design.decoration.components.GlassPane;
import org.netbeans.modules.bpel.design.geometry.FPoint;

public class OverlayPanel
extends JComponent {
    private DesignView designView;

    public OverlayPanel(DesignView designView) {
        this.designView = designView;
        this.setOpaque(false);
    }

    public void doLayout() {
        super.doLayout();
        for (Component component : this.getComponents()) {
            int n;
            if (!(component instanceof GlassPane)) continue;
            GlassPane glassPane = (GlassPane)component;
            AbstractGlassPaneButton abstractGlassPaneButton = (AbstractGlassPaneButton)glassPane.getDecoration();
            Point point = SwingUtilities.convertPoint(abstractGlassPaneButton, 0, 0, this);
            Rectangle rectangle = this.getVisibleRect();
            Dimension dimension = glassPane.getPreferredSize();
            int n2 = point.y + abstractGlassPaneButton.getHeight();
            if ((double)(n2 + dimension.height) > rectangle.getMaxY()) {
                n2 = point.y - dimension.height;
            }
            if ((double)((n = point.x + abstractGlassPaneButton.getWidth()) + dimension.width) > rectangle.getMaxX()) {
                n = (int)((double)n - ((double)(n + dimension.width) - rectangle.getMaxX()));
            }
            glassPane.setAnchorPoint(point.x - n + abstractGlassPaneButton.getWidth() / 2, point.y - n2 + abstractGlassPaneButton.getHeight() / 2);
            glassPane.setBounds(n, n2, dimension.width, dimension.height);
        }
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = GUtils.createGraphics(graphics);
        this.designView.getFlowLinkTool().paint(graphics2D);
    }

    public FPoint convertScreenToDiagram(Point point) {
        double d = (double)point.x / this.designView.getCorrectedZoom();
        double d2 = (double)point.y / this.designView.getCorrectedZoom();
        return new FPoint(d, d2);
    }
}

