/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.bpel.design.BWGraphics2D;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.GUtils;
import org.netbeans.modules.bpel.design.TriScrollPane;
import org.netbeans.modules.bpel.design.decoration.Decoration;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.connections.MessageConnection;
import org.netbeans.modules.bpel.design.model.elements.BorderElement;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.PartnerLinksPattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.PlaceHolder;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessView
extends DiagramView
implements TriScrollPane.Thumbnailable {
    public ProcessView(DesignView designView) {
        super(designView);
        this.putClientProperty("print.printable", Boolean.TRUE);
        this.putClientProperty("print.name", this.getProcessName(designView.getBPELModel()));
        this.putClientProperty("print.order", new Integer(1));
    }

    private String getProcessName(BpelModel bpelModel) {
        if (bpelModel == null) {
            return null;
        }
        Process process = bpelModel.getProcess();
        if (process == null) {
            return null;
        }
        return process.getName();
    }

    @Override
    protected void paintPattern(Graphics2D graphics2D, Graphics2D graphics2D2, Pattern pattern, FBounds fBounds, boolean bl) {
        if (pattern instanceof PartnerLinksPattern) {
            return;
        }
        MessageConnection.resetRoutingInfo();
        super.paintPattern(graphics2D, graphics2D2, pattern, fBounds, bl);
    }

    @Override
    public FBounds getContentSize() {
        Pattern pattern = this.getDesignView().getModel().getRootPattern();
        return pattern != null ? pattern.getBounds() : new FBounds(0.0, 0.0);
    }

    @Override
    public Iterator<Pattern> getPatterns() {
        return new ListBuilder().getList();
    }

    @Override
    public Insets getAutoscrollInsets() {
        Insets insets = super.getAutoscrollInsets();
        TriScrollPane triScrollPane = this.getDesignView().getScrollPane();
        insets.left += triScrollPane.getLeftPreferredWidth();
        insets.right += triScrollPane.getRightPreferredWidth();
        return insets;
    }

    @Override
    public void getPlaceholders(Pattern pattern, List<PlaceHolder> list) {
    }

    @Override
    public VisualElement findElement(double d, double d2) {
        Pattern pattern = this.getDesignView().getModel().getRootPattern();
        return this.findElement(pattern, d, d2);
    }

    private VisualElement findElement(Pattern pattern, double d, double d2) {
        if (pattern instanceof PartnerLinksPattern) {
            return null;
        }
        if (pattern instanceof CompositePattern) {
            for (Pattern pattern2 : ((CompositePattern)pattern).getNestedPatterns()) {
                VisualElement visualElement = this.findElement(pattern2, d, d2);
                if (visualElement == null) continue;
                return visualElement;
            }
        }
        return this.findElementInPattern(pattern, d, d2);
    }

    @Override
    public void paintThumbnail(Graphics graphics) {
        Pattern pattern = this.getDesignView().getModel().getRootPattern();
        if (pattern == null) {
            return;
        }
        Graphics2D graphics2D = GUtils.createGraphics(graphics);
        double d = this.getDesignView().getCorrectedZoom();
        Point point = this.convertDiagramToScreen(new FPoint(0.0, 0.0));
        graphics2D.translate(point.x, point.y);
        graphics2D.scale(d, d);
        BWGraphics2D bWGraphics2D = new BWGraphics2D(graphics2D);
        Rectangle rectangle = graphics2D.getClipBounds();
        double d2 = 12.0 * d;
        double d3 = 18.0 * d;
        FBounds fBounds = new FBounds((double)rectangle.x - d2, (double)rectangle.y - d3, (double)rectangle.width + 2.0 * d2, (double)rectangle.height + 2.0 * d3);
        this.paintPatternThumbnail(graphics2D, bWGraphics2D, fBounds, pattern);
        this.paintPatternThumbnailConnections(graphics2D, bWGraphics2D, pattern);
        graphics2D.dispose();
        Graphics graphics2 = graphics.create();
        graphics2.dispose();
    }

    private void paintPatternThumbnail(Graphics2D graphics2D, Graphics2D graphics2D2, FBounds fBounds, Pattern pattern) {
        if (!pattern.getBounds().isIntersects(fBounds)) {
            return;
        }
        if (pattern instanceof PartnerLinksPattern) {
            return;
        }
        Decoration decoration = this.getDesignView().getDecoration(pattern);
        if (pattern instanceof CompositePattern) {
            Graphics2D graphics2D3;
            CompositePattern compositePattern = (CompositePattern)pattern;
            BorderElement borderElement = compositePattern.getBorder();
            Graphics2D graphics2D4 = graphics2D3 = decoration.hasDimmed() ? graphics2D2 : graphics2D;
            if (borderElement != null) {
                borderElement.paintThumbnail(graphics2D3);
            }
            for (VisualElement object : compositePattern.getElements()) {
                object.paintThumbnail(graphics2D3);
            }
            for (Pattern pattern2 : compositePattern.getNestedPatterns()) {
                this.paintPatternThumbnail(graphics2D, graphics2D2, fBounds, pattern2);
            }
            if (decoration.hasStroke()) {
                decoration.getStroke().paint(graphics2D, compositePattern.createSelection());
            }
        } else {
            Graphics2D graphics2D5 = decoration.hasDimmed() ? graphics2D2 : graphics2D;
            for (VisualElement visualElement : pattern.getElements()) {
                visualElement.paintThumbnail(graphics2D5);
            }
            if (decoration.hasStroke()) {
                decoration.getStroke().paint(graphics2D, pattern.createSelection());
            }
        }
    }

    private void paintPatternThumbnailConnections(Graphics2D graphics2D, Graphics2D graphics2D2, Pattern pattern) {
        Object object;
        if (pattern == null) {
            return;
        }
        if (pattern instanceof CompositePattern) {
            object = (CompositePattern)pattern;
            for (Pattern object2 : ((CompositePattern)object).getNestedPatterns()) {
                this.paintPatternThumbnailConnections(graphics2D, graphics2D2, object2);
            }
        }
        object = this.getDesignView().getDecoration(pattern).hasDimmed() ? graphics2D2 : graphics2D;
        for (Connection connection : pattern.getConnections()) {
            if (connection instanceof MessageConnection) continue;
            connection.paintThumbnail((Graphics2D)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ListBuilder {
        private ArrayList<Pattern> list;

        ListBuilder() {
        }

        public Iterator<Pattern> getList() {
            this.list = new ArrayList();
            this.buildList(ProcessView.this.getDesignView().getModel().getRootPattern());
            return this.list.iterator();
        }

        private void buildList(Pattern pattern) {
            if (pattern instanceof PartnerLinksPattern) {
                return;
            }
            this.list.add(pattern);
            if (pattern instanceof CompositePattern) {
                for (Pattern pattern2 : ((CompositePattern)pattern).getNestedPatterns()) {
                    this.buildList(pattern2);
                }
            }
        }
    }
}

