/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.ProcessView;
import org.netbeans.modules.bpel.design.decoration.Decoration;
import org.netbeans.modules.bpel.design.decoration.StripeDescriptor;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.xml.xam.Model;
import org.openide.util.NbBundle;

public class RightStripe
extends JPanel
implements ComponentListener,
MouseListener,
MouseMotionListener {
    private DesignView designView;
    private StatusPanel statusPanel = new StatusPanel();
    private DataPanel dataPanel = new DataPanel();
    private StripeDescriptor statusStripe = new StripeDescriptor();
    private Map<Integer, Cell> cells = new HashMap<Integer, Cell>();
    private boolean needsToBePrepeared = true;
    private static final Color BORDER_DARK = new Color(13486779);
    private static final Color BORDER_BRIGHT = Color.WHITE;

    public RightStripe(DesignView designView) {
        this.designView = designView;
        this.setFocusable(false);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.statusPanel, "North");
        this.add((Component)this.dataPanel, "Center");
        this.dataPanel.addComponentListener(this);
        this.dataPanel.addMouseListener(this);
        this.dataPanel.addMouseMotionListener(this);
        this.setToolTipText(null);
    }

    private boolean isModelBroken() {
        return this.getDesignView().getBPELModel().getState() != Model.State.VALID;
    }

    public void repaint() {
        this.needsToBePrepeared = true;
        super.repaint();
    }

    public DesignView getDesignView() {
        return this.designView;
    }

    private void prepareToRepaint() {
        if (this.needsToBePrepeared) {
            this.statusStripe = new StripeDescriptor();
            this.cells.clear();
            if (!this.isModelBroken()) {
                this.prepareToRepaint(this.designView.getRootPattern());
            }
            this.needsToBePrepeared = false;
            this.updateCursor(null);
        }
    }

    private void prepareToRepaint(Pattern pattern) {
        if (pattern == null) {
            return;
        }
        this.addCellItem(pattern);
        if (pattern instanceof CompositePattern) {
            for (Pattern pattern2 : ((CompositePattern)pattern).getNestedPatterns()) {
                this.prepareToRepaint(pattern2);
            }
        }
    }

    private Rectangle getPatternBounds(Pattern pattern) {
        Object object;
        FBounds fBounds = null;
        if (pattern instanceof CompositePattern && (object = ((CompositePattern)pattern).getBorder()) != null) {
            fBounds = ((VisualElement)object).getBounds();
        }
        if (fBounds == null) {
            fBounds = pattern.getBounds();
        }
        object = pattern.getView();
        Point point = ((DiagramView)object).convertDiagramToScreen(fBounds.getTopLeft());
        Point point2 = ((DiagramView)object).convertDiagramToScreen(fBounds.getBottomRight());
        return new Rectangle(point.x - 16, point.y - 32, point2.x - point.x + 32, point2.y - point.y + 64);
    }

    private void addCellItem(Pattern pattern) {
        if (pattern == null) {
            return;
        }
        Decoration decoration = this.designView.getDecoration(pattern);
        if (decoration == null || !decoration.hasStripe()) {
            return;
        }
        int n = this.getCellNumber(pattern);
        Cell cell = this.cells.get(n);
        if (cell == null) {
            cell = new Cell();
            this.cells.put(n, cell);
        }
        StripeDescriptor stripeDescriptor = decoration.getStripe();
        this.statusStripe = StripeDescriptor.merge(this.statusStripe, stripeDescriptor);
        cell.addItem(pattern, stripeDescriptor);
    }

    private int getCellNumber(Pattern pattern) {
        FPoint fPoint = pattern.getBounds().getTopLeft();
        FBounds fBounds = this.getDesignView().getRootPattern().getBounds();
        int n = (int)((double)((fPoint.y - fBounds.y) / fBounds.height * (float)this.dataPanel.getHeight()) / 4.0);
        if (n >= this.getCellCount()) {
            n = this.getCellCount() - 1;
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    private int getCellCount() {
        return (this.dataPanel.getHeight() + 1) / 4;
    }

    private Cell getCell(int n) {
        int n2 = n / 4;
        Cell cell = this.cells.get(n2);
        if (cell != null) {
            return cell;
        }
        cell = n < n2 * 4 + 2 ? this.cells.get(n2 - 1) : this.cells.get(n2 + 1);
        return cell;
    }

    private void updateCursor(Point point) {
        if (point == null) {
            point = this.dataPanel.getMousePosition();
        }
        if (point != null) {
            this.dataPanel.setCursor(this.getCell(point.y) != null ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 1) {
            return;
        }
        Cell cell = this.getCell(mouseEvent.getY());
        if (cell == null) {
            return;
        }
        Pattern pattern = cell.getNextPattern(this.designView.getSelectionModel().getSelectedPattern());
        if (pattern != null) {
            if (pattern != this.designView.getSelectionModel().getSelectedPattern()) {
                this.designView.getSelectionModel().setSelectedPattern(pattern);
            }
            DiagramView diagramView = pattern.getView();
            Rectangle rectangle = this.getPatternBounds(pattern);
            Rectangle rectangle2 = this.designView.getVisibleRect();
            int n = 0;
            int n2 = 0;
            if (diagramView instanceof ProcessView) {
                DiagramView diagramView2 = this.designView.getProvidersView();
                DiagramView diagramView3 = this.designView.getConsumersView();
                if (diagramView3.isVisible()) {
                    n = diagramView3.getWidth();
                }
                if (diagramView2.isVisible()) {
                    n2 = diagramView2.getWidth();
                }
            }
            rectangle2.x += n;
            rectangle2.width -= n + n2;
            rectangle2.y = rectangle.height <= rectangle2.height ? Math.max(0, rectangle.y + (rectangle.height - rectangle2.height) / 2) : Math.max(0, rectangle.y);
            rectangle2.x = Math.max(0, rectangle.x + (rectangle.width - rectangle2.width) / 2);
            rectangle2.x -= n;
            rectangle2.width += n + n2;
            diagramView.scrollRectToVisible(rectangle2);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.updateCursor(mouseEvent.getPoint());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateCursor(mouseEvent.getPoint());
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    private static class Cell {
        private StripeDescriptor stripeDescriptor = null;
        private List<Pattern> patterns = new ArrayList<Pattern>();

        private Cell() {
        }

        public void addItem(Pattern pattern, StripeDescriptor stripeDescriptor) {
            this.stripeDescriptor = StripeDescriptor.merge(this.stripeDescriptor, stripeDescriptor);
            this.patterns.add(pattern);
        }

        public String getToolTipText() {
            return this.stripeDescriptor == null ? null : this.stripeDescriptor.getText();
        }

        public StripeDescriptor getStripeDescriptor() {
            return this.stripeDescriptor;
        }

        public Pattern getNextPattern(Pattern pattern) {
            int n = pattern == null ? -1 : this.patterns.indexOf(pattern);
            Pattern pattern2 = this.patterns.get((n + 1) % this.patterns.size());
            return pattern2;
        }
    }

    private class DataPanel
    extends JPanel {
        public DataPanel() {
            this.setFocusable(false);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            RightStripe.this.prepareToRepaint();
            int n = this.getWidth();
            for (Map.Entry entry : RightStripe.this.cells.entrySet()) {
                int n2 = (Integer)entry.getKey() * 4;
                StripeDescriptor stripeDescriptor = ((Cell)entry.getValue()).getStripeDescriptor();
                graphics.setColor(stripeDescriptor.getColor());
                if (stripeDescriptor.isFilled()) {
                    graphics.fillRect(1, n2, n - 2, 3);
                    continue;
                }
                graphics.drawRect(1, n2, n - 3, 2);
            }
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Cell cell = RightStripe.this.getCell(mouseEvent.getY());
            return cell == null ? null : cell.getToolTipText();
        }
    }

    private class StatusPanel
    extends JPanel {
        public StatusPanel() {
            this.setFocusable(false);
            this.setPreferredSize(new Dimension(13, 24));
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = 2;
            int n4 = 7;
            int n5 = n - 2 * n3;
            if (RightStripe.this.isModelBroken()) {
                graphics.setColor(StripeDescriptor.ERROR_COLOR);
            } else {
                graphics.setColor(RightStripe.this.statusStripe.getStatusColor());
            }
            graphics.fillRect(n3 + 1, n4 + 1, n5 - 2, n5 - 2);
            graphics.setColor(BORDER_BRIGHT);
            graphics.drawRect(n3, n4, n5 - 1, n5 - 1);
            graphics.setColor(BORDER_DARK);
            graphics.drawLine(n3, n4, n3 + n5 - 2, n4);
            graphics.drawLine(n3, n4, n3, n4 + n5 - 2);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            if (RightStripe.this.isModelBroken()) {
                return NbBundle.getMessage(RightStripe.class, (String)"LBL_InvalidSources");
            }
            return RightStripe.this.statusStripe.getStatusText();
        }
    }
}

