/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ViewportLayout;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import org.openide.util.NbBundle;

public class TriScrollPane
extends JScrollPane
implements ActionListener,
AdjustmentListener {
    private JComponent left;
    private JComponent right;
    private JComponent center;
    private JComponent handToolPanel;
    private JComponent overlayPanel;
    private SideComponent leftComponent;
    private SideComponent rightComponent;
    private boolean layoutNow = false;
    private ArrayList<ScrollListener> scrollListeners = new ArrayList(1);
    private JToggleButton thumbToggleButton;
    private ThumbnailView thumbnailView;
    private JScrollPane thumbScrollPane;
    private static final Border LEFT_SIDE_BORDER = new Border(){

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 1);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            int n5 = n + n3 - 1;
            int n6 = n2 + n4 - 1;
            graphics.setColor(component.getBackground().darker());
            graphics.drawLine(n5, n2, n5, n6);
            graphics.setColor(color);
        }
    };
    private static final Border RIGHT_SIDE_BORDER = new Border(){

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 1, 0, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            int n5 = n2 + n4 - 1;
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.drawLine(n, n2, n, n5);
            graphics.setColor(color);
        }
    };
    private ChangeListener myScrollListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() != TriScrollPane.this.getViewport()) {
                TriScrollPane.this.center.repaint();
            }
            for (ScrollListener scrollListener : TriScrollPane.this.scrollListeners) {
                scrollListener.viewScrolled(null);
            }
        }
    };
    private static final int BUTTON_SIZE = 23;
    private static final int BUTTON_PADDING = 4;
    private static final int BUTTON_MARGIN = 4;
    private static final Color BUTTON_FILL = new Color(-1999844148, true);
    private static final Color BUTTON_STROKE = new Color(-2004318072, true);
    private static final Color BUTTON_ROLLOVER_FILL = new Color(0xCCCCCC);
    private static final Color BUTTON_ROLLOVER_STROKE = new Color(0x888888);
    private static final Color BUTTON_PRESSED_FILL = new Color(0xBBBBBB);
    private static final Color BUTTON_PRESSED_STROKE = new Color(0x888888);
    private static final Color ICON_COLOR = new Color(-1996488705, true);
    private static final Color ICON_COLOR_ROLLOVER = new Color(0xFFFFFF);
    private static final float COS_30 = (float)Math.cos(0.5235987755982988);
    private static final float SIN_30 = (float)Math.sin(0.5235987755982988);
    private static final Color SIDE_BACKGROUND = new Color(0x44000000 | new Color(16579317).darker().getRGB() & 0xFFFFFF, true);
    private static final double VIEWPORT_K_X = 0.8;
    private static final double VIEWPORT_K_Y = 0.5;
    private static final double THUMBNAIL_K = 0.4;
    private static final int ASPECT_RATIO_X = 3;
    private static final int ASPECT_RATIO_Y = 4;
    private static final int ASPECT_MAX_UNIT = 80;
    private static final int ASPECT_MIN_UNIT = 20;
    private static final int VIEW_MARGIN = 4;
    private static final Color STROKE_COLOR = new Color(0x66000000, true);
    private static final Color FILL_COLOR = new Color(0x11000000, true);
    private static final String TOGGLE_THUMBNAIL = "toggle_thumbnail";
    private static final KeyStroke TOGGLE_THUMBNAIL_KEYSTROKE = KeyStroke.getKeyStroke(66, 128);

    public TriScrollPane(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4, JComponent jComponent5) {
        super(jComponent);
        this.setBorder(null);
        this.handToolPanel = jComponent4;
        this.overlayPanel = jComponent5;
        this.left = jComponent2;
        this.right = jComponent3;
        this.center = jComponent;
        jComponent2.setBackground(SIDE_BACKGROUND);
        jComponent3.setBackground(SIDE_BACKGROUND);
        this.leftComponent = new SideComponent(jComponent2);
        this.rightComponent = new SideComponent(jComponent3);
        this.thumbToggleButton = new ThumbToggleButton();
        this.thumbToggleButton.addActionListener(this);
        this.thumbnailView = new ThumbnailView();
        this.thumbScrollPane = new JScrollPane(this.thumbnailView, 21, 31);
        this.thumbScrollPane.getViewport().setLayout(new ThumbnailViewportLayout());
        this.getHorizontalScrollBar().addAdjustmentListener(this);
        this.getVerticalScrollBar().addAdjustmentListener(this);
        this.add(this.thumbToggleButton);
        this.add((Component)this.leftComponent, 0);
        this.add((Component)this.rightComponent, 0);
        this.add((Component)this.thumbScrollPane, 0);
        if (jComponent5 != null) {
            this.add((Component)jComponent5, 0);
        }
        if (jComponent4 != null) {
            this.add((Component)jComponent4, 0);
        }
        this.getVerticalScrollBar().setUnitIncrement(10);
        this.getHorizontalScrollBar().setUnitIncrement(10);
        this.getViewport().setScrollMode(0);
        this.getViewport().addChangeListener(this.myScrollListener);
        this.leftComponent.getViewport().addChangeListener(this.myScrollListener);
        this.rightComponent.getViewport().addChangeListener(this.myScrollListener);
        this.getInputMap(1).put(TOGGLE_THUMBNAIL_KEYSTROKE, TOGGLE_THUMBNAIL);
        this.getActionMap().put(TOGGLE_THUMBNAIL, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TriScrollPane.this.thumbToggleButton.setSelected(!TriScrollPane.this.thumbToggleButton.isSelected());
                TriScrollPane.this.actionPerformed(actionEvent);
            }
        });
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.thumbnailView.isIgnoreViewScroll()) {
            return;
        }
        if (this.thumbScrollPane.isVisible()) {
            this.thumbnailView.revalidate();
            this.thumbnailView.repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.thumbScrollPane.setVisible(this.thumbToggleButton.isSelected() && (this.getHorizontalScrollBar().isVisible() || this.getVerticalScrollBar().isVisible()));
    }

    public int getLeftPreferredWidth() {
        return this.left.isVisible() ? this.leftComponent.getPreferredSize().width : 0;
    }

    public int getRightPreferredWidth() {
        return this.right.isVisible() ? this.rightComponent.getPreferredSize().width : 0;
    }

    public void addScrollListener(ScrollListener scrollListener) {
        this.scrollListeners.add(scrollListener);
    }

    public void removeScrollListener(ScrollListener scrollListener) {
        this.scrollListeners.remove(scrollListener);
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void doLayout() {
        super.doLayout();
        boolean bl = this.left.isVisible();
        boolean bl2 = this.right.isVisible();
        int n = !bl ? 0 : this.leftComponent.getPreferredSize().width;
        int n2 = !bl2 ? 0 : this.rightComponent.getPreferredSize().width;
        Rectangle rectangle = this.getViewport().getBounds();
        if (bl) {
            this.leftComponent.setVisible(true);
            this.leftComponent.setBounds(rectangle.x, rectangle.y, n, rectangle.height);
        }
        if (bl2) {
            this.rightComponent.setVisible(true);
            this.rightComponent.setBounds(rectangle.x + rectangle.width - n2, rectangle.y, n2, rectangle.height);
        }
        if (this.overlayPanel != null) {
            this.overlayPanel.setBounds(rectangle);
        }
        if (this.handToolPanel != null) {
            this.handToolPanel.setBounds(rectangle);
        }
        Rectangle rectangle2 = rectangle.getBounds();
        Insets insets = this.getViewport().getInsets();
        rectangle2.x += insets.left;
        rectangle2.width -= insets.left + insets.right;
        rectangle2.y += insets.top;
        rectangle2.height -= insets.top + insets.bottom;
        int n3 = (int)Math.round(Math.min(80.0, 0.4 * Math.min(rectangle2.getWidth() / 3.0, rectangle2.getHeight() / 4.0)));
        int n4 = n3 * 3;
        int n5 = n3 * 4;
        JScrollBar jScrollBar = this.getHorizontalScrollBar();
        JScrollBar jScrollBar2 = this.getVerticalScrollBar();
        boolean bl3 = jScrollBar.isVisible();
        boolean bl4 = jScrollBar2.isVisible();
        if (bl3 || bl4) {
            int n6;
            this.thumbToggleButton.setVisible(true);
            int n7 = bl4 ? jScrollBar2.getWidth() : jScrollBar2.getPreferredSize().width;
            int n8 = bl3 ? jScrollBar.getHeight() : jScrollBar.getPreferredSize().height;
            int n9 = bl4 ? jScrollBar2.getX() : jScrollBar.getX() + jScrollBar.getWidth() - n7;
            int n10 = n6 = bl3 ? jScrollBar.getY() : jScrollBar2.getY() + jScrollBar2.getHeight() - n8;
            if (!bl3 || !bl4) {
                if (bl3) {
                    jScrollBar.setBounds(jScrollBar.getX(), jScrollBar.getY(), jScrollBar.getWidth() - n7, jScrollBar.getHeight());
                }
                if (bl4) {
                    jScrollBar2.setBounds(jScrollBar2.getX(), jScrollBar2.getY(), jScrollBar2.getWidth(), jScrollBar2.getHeight() - n8);
                }
            }
            int n11 = rectangle2.x + rectangle2.width - n4 - n2 - 4;
            int n12 = rectangle2.y + rectangle2.height - n5 - 4;
            this.thumbScrollPane.setBounds(n11, n12, n4, n5);
            this.thumbScrollPane.setVisible(this.thumbToggleButton.isSelected());
            this.thumbToggleButton.setBounds(n9, n6, n7, n8);
        } else {
            this.thumbToggleButton.setVisible(false);
            this.thumbScrollPane.setVisible(false);
        }
    }

    public JComponent getComponent(Point point) {
        if (this.rightComponent.getBounds().contains(point)) {
            return this.right;
        }
        if (this.leftComponent.getBounds().contains(point)) {
            return this.left;
        }
        if (this.viewport.getBounds().contains(point)) {
            return this.center;
        }
        return null;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        boolean bl = this.left.isVisible();
        boolean bl2 = this.right.isVisible();
        int n = !bl ? 0 : this.leftComponent.getPreferredSize().width;
        int n2 = !bl2 ? 0 : this.rightComponent.getPreferredSize().width;
        dimension.width = Math.max(dimension.width, n + 120 + n2);
        return dimension;
    }

    private static void fitPointInRect(Point point, Rectangle rectangle) {
        point.x = Math.max(rectangle.x, Math.min(point.x, rectangle.x + rectangle.width - 1));
        point.y = Math.max(rectangle.y, Math.min(point.y, rectangle.y + rectangle.height - 1));
    }

    public static interface Thumbnailable {
        public void paintThumbnail(Graphics var1);
    }

    private static class ThumbnailViewportLayout
    extends ViewportLayout {
        private ThumbnailViewportLayout() {
        }

        public void layoutContainer(Container container) {
            JViewport jViewport = (JViewport)container;
            ThumbnailView thumbnailView = (ThumbnailView)jViewport.getView();
            super.layoutContainer(container);
            thumbnailView.centralize();
        }
    }

    private static class ThumbnailView
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    ActionListener {
        private Dimension cachedPreferredSize;
        private Rectangle cachedViewRectangle;
        private Rectangle cachedViewVisibleRectangle;
        private Point2D cachedViewVisibleRectangleCenter;
        private double cachedKX;
        private double cachedKY;
        private double mouseDX;
        private double mouseDY;
        private boolean ignoreViewScroll = false;
        private MouseEvent lastMouseEvent = null;
        private Point lastMouseOnScreenPosition = null;
        private Timer timer;

        public ThumbnailView() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.timer = new Timer(100, this);
            this.setFocusable(false);
        }

        public boolean isIgnoreViewScroll() {
            return this.ignoreViewScroll;
        }

        public Dimension calculatePreferredSize() {
            double d;
            JViewport jViewport = (JViewport)this.getParent();
            Dimension dimension = jViewport.getSize();
            Insets insets = jViewport.getInsets();
            int n = dimension.width - insets.left - insets.right;
            int n2 = dimension.height - insets.top - insets.bottom;
            Dimension dimension2 = this.getView().getSize();
            Rectangle rectangle = this.getView().getVisibleRect();
            double d2 = (double)n / (double)dimension2.width;
            double d3 = (double)n2 / (double)dimension2.height;
            double d4 = Math.min(d2, d3);
            double d5 = d4 >= (d = Math.min((double)n * 0.8 / (double)rectangle.width, (double)n2 * 0.5 / (double)rectangle.height)) ? d4 : d;
            this.cachedPreferredSize = new Dimension((int)Math.round((double)dimension2.width * d5), (int)Math.round((double)dimension2.height * d5));
            return new Dimension(this.cachedPreferredSize);
        }

        private Rectangle calculateViewRectangle() {
            int n = this.cachedPreferredSize.width;
            int n2 = this.cachedPreferredSize.height;
            int n3 = (this.getWidth() - n) / 2;
            int n4 = (this.getHeight() - n2) / 2;
            this.cachedViewRectangle = new Rectangle(n3, n4, n, n2);
            return new Rectangle(this.cachedViewRectangle);
        }

        private Rectangle convertViewVisibleRectangle(Rectangle rectangle) {
            JComponent jComponent = this.getView();
            Dimension dimension = jComponent.getSize();
            double d = (double)this.cachedPreferredSize.width / (double)dimension.width;
            double d2 = (double)this.cachedPreferredSize.height / (double)dimension.height;
            int n = (int)Math.round(rectangle.getMinX() * d);
            int n2 = (int)Math.round(rectangle.getMinY() * d2);
            int n3 = (int)Math.round(rectangle.getMaxX() * d);
            int n4 = (int)Math.round(rectangle.getMaxY() * d2);
            return new Rectangle(n, n2, n3 - n, n4 - n2);
        }

        private Rectangle calculateViewVisibleRectangle() {
            JComponent jComponent = this.getView();
            Dimension dimension = jComponent.getSize();
            double d = (double)this.cachedPreferredSize.width / (double)dimension.width;
            double d2 = (double)this.cachedPreferredSize.height / (double)dimension.height;
            Rectangle rectangle = jComponent.getVisibleRect();
            int n = (int)Math.round(rectangle.getMinX() * d);
            int n2 = (int)Math.round(rectangle.getMinY() * d2);
            int n3 = (int)Math.round(rectangle.getMaxX() * d);
            int n4 = (int)Math.round(rectangle.getMaxY() * d2);
            this.cachedKX = d;
            this.cachedKY = d2;
            this.cachedViewVisibleRectangleCenter = new Point2D.Double(rectangle.getCenterX() * d, rectangle.getCenterY() * d2);
            this.cachedViewVisibleRectangle = new Rectangle(n, n2, n3 - n, n4 - n2);
            return new Rectangle(this.cachedViewVisibleRectangle);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Rectangle rectangle = new Rectangle(this.cachedViewRectangle);
            Rectangle rectangle2 = new Rectangle(this.cachedViewVisibleRectangle);
            graphics.translate(rectangle.x, rectangle.y);
            JComponent jComponent = this.getView();
            Color color = jComponent.getBackground();
            graphics.setColor(color == null ? Color.WHITE : color);
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            if (jComponent instanceof Thumbnailable) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.scale(this.cachedKX, this.cachedKY);
                ((Thumbnailable)((Object)jComponent)).paintThumbnail(graphics2D);
                graphics2D.dispose();
            }
            graphics.setColor(FILL_COLOR);
            graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            graphics.setColor(STROKE_COLOR);
            graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
        }

        public void centralize() {
            Rectangle rectangle = this.calculateViewRectangle();
            Rectangle rectangle2 = this.calculateViewVisibleRectangle();
            int n = rectangle.x + rectangle2.x + rectangle2.width / 2;
            int n2 = rectangle.y + rectangle2.y + rectangle2.height / 2;
            JViewport jViewport = (JViewport)this.getParent();
            Dimension dimension = jViewport.getExtentSize();
            int n3 = n - dimension.width / 2;
            int n4 = n2 - dimension.height / 2;
            if (n3 + dimension.width > this.getWidth()) {
                n3 = this.getWidth() - dimension.width;
            }
            if (n4 + dimension.height > this.getHeight()) {
                n4 = this.getHeight() - dimension.height;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            jViewport.setViewPosition(new Point(n3, n4));
        }

        private JScrollPane getScrollPane() {
            return (JScrollPane)this.getParent().getParent().getParent();
        }

        private JViewport getViewport() {
            return this.getScrollPane().getViewport();
        }

        private JComponent getView() {
            return (JComponent)this.getViewport().getView();
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension getPreferredSize() {
            return this.calculatePreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.calculatePreferredSize();
        }

        public void doLayout() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            point.x -= this.cachedViewRectangle.x;
            point.y -= this.cachedViewRectangle.y;
            if (!this.cachedViewVisibleRectangle.contains(point)) {
                JComponent jComponent = this.getView();
                Rectangle rectangle = jComponent.getVisibleRect();
                rectangle.x = (int)Math.round((double)point.x / this.cachedKX - 0.5 * (double)rectangle.width);
                rectangle.y = (int)Math.round((double)point.y / this.cachedKY - 0.5 * (double)rectangle.height);
                this.ignoreViewScroll = true;
                jComponent.scrollRectToVisible(rectangle);
                this.ignoreViewScroll = false;
                this.scrollRectToVisible(this.calculateViewVisibleRectangle());
                this.mouseDX = 0.0;
                this.mouseDY = 0.0;
            } else {
                this.mouseDX = (double)point.x - this.cachedViewVisibleRectangleCenter.getX();
                this.mouseDY = (double)point.y - this.cachedViewVisibleRectangleCenter.getY();
            }
            this.lastMouseEvent = null;
            this.lastMouseOnScreenPosition = null;
            this.setCursor(Cursor.getPredefinedCursor(13));
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.lastMouseEvent = null;
            this.lastMouseOnScreenPosition = null;
            this.timer.stop();
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, this);
            this.centralize();
            SwingUtilities.convertPointFromScreen(point, this);
            this.updateCursor(point);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.timer.stop();
            this.storeLastDragEvent(mouseEvent);
            Point point = mouseEvent.getPoint();
            TriScrollPane.fitPointInRect(point, this.getVisibleRect());
            JComponent jComponent = this.getView();
            Rectangle rectangle = jComponent.getVisibleRect();
            int n = (int)Math.round(((double)(point.x - this.cachedViewRectangle.x) - this.mouseDX) / this.cachedKX - 0.5 * (double)rectangle.width);
            int n2 = (int)Math.round(((double)(point.y - this.cachedViewRectangle.y) - this.mouseDY) / this.cachedKY - 0.5 * (double)rectangle.height);
            if (rectangle.x != n || rectangle.y != n2) {
                rectangle.x = n;
                rectangle.y = n2;
                this.ignoreViewScroll = true;
                jComponent.scrollRectToVisible(rectangle);
                this.ignoreViewScroll = false;
                this.scrollRectToVisible(this.calculateViewVisibleRectangle());
            }
            this.timer.start();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.updateCursor(mouseEvent.getPoint());
        }

        private void updateCursor(Point point) {
            Cursor cursor;
            if (point == null) {
                cursor = Cursor.getDefaultCursor();
            } else {
                point.x -= this.cachedViewRectangle.x;
                point.y -= this.cachedViewRectangle.y;
                cursor = this.cachedViewVisibleRectangle.contains(point) ? Cursor.getPredefinedCursor(13) : Cursor.getDefaultCursor();
            }
            if (!cursor.equals(this.getCursor())) {
                this.setCursor(cursor);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.lastMouseEvent == null) {
                this.timer.stop();
                return;
            }
            if (actionEvent.getWhen() < this.lastMouseEvent.getWhen() + 50L) {
                return;
            }
            Point point = new Point(this.lastMouseOnScreenPosition);
            SwingUtilities.convertPointFromScreen(point, this);
            this.mouseDragged(new MouseEvent(this, this.lastMouseEvent.getID(), actionEvent.getWhen(), this.lastMouseEvent.getModifiers(), point.x, point.y, this.lastMouseEvent.getClickCount(), this.lastMouseEvent.isPopupTrigger()));
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        private void storeLastDragEvent(MouseEvent mouseEvent) {
            this.lastMouseEvent = mouseEvent;
            this.lastMouseOnScreenPosition = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(this.lastMouseOnScreenPosition, this);
        }
    }

    private static class ThumbToggleButton
    extends JToggleButton {
        public ThumbToggleButton() {
            this.setToolTipText(NbBundle.getMessage(TriScrollPane.class, (String)"TOOLTIP_ShowThumbnailView"));
            this.setFocusable(false);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = 4;
            int n2 = 4;
            int n3 = this.getWidth() - 8;
            int n4 = this.getHeight() - 8;
            if (this.getUI() instanceof MetalToggleButtonUI) {
                ++n3;
                ++n4;
            }
            graphics.setColor(new Color(11784434));
            graphics.fillRect(n + n3 / 2, n2 + n4 / 2, n3 - n3 / 2 - 1, n4 - n4 / 2 - 1);
            graphics.setColor(new Color(4748998));
            graphics.drawRect(n + n3 / 2, n2 + n4 / 2, n3 - n3 / 2 - 1, n4 - n4 / 2 - 1);
            graphics.setColor(new Color(801949));
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }
    }

    public static interface ScrollListener {
        public void viewScrolled(JComponent var1);
    }

    private static class DownButton
    extends ScrollButton {
        private DownButton() {
        }

        Shape createIconShape() {
            ButtonModel buttonModel = this.getModel();
            float f = 0.5f * (float)this.getWidth();
            float f2 = 0.5f * (float)this.getHeight();
            float f3 = -(Math.min(f, f2) - 6.5f);
            float f4 = f3 * COS_30;
            float f5 = f3 * SIN_30;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(f, f2 - f3);
            generalPath.lineTo(f + f4, f2 + f5);
            generalPath.lineTo(f - f4, f2 + f5);
            generalPath.closePath();
            return generalPath;
        }
    }

    private static class UpButton
    extends ScrollButton {
        private UpButton() {
        }

        Shape createIconShape() {
            ButtonModel buttonModel = this.getModel();
            float f = 0.5f * (float)this.getWidth();
            float f2 = 0.5f * (float)this.getHeight();
            float f3 = Math.min(f, f2) - 6.5f;
            float f4 = f3 * COS_30;
            float f5 = f3 * SIN_30;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(f, f2 - f3);
            generalPath.lineTo(f + f4, f2 + f5);
            generalPath.lineTo(f - f4, f2 + f5);
            generalPath.closePath();
            return generalPath;
        }
    }

    private static abstract class ScrollButton
    extends JButton {
        ScrollButton() {
            this.setContentAreaFilled(false);
            this.setRolloverEnabled(true);
            this.setBorderPainted(false);
            this.setOpaque(false);
            this.setFocusable(false);
        }

        public boolean contains(int n, int n2) {
            double d;
            double d2;
            double d3 = 0.5 * (double)this.getWidth();
            double d4 = (double)n - d3;
            return d4 * d4 / d3 / d3 + (d2 = (double)n2 - (d = 0.5 * (double)this.getHeight())) * d2 / d / d <= 1.0;
        }

        public void paintComponent(Graphics graphics) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            ButtonModel buttonModel = this.getModel();
            Shape shape = this.createIconShape();
            if (buttonModel.isPressed()) {
                graphics2D.setPaint(BUTTON_PRESSED_FILL);
            } else if (buttonModel.isRollover()) {
                graphics2D.setPaint(BUTTON_ROLLOVER_FILL);
            } else {
                graphics2D.setPaint(BUTTON_FILL);
            }
            graphics2D.translate(0.5, 0.5);
            graphics2D.fillOval(0, 0, n - 1, n2 - 1);
            graphics2D.translate(-0.5, -0.5);
            if (buttonModel.isRollover()) {
                graphics2D.setPaint(ICON_COLOR_ROLLOVER);
            } else {
                graphics2D.setPaint(ICON_COLOR);
            }
            graphics2D.fill(shape);
            if (buttonModel.isPressed()) {
                graphics2D.setPaint(BUTTON_PRESSED_STROKE);
            } else if (buttonModel.isRollover()) {
                graphics2D.setPaint(BUTTON_ROLLOVER_STROKE);
            } else {
                graphics2D.setPaint(BUTTON_STROKE);
            }
            graphics2D.translate(0.5, 0.5);
            graphics2D.drawOval(0, 0, n - 1, n2 - 1);
            graphics2D.translate(-0.5, -0.5);
            graphics2D.draw(shape);
            graphics2D.dispose();
        }

        public Dimension getPreferredSize() {
            return new Dimension(23, 23);
        }

        abstract Shape createIconShape();
    }

    private static class SideComponent
    extends JScrollPane
    implements ChangeListener,
    MouseWheelListener,
    ActionListener {
        JButton scrollUpButton;
        JButton scrollDownButton;
        Timer scrollTimer;
        int scrollTimerDirection = 0;

        SideComponent(JComponent jComponent) {
            super(jComponent);
            this.setOpaque(false);
            this.setHorizontalScrollBarPolicy(31);
            this.setVerticalScrollBarPolicy(21);
            this.setBorder(null);
            this.getViewport().setScrollMode(0);
            this.getViewport().setOpaque(false);
            this.scrollUpButton = new UpButton();
            this.scrollDownButton = new DownButton();
            this.add((Component)this.scrollUpButton, 0);
            this.add((Component)this.scrollDownButton, 0);
            this.getViewport().addChangeListener(this);
            this.addMouseWheelListener(this);
            this.scrollUpButton.getModel().addChangeListener(this);
            this.scrollDownButton.getModel().addChangeListener(this);
            this.scrollTimer = new Timer(100, this);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = Math.max(dimension.width, 31);
            dimension.height = Math.max(dimension.height, 58);
            return dimension;
        }

        public void doLayout() {
            super.doLayout();
            int n = 0;
            int n2 = 0;
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            int n5 = n + (n3 - 23) / 2;
            this.scrollUpButton.setBounds(n5, n2 + 4, 23, 23);
            this.scrollDownButton.setBounds(n5, n2 + n4 - 23 - 4, 23, 23);
            this.updateButtonsVisibility();
        }

        private void updateButtonsVisibility() {
            JViewport jViewport = this.getViewport();
            Rectangle rectangle = jViewport.getViewRect();
            Dimension dimension = jViewport.getViewSize();
            this.scrollUpButton.setVisible(rectangle.y > 0);
            this.scrollDownButton.setVisible(rectangle.y + rectangle.height < dimension.height);
        }

        private void scroll(int n) {
            if (n == 0) {
                return;
            }
            int n2 = n * 10;
            JViewport jViewport = this.getViewport();
            Point point = jViewport.getViewPosition();
            int n3 = jViewport.getViewSize().height - jViewport.getExtentSize().height;
            point.y = Math.max(0, Math.min(point.y + n2, n3));
            jViewport.setViewPosition(point);
        }

        public boolean isOptimizedDrawingEnabled() {
            return false;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == this.getViewport()) {
                this.updateButtonsVisibility();
            } else if (changeEvent.getSource() == this.scrollUpButton.getModel()) {
                if (this.scrollUpButton.getModel().isPressed()) {
                    this.scrollTimerDirection = -3;
                    this.scroll(this.scrollTimerDirection);
                    this.scrollTimer.restart();
                } else {
                    this.scrollTimer.stop();
                }
            } else if (changeEvent.getSource() == this.scrollDownButton.getModel()) {
                if (this.scrollDownButton.getModel().isPressed()) {
                    this.scrollTimerDirection = 3;
                    this.scroll(this.scrollTimerDirection);
                    this.scrollTimer.restart();
                } else {
                    this.scrollTimer.stop();
                }
            }
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.scroll(mouseWheelEvent.getUnitsToScroll());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.scroll(this.scrollTimerDirection);
        }
    }
}

