/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.decoration;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.decoration.Decoration;
import org.netbeans.modules.bpel.design.decoration.components.DecorationComponent;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDecorationsUpdater {
    private DesignView designView;
    private ArrayList<Component> processComponents;
    private ArrayList<Component> consumerComponents;
    private ArrayList<Component> providerComponents;

    public ComponentDecorationsUpdater(DesignView designView) {
        this.designView = designView;
    }

    public void update() {
        this.processComponents = new ArrayList();
        this.consumerComponents = new ArrayList();
        this.providerComponents = new ArrayList();
        this.buildComponentsList(this.designView.getModel().getRootPattern());
        ComponentDecorationsUpdater.syncComponentsList(this.processComponents, this.designView.getProcessView());
        ComponentDecorationsUpdater.syncComponentsList(this.consumerComponents, this.designView.getConsumersView());
        ComponentDecorationsUpdater.syncComponentsList(this.providerComponents, this.designView.getProvidersView());
    }

    private static void syncComponentsList(ArrayList<Component> arrayList, DiagramView diagramView) {
        HashSet<Component> hashSet = new HashSet<Component>();
        for (Component component : diagramView.getComponents()) {
            if (!(component instanceof DecorationComponent)) continue;
            hashSet.add(component);
        }
        for (Component component : arrayList) {
            if (hashSet.remove(component)) continue;
            diagramView.add(component);
        }
        for (Component component : hashSet) {
            diagramView.remove(component);
        }
    }

    private void buildComponentsList(Pattern pattern) {
        ArrayList<Component> arrayList;
        Decoration decoration = this.designView.getDecorationManager().getDecoration(pattern);
        DiagramView diagramView = pattern.getView();
        ArrayList<Component> arrayList2 = diagramView == this.designView.getProcessView() ? this.processComponents : (diagramView == this.designView.getConsumersView() ? this.consumerComponents : (arrayList = diagramView == this.designView.getProvidersView() ? this.providerComponents : null));
        if (arrayList != null && decoration != null && decoration.hasComponents()) {
            for (Component object : decoration.getComponents()) {
                arrayList.add(object);
            }
        }
        if (pattern instanceof CompositePattern) {
            for (Pattern pattern2 : ((CompositePattern)pattern).getNestedPatterns()) {
                this.buildComponentsList(pattern2);
            }
        }
    }
}

