/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.decoration.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import org.netbeans.modules.bpel.design.decoration.components.Icon2D;
import org.netbeans.modules.bpel.design.decoration.components.ZoomableDecorationComponent;

public class DiagramButton
extends JButton
implements ZoomableDecorationComponent {
    private double zoom = 1.0;
    private Icon2D icon2D;
    private static final int DEFAULT_WIDTH = 14;
    private static final int DEFAULT_HEIGHT = 14;
    private static final int DEFAULT_INSET = 3;
    private static final BasicStroke STROKE = new BasicStroke(1.2f);
    private static final Color DEFAULT_FILL = new Color(0xFFFFFF);
    private static final Color ARMED_FILL = new Color(0xEEEEEE);
    private static final Color ROLLOVER_STROKE = new Color(0xA9A9A9);

    public DiagramButton(Icon2D icon2D) {
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(true);
        this.setBorder(null);
        this.setFocusable(false);
        this.icon2D = icon2D;
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        double d = STROKE.getLineWidth();
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(d / 2.0, d / 2.0, (double)this.getWidth() - d, (double)this.getHeight() - d, 6.0, 6.0);
        ButtonModel buttonModel = this.getModel();
        if (buttonModel.isArmed()) {
            graphics2D.setPaint(ARMED_FILL);
            graphics2D.fill(double_);
        } else if (buttonModel.isRollover()) {
            graphics2D.setPaint(DEFAULT_FILL);
            graphics2D.fill(double_);
        }
        if (buttonModel.isRollover()) {
            graphics2D.setPaint(ROLLOVER_STROKE);
            graphics2D.setStroke(STROKE);
            graphics2D.draw(double_);
        }
        int n = 1 + (int)Math.round(this.zoom * 2.0);
        int n2 = this.getWidth() - 2 * n;
        int n3 = this.getHeight() - 2 * n;
        if (n2 > 0 && n3 > 0) {
            this.icon2D.paint(graphics, n, n, n2, n3);
        }
    }

    public void setZoom(double d) {
        this.zoom = d;
    }

    public Dimension getPreferredSize() {
        int n = (int)Math.max(1L, Math.round(this.zoom * 14.0));
        int n2 = (int)Math.max(1L, Math.round(this.zoom * 14.0));
        return new Dimension(n, n2);
    }
}

