/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.decoration.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.decoration.Decoration;
import org.netbeans.modules.bpel.design.decoration.components.DecorationComponent;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.FlowlinkTool;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.support.UniqueId;

public class LinkToolButton
extends JLabel
implements DecorationComponent,
MouseListener {
    private UniqueId omReference;
    private DesignView designView;
    private static final String ICON_PATH = "resources/envelope_small.png";
    private static final String ICON_GRAY_PATH = "resources/envelope_small_gray.png";
    private static final String ICON_RED_PATH = "resources/envelope_small_red.png";
    private static final Icon ICON = new ImageIcon(Decoration.class.getResource("resources/envelope_small.png"));
    private static final Icon ICON_GRAY = new ImageIcon(Decoration.class.getResource("resources/envelope_small_gray.png"));
    private static final Icon ICON_RED = new ImageIcon(Decoration.class.getResource("resources/envelope_small_red.png"));

    public LinkToolButton(Pattern pattern) {
        super(ICON_GRAY);
        this.omReference = pattern.getOMReference().getUID();
        this.designView = pattern.getModel().getView();
        this.setOpaque(false);
        this.setBorder(null);
        this.setBackground(null);
        this.setFocusable(false);
        this.setPreferredSize(new Dimension(16, 16));
        this.addMouseListener(this);
    }

    public Pattern getPattern() {
        BpelEntity bpelEntity = this.omReference.getModel().getEntity(this.omReference);
        return bpelEntity == null ? null : this.designView.getModel().getPattern(bpelEntity);
    }

    public void setPosition(Point point) {
        Dimension dimension = this.getPreferredSize();
        this.setBounds(point.x - dimension.width / 2, point.y - dimension.height / 2, dimension.width, dimension.height);
    }

    protected void paintComponent(Graphics graphics) {
        Point point = this.getMousePosition();
        Pattern pattern = this.getPattern();
        if (pattern == null) {
            return;
        }
        FlowlinkTool flowlinkTool = pattern.getModel().getView().getFlowLinkTool();
        if (flowlinkTool.isActive()) {
            if (flowlinkTool.isValidLocation()) {
                ICON.paintIcon(this, graphics, 0, 0);
            } else {
                ICON_RED.paintIcon(this, graphics, 0, 0);
            }
        } else {
            boolean bl;
            boolean bl2 = bl = point != null && 0 <= point.x && point.x < this.getWidth() && 0 <= point.y && point.y < this.getHeight();
            if (bl) {
                ICON.paintIcon(this, graphics, 0, 0);
            } else {
                ICON_GRAY.paintIcon(this, graphics, 0, 0);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.repaint();
    }
}

