/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.geometry;

import java.util.Collection;
import org.netbeans.modules.bpel.design.geometry.FDimension;
import org.netbeans.modules.bpel.design.geometry.FEllipse;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.geometry.FRectangle;
import org.netbeans.modules.bpel.design.geometry.FRoumb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FBounds {
    public final float x;
    public final float y;
    public final float width;
    public final float height;

    public FBounds(double d, double d2) {
        this(0.0, 0.0, d, d2);
    }

    public FBounds(double d, double d2, double d3, double d4) {
        if (d3 < 0.0) {
            this.x = (float)(d + d3);
            this.width = (float)(-d3);
        } else {
            this.x = (float)d;
            this.width = (float)d3;
        }
        if (d4 < 0.0) {
            this.y = (float)(d2 + d4);
            this.height = (float)(-d4);
        } else {
            this.y = (float)d2;
            this.height = (float)d4;
        }
    }

    public FBounds(Collection<FBounds> collection) {
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.NEGATIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        for (FBounds fBounds : collection) {
            float f5 = fBounds.x;
            float f6 = fBounds.y;
            float f7 = f5 + fBounds.width;
            float f8 = f6 + fBounds.height;
            if (f5 < f) {
                f = f5;
            }
            if (f6 < f2) {
                f2 = f6;
            }
            if (f3 < f7) {
                f3 = f7;
            }
            if (!(f4 < f8)) continue;
            f4 = f8;
        }
        if (f <= f3 && f2 <= f4) {
            this.x = f;
            this.y = f2;
            this.width = f3 - f;
            this.height = f4 - f2;
        } else {
            this.x = 0.0f;
            this.y = 0.0f;
            this.width = 0.0f;
            this.height = 0.0f;
        }
    }

    public boolean contains(double d, double d2) {
        return 0.0 <= (d -= (double)this.x) && d <= (double)this.width && 0.0 <= (d2 -= (double)this.y) && d2 <= (double)this.height;
    }

    public boolean contains(FPoint fPoint) {
        return this.contains(fPoint.x, fPoint.y);
    }

    public FPoint getPoint(double d, double d2) {
        return new FPoint((double)this.x + d * (double)this.width, (double)this.y + d2 * (double)this.height);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public FDimension getSize() {
        return new FDimension(this.width, this.height);
    }

    public double getMinX() {
        return this.x;
    }

    public double getMinY() {
        return this.y;
    }

    public double getMaxX() {
        return this.x + this.width;
    }

    public double getMaxY() {
        return this.y + this.height;
    }

    public double getCenterX() {
        return (double)this.x + (double)this.width / 2.0;
    }

    public double getCenterY() {
        return (double)this.y + (double)this.height / 2.0;
    }

    public FPoint getCenter() {
        return new FPoint((double)this.x + (double)this.width / 2.0, (double)this.y + (double)this.height / 2.0);
    }

    public FPoint getTopLeft() {
        return new FPoint(this.x, this.y);
    }

    public FPoint getTopCenter() {
        return new FPoint((double)this.x + (double)this.width / 2.0, this.y);
    }

    public FPoint getTopRight() {
        return new FPoint(this.x + this.width, this.y);
    }

    public FPoint getCenterLeft() {
        return new FPoint(this.x, (double)this.y + (double)this.height / 2.0);
    }

    public FPoint getCenterRight() {
        return new FPoint(this.x + this.width, (double)this.y + (double)this.height / 2.0);
    }

    public FPoint getBottomLeft() {
        return new FPoint(this.x, this.y + this.height);
    }

    public FPoint getBottomCenter() {
        return new FPoint((double)this.x + (double)this.width / 2.0, this.y + this.height);
    }

    public FPoint getBottomRight() {
        return new FPoint(this.x + this.width, this.y + this.height);
    }

    public boolean isIntersects(FBounds fBounds) {
        if (this.x + this.width < fBounds.x) {
            return false;
        }
        if (this.y + this.height < fBounds.y) {
            return false;
        }
        if (fBounds.x + fBounds.width < this.x) {
            return false;
        }
        return !(fBounds.y + fBounds.height < this.y);
    }

    public FBounds translate(double d, double d2) {
        return new FBounds(d + (double)this.x, d2 + (double)this.y, this.width, this.height);
    }

    public FEllipse createEllipse() {
        return new FEllipse(this.x, this.y, this.width, this.height);
    }

    public FRectangle createRectangle() {
        return new FRectangle(this.x, this.y, this.width, this.height);
    }

    public FRectangle createRectangle(double d) {
        return new FRectangle(this.x, this.y, this.width, this.height, d);
    }

    public FRoumb createRoumb() {
        return new FRoumb(this.x, this.y, this.width, this.height);
    }
}

