/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model.connections;

import java.util.Comparator;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.connections.Direction;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionComparator
implements Comparator<Connection> {
    private VisualElement visualElement;
    private Direction direction;

    public ConnectionComparator(VisualElement visualElement, Direction direction) {
        this.visualElement = visualElement;
        this.direction = direction;
    }

    @Override
    public int compare(Connection connection, Connection connection2) {
        VisualElement visualElement = connection.getSource();
        VisualElement visualElement2 = connection2.getSource();
        Direction direction = connection.getSourceDirection();
        Direction direction2 = connection2.getSourceDirection();
        if (visualElement == this.visualElement) {
            visualElement = connection.getTarget();
            direction = connection.getTargetDirection();
        }
        if (visualElement2 == this.visualElement) {
            visualElement2 = connection2.getTarget();
            direction2 = connection2.getTargetDirection();
        }
        int n = this.direction == Direction.TOP ? this.compareTop(visualElement, direction, visualElement2, direction2) : (this.direction == Direction.BOTTOM ? this.compareBottom(visualElement, direction, visualElement2, direction2) : (this.direction == Direction.LEFT ? this.compareLeft(visualElement, direction, visualElement2, direction2) : this.compareRight(visualElement, direction, visualElement2, direction2)));
        return n == 0 ? connection.getUID() - connection2.getUID() : n;
    }

    private int compareLeft(VisualElement visualElement, Direction direction, VisualElement visualElement2, Direction direction2) {
        double d;
        int n;
        double d2;
        int n2;
        if (direction == Direction.TOP) {
            n2 = 3;
            d2 = visualElement.getCenterX();
        } else if (direction == Direction.BOTTOM) {
            n2 = 1;
            d2 = -visualElement.getCenterX();
        } else {
            n2 = 2;
            d2 = visualElement.getCenterY();
        }
        if (direction2 == Direction.TOP) {
            n = 3;
            d = visualElement2.getCenterX();
        } else if (direction2 == Direction.BOTTOM) {
            n = 1;
            d = -visualElement2.getCenterX();
        } else {
            n = 2;
            d = visualElement2.getCenterY();
        }
        return n2 != n ? n2 - n : (int)Math.signum(d2 - d);
    }

    private int compareRight(VisualElement visualElement, Direction direction, VisualElement visualElement2, Direction direction2) {
        double d;
        int n;
        double d2;
        int n2;
        if (direction == Direction.TOP) {
            n2 = 3;
            d2 = -visualElement.getCenterX();
        } else if (direction == Direction.BOTTOM) {
            n2 = 1;
            d2 = visualElement.getCenterX();
        } else {
            n2 = 2;
            d2 = visualElement.getCenterY();
        }
        if (direction2 == Direction.TOP) {
            n = 3;
            d = -visualElement2.getCenterX();
        } else if (direction2 == Direction.BOTTOM) {
            n = 1;
            d = visualElement2.getCenterX();
        } else {
            n = 2;
            d = visualElement2.getCenterY();
        }
        return n2 != n ? n2 - n : (int)Math.signum(d2 - d);
    }

    private int compareTop(VisualElement visualElement, Direction direction, VisualElement visualElement2, Direction direction2) {
        double d;
        int n;
        double d2;
        int n2;
        if (direction == Direction.RIGHT) {
            n2 = 1;
            d2 = visualElement.getCenterY();
        } else if (direction == Direction.LEFT) {
            n2 = 3;
            d2 = -visualElement.getCenterY();
        } else {
            n2 = 2;
            d2 = visualElement.getCenterX();
        }
        if (direction2 == Direction.RIGHT) {
            n = 1;
            d = visualElement2.getCenterY();
        } else if (direction2 == Direction.LEFT) {
            n = 3;
            d = -visualElement2.getCenterY();
        } else {
            n = 2;
            d = visualElement2.getCenterX();
        }
        return n2 != n ? n2 - n : (int)Math.signum(d2 - d);
    }

    private int compareBottom(VisualElement visualElement, Direction direction, VisualElement visualElement2, Direction direction2) {
        double d;
        int n;
        double d2;
        int n2;
        if (direction == Direction.RIGHT) {
            n2 = 1;
            d2 = visualElement.getCenterY();
        } else if (direction == Direction.LEFT) {
            n2 = 3;
            d2 = -visualElement.getCenterY();
        } else {
            n2 = 2;
            d2 = visualElement.getCenterX();
        }
        if (direction2 == Direction.RIGHT) {
            n = 1;
            d = visualElement2.getCenterY();
        } else if (direction2 == Direction.LEFT) {
            n = 3;
            d = -visualElement2.getCenterY();
        } else {
            n = 2;
            d = visualElement2.getCenterX();
        }
        return n2 != n ? n2 - n : (int)Math.signum(d2 - d);
    }
}

