/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.selection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.DiagramSelectionListener;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.support.UniqueId;

public class EntitySelectionModel {
    private UniqueId selectedID;
    private DiagramModel model;
    private Pattern selectedPattern;
    private List<DiagramSelectionListener> listeners = new ArrayList<DiagramSelectionListener>();

    public EntitySelectionModel(DiagramModel diagramModel) {
        this.model = diagramModel;
    }

    public void addSelectionListener(DiagramSelectionListener diagramSelectionListener) {
        this.listeners.add(diagramSelectionListener);
    }

    public void removeSelectionListener(DiagramSelectionListener diagramSelectionListener) {
        this.listeners.remove(diagramSelectionListener);
    }

    public void setSelectedPattern(Pattern pattern) {
        if (pattern != null) {
            this.setSelected(pattern.getOMReference());
        } else {
            this.setSelected(null);
        }
    }

    public void setSelected(BpelEntity bpelEntity) {
        UniqueId uniqueId;
        Object object;
        while (!(bpelEntity == null || (object = this.model.getPattern(bpelEntity)) != null && ((Pattern)object).isSelectable() && ((Pattern)object).isInModel())) {
            bpelEntity = bpelEntity.getParent();
        }
        object = this.selectedID;
        UniqueId uniqueId2 = uniqueId = bpelEntity != null ? bpelEntity.getUID() : null;
        if (object != uniqueId) {
            this.selectedID = uniqueId;
            this.selectedPattern = this.getSelectedPattern();
            for (DiagramSelectionListener diagramSelectionListener : this.listeners) {
                diagramSelectionListener.selectionChanged(this.model.getEntity((UniqueId)object), bpelEntity);
            }
        }
    }

    public void fixSelection() {
        if (this.selectedID == null || this.getSelected() != null) {
            return;
        }
        CompositePattern compositePattern = this.selectedPattern != null ? this.selectedPattern.getParent() : null;
        Pattern pattern = null;
        Pattern pattern2 = null;
        if (compositePattern != null) {
            Iterator<Pattern> iterator = compositePattern.getNestedPatterns().iterator();
            while (iterator.hasNext()) {
                Pattern pattern3 = iterator.next();
                if (pattern3 == this.selectedPattern) {
                    if (!iterator.hasNext()) break;
                    pattern = iterator.next();
                    break;
                }
                pattern2 = pattern3;
            }
        }
        if (pattern != null) {
            this.setSelectedPattern(pattern);
        } else if (pattern2 != null) {
            this.setSelectedPattern(pattern2);
        } else if (compositePattern != null) {
            this.setSelectedPattern(compositePattern);
        } else {
            this.setSelectedPattern(this.model.getRootPattern());
        }
    }

    public Pattern getSelectedPattern() {
        BpelEntity bpelEntity = this.getSelected();
        return bpelEntity != null ? this.model.getPattern(bpelEntity) : null;
    }

    public UniqueId getSelectedID() {
        return this.selectedID;
    }

    public BpelEntity getSelected() {
        return this.selectedID != null ? this.model.getEntity(this.selectedID) : null;
    }

    public boolean isEmpty() {
        return this.selectedID == null;
    }

    public void clear() {
        this.setSelected(null);
    }
}

