/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.navigator;

import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.bpel.navigator.BpelNavigatorPanel;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class BpelNavigatorController {
    public static final String BPEL_SOURCE_MVPID = "bpelsource";
    public static final String BPEL_DESIGNER_MVPID = "orch-designer";

    private BpelNavigatorController() {
    }

    public static TopComponent getNavigatorTC() {
        return WindowManager.getDefault().findTopComponent("navigatorTC");
    }

    public static void switchNavigatorPanel() {
        String string = BpelNavigatorController.getMVEditorActivePanelPrefferedId();
        if (string == null) {
            return;
        }
        if (string.equals(BPEL_DESIGNER_MVPID)) {
            BpelNavigatorController.switchNavigatorPanel(true);
        }
    }

    public static void switchNavigatorPanel(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n;
                TopComponent topComponent = BpelNavigatorController.getNavigatorTC();
                if (topComponent == null) {
                    return;
                }
                JComboBox jComboBox = BpelNavigatorController.getNavigatorComboBox(topComponent);
                if (jComboBox == null) {
                    return;
                }
                Object object = jComboBox.getSelectedItem();
                if ((bl && !BpelNavigatorPanel.getUName().equals(object) || !bl && BpelNavigatorPanel.getUName().equals(object)) && (n = jComboBox.getItemCount()) > 1) {
                    jComboBox.setSelectedIndex(jComboBox.getSelectedIndex() == 0 ? 1 : 0);
                }
            }
        });
    }

    private static JComboBox getNavigatorComboBox(TopComponent topComponent) {
        Component[] componentArray;
        assert (topComponent != null);
        JComboBox jComboBox = null;
        for (Component component : componentArray = topComponent.getComponents()) {
            if (!(component instanceof JComboBox)) continue;
            jComboBox = (JComboBox)component;
            break;
        }
        return jComboBox;
    }

    private static String getMVEditorActivePanelPrefferedId() {
        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        if (multiViewHandler == null) {
            return null;
        }
        MultiViewPerspective multiViewPerspective = multiViewHandler.getSelectedPerspective();
        if (multiViewPerspective != null) {
            return multiViewPerspective.preferredID();
        }
        return null;
    }
}

