/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.navigator;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.bpel.core.BPELDataObject;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.navigator.BpelNavigatorVisualPanel;
import org.netbeans.modules.bpel.project.BpelproProject;
import org.netbeans.modules.bpel.project.ProjectCloseListener;
import org.netbeans.spi.navigator.NavigatorPanelWithUndo;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelNavigatorPanel
implements NavigatorPanelWithUndo {
    private static String navPanelName = NbBundle.getMessage(BpelNavigatorPanel.class, (String)"LBL_BPEL_LOGICAL_VIEW");
    private JComponent myPanelUI;
    private Lookup.Result<DataObject> myDObjLookupResult;
    private DataObject myDataObject;
    private PropertyChangeListener myDObjChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("valid".equals(propertyChangeEvent.getPropertyName()) && !BpelNavigatorPanel.this.myDataObject.isValid()) {
                ((BpelNavigatorVisualPanel)BpelNavigatorPanel.this.getComponent()).emptyPanel();
            }
        }
    };
    private Project myProject;
    private ProjectCloseListener myProjectCloseListener = new ProjectCloseListener(){

        public void projectClosed() {
            ((BpelNavigatorVisualPanel)BpelNavigatorPanel.this.getComponent()).emptyPanel();
        }
    };
    private final LookupListener selectionListener = new LookupListener(){

        public void resultChanged(LookupEvent lookupEvent) {
            if (BpelNavigatorPanel.this.myDObjLookupResult == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (BpelNavigatorPanel.this.myDObjLookupResult != null) {
                        BpelNavigatorPanel.this.setNewContent(BpelNavigatorPanel.this.myDObjLookupResult.allInstances());
                    }
                }
            });
        }
    };
    private BpelModel myBpelModel;

    public static String getUName() {
        return navPanelName;
    }

    public String getDisplayName() {
        return navPanelName;
    }

    public String getDisplayHint() {
        return NbBundle.getMessage(BpelNavigatorPanel.class, (String)"LBL_BPEL_LOGICAL_VIEW_TOOLTIP");
    }

    public JComponent getComponent() {
        if (this.myPanelUI == null) {
            this.myPanelUI = new BpelNavigatorVisualPanel();
        }
        return this.myPanelUI;
    }

    public void panelActivated(Lookup lookup) {
        this.myDObjLookupResult = lookup.lookup(new Lookup.Template(DataObject.class));
        assert (this.myDObjLookupResult != null);
        Collection collection = this.myDObjLookupResult.allInstances();
        if (collection == null || collection.size() != 1) {
            // empty if block
        }
        DataObject dataObject = collection == null || collection.size() != 1 ? null : (DataObject)collection.iterator().next();
        this.myDObjLookupResult.addLookupListener(this.selectionListener);
        this.selectionListener.resultChanged(null);
    }

    public void panelDeactivated() {
        if (this.myDObjLookupResult != null) {
            this.myDObjLookupResult.removeLookupListener(this.selectionListener);
            this.myDObjLookupResult = null;
        }
    }

    public Lookup getLookup() {
        return null;
    }

    private BpelModel getBpelModel(DataObject dataObject) {
        Lookup lookup = this.getLookup(dataObject);
        return lookup == null ? null : (BpelModel)lookup.lookup(BpelModel.class);
    }

    private Lookup getLookup(DataObject dataObject) {
        try {
            return dataObject != null ? dataObject.getLookup() : null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private void setNewContent(Collection<? extends DataObject> collection) {
        if (collection == null || collection.size() < 1) {
            return;
        }
        DataObject dataObject = collection.iterator().next();
        Lookup lookup = this.getLookup(dataObject);
        BpelModel bpelModel = this.getBpelModel(dataObject);
        if (bpelModel != null && this.myBpelModel != bpelModel) {
            this.myBpelModel = bpelModel;
            if (this.myDataObject != null) {
                this.myDataObject.removePropertyChangeListener(this.myDObjChangeListener);
            }
            if (this.myProject instanceof BpelproProject) {
                ((BpelproProject)this.myProject).removeProjectCloseListener(this.myProjectCloseListener);
            }
            this.myDataObject = dataObject;
            this.myDataObject.addPropertyChangeListener(this.myDObjChangeListener);
            this.myProject = this.getProject(this.myDataObject);
            if (this.myProject instanceof BpelproProject) {
                ((BpelproProject)this.myProject).addProjectCloseListener(this.myProjectCloseListener);
            }
            ((BpelNavigatorVisualPanel)this.getComponent()).navigate(lookup, this.myBpelModel);
        }
    }

    private Project getProject(DataObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        return FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
    }

    private DataObject getDataObject() {
        DataObject dataObject = null;
        if (this.myDObjLookupResult != null && this.myDObjLookupResult.allInstances() != null && !this.myDObjLookupResult.allInstances().isEmpty()) {
            dataObject = (DataObject)this.myDObjLookupResult.allInstances().iterator().next();
        }
        return dataObject;
    }

    public UndoRedo getUndoRedo() {
        DataObject dataObject = this.getDataObject();
        if (dataObject instanceof BPELDataObject) {
            return ((BPELDataObject)dataObject).getEditorSupport().getUndoManager();
        }
        return UndoRedo.NONE;
    }
}

