/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.children;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.nodes.children.BpelNodeChildren;
import org.netbeans.modules.bpel.nodes.navigator.ImportComparator;
import org.netbeans.modules.bpel.nodes.navigator.NavigatorNodeFactory;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportContainerChildren
extends BpelNodeChildren<Process> {
    public ImportContainerChildren(Process process, Lookup lookup) {
        super(process, lookup);
    }

    @Override
    public Collection getNodeKeys() {
        Process process = (Process)this.getReference();
        if (process == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Import> arrayList = new ArrayList<Import>();
        Import[] importArray = process.getImports();
        Arrays.sort(importArray, new ImportComparator(this.getLookup()));
        if (importArray != null && importArray.length > 0) {
            arrayList.addAll(Arrays.asList(importArray));
        }
        return arrayList;
    }

    @Override
    protected Node[] createNodes(Object object) {
        Node[] nodeArray;
        if (object == null) {
            return new Node[0];
        }
        NavigatorNodeFactory navigatorNodeFactory = NavigatorNodeFactory.getInstance();
        Node node = null;
        if (object instanceof Import) {
            if (this.isWsdl((Import)object)) {
                node = navigatorNodeFactory.createNode(NodeType.IMPORT_WSDL, (Object)((Import)object), this.getLookup());
            } else if (this.isSchema((Import)object)) {
                node = navigatorNodeFactory.createNode(NodeType.IMPORT_SCHEMA, (Object)((Import)object), this.getLookup());
            }
        }
        if (node == null) {
            nodeArray = new Node[]{};
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = node;
        }
        return nodeArray;
    }

    private boolean isWsdl(Import import_) {
        return import_.getImportType() != null && import_.getImportType().equals("http://schemas.xmlsoap.org/wsdl/");
    }

    private boolean isSchema(Import import_) {
        return import_.getImportType() != null && import_.getImportType().equals("http://www.w3.org/2001/XMLSchema");
    }
}

