/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.refactoring;

import org.netbeans.modules.bpel.editors.api.EditorUtil;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.xml.xam.Component;

public class Util {
    private Util() {
    }

    public static String getNodeName(BpelNode bpelNode) {
        assert (bpelNode != null);
        Object t = bpelNode.getReference();
        if (t == null || !(t instanceof BpelEntity)) {
            return bpelNode.getHtmlDisplayName();
        }
        String string = null;
        NodeType nodeType = bpelNode.getNodeType();
        switch (nodeType) {
            case BOOLEAN_EXPR: {
                string = EditorUtil.getName((Component)((BpelEntity)t));
                break;
            }
            case INVOKE: 
            case RECEIVE: 
            case REPLY: 
            case ON_EVENT: 
            case MESSAGE_HANDLER: 
            case PARTNER_LINK: {
                String string2;
                string = bpelNode.getShortDescription();
                if (string == null || !string.startsWith(nodeType.getDisplayName()) || (string2 = string.substring(nodeType.getDisplayName().length())).trim().length() <= 0) break;
                string = string2;
                break;
            }
            default: {
                string = bpelNode.getHtmlDisplayName();
            }
        }
        return string;
    }
}

