/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.nodes.actions.AddPropertyAction;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.editors.controls.BaseTablePanel;
import org.netbeans.modules.bpel.properties.editors.controls.ObjectListTableModel;
import org.netbeans.modules.bpel.properties.editors.controls.QNameTableCellRenderer;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.CorrelationProperty;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSetPropertyTablePanel
extends BaseTablePanel {
    static final long serialVersionUID = 1L;
    private CustomNodeEditor<CorrelationSet> myEditor;
    private TableColumnModel columnModel;
    private MyTableModel tableModel;

    public CSetPropertyTablePanel(CustomNodeEditor<CorrelationSet> customNodeEditor) {
        this.myEditor = customNodeEditor;
        this.createContent();
    }

    @Override
    public void createContent() {
        super.createContent();
        this.getButtonBar().btnEdit.setVisible(false);
        this.columnModel = new MyColumnModel();
        CorrelationSet correlationSet = (CorrelationSet)this.myEditor.getEditedObject();
        this.tableModel = new MyTableModel(correlationSet, this.columnModel);
        JTable jTable = new JTable(this.tableModel, this.columnModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        Dimension dimension = jTable.getPreferredSize();
        dimension.setSize(dimension.getWidth(), 100.0);
        jTable.setPreferredScrollableViewportSize(dimension);
        jTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"A11_DESCRIPTOR_CorrelationSetPropertyTable"));
        jTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"A11_NAME_CorrelationSetPropertyTable"));
        JScrollPane jScrollPane = new JScrollPane(jTable, 22, 30);
        new JLabel(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"A11_DESCRIPTOR_CorrelationSetPropertyTable")).setLabelFor(jTable);
        this.add(jScrollPane, "Center");
        this.setTableView(jTable);
    }

    @Override
    protected void doRefresh() {
    }

    @Override
    protected synchronized void addRow(ActionEvent actionEvent) {
        CorrelationSet correlationSet = (CorrelationSet)this.myEditor.getEditedObject();
        Set<CorrelationProperty> set = AddPropertyAction.chooseProperty(correlationSet, this.tableModel.getRowsList(), this.myEditor.getLookup());
        if (set != null) {
            for (CorrelationProperty correlationProperty : set) {
                if (correlationProperty == null) continue;
                this.tableModel.addRow(correlationProperty);
            }
        }
    }

    @Override
    protected synchronized void deleteRowImpl(ActionEvent actionEvent) {
        int[] nArray = this.getTableView().getSelectedRows();
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            this.tableModel.deleteRow(n);
        }
    }

    public boolean applyNewValues() {
        CorrelationSet correlationSet = (CorrelationSet)this.myEditor.getEditedObject();
        List list = this.tableModel.getRowsList();
        ArrayList<WSDLReference> arrayList = new ArrayList<WSDLReference>();
        for (CorrelationProperty correlationProperty : list) {
            WSDLReference wSDLReference = correlationSet.createWSDLReference((ReferenceableWSDLComponent)correlationProperty, CorrelationProperty.class);
            arrayList.add(wSDLReference);
        }
        correlationSet.setProperties(arrayList);
        return true;
    }

    public boolean subscribeListeners() {
        return true;
    }

    public boolean unsubscribeListeners() {
        return true;
    }

    private BpelModel getModel() {
        return (BpelModel)this.myEditor.getLookup().lookup(BpelModel.class);
    }

    public List<CorrelationProperty> getCorrProperties() {
        return this.tableModel.getRowsList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyTableModel
    extends ObjectListTableModel<CorrelationProperty> {
        private CorrelationSet corrSet;

        public MyTableModel(CorrelationSet correlationSet, TableColumnModel tableColumnModel) {
            super(tableColumnModel);
            assert (correlationSet != null);
            this.corrSet = correlationSet;
            this.reload();
        }

        @Override
        public void reload() {
            List list = this.corrSet.getProperties();
            if (list != null) {
                for (WSDLReference wSDLReference : list) {
                    CorrelationProperty correlationProperty = (CorrelationProperty)wSDLReference.get();
                    if (correlationProperty == null) continue;
                    this.addRow(correlationProperty);
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CorrelationProperty correlationProperty = (CorrelationProperty)this.getRowObject(n);
            TableColumn tableColumn = CSetPropertyTablePanel.this.columnModel.getColumn(n2);
            PropertyType propertyType = (PropertyType)((Object)tableColumn.getIdentifier());
            switch (propertyType) {
                case NAME: {
                    return correlationProperty.getName();
                }
                case CORRELATON_PROPERTY_TYPE_NAME: {
                    NamedComponentReference namedComponentReference = correlationProperty.getType();
                    return namedComponentReference != null ? namedComponentReference.getQName() : null;
                }
            }
            assert (false) : "The property: \"" + (Object)((Object)propertyType) + "\" isn't supported by the getValueAt()";
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<? extends Object> getColumnClass(int n) {
            return String.class;
        }
    }

    class MyColumnModel
    extends DefaultTableColumnModel {
        static final long serialVersionUID = 1L;

        public MyColumnModel() {
            TableColumn tableColumn = new TableColumn(0);
            tableColumn.setPreferredWidth(200);
            tableColumn.setIdentifier((Object)PropertyType.NAME);
            tableColumn.setHeaderValue(PropertyType.NAME.getDisplayName());
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(1);
            tableColumn.setCellRenderer(new QNameTableCellRenderer());
            tableColumn.setPreferredWidth(500);
            tableColumn.setIdentifier((Object)PropertyType.CORRELATON_PROPERTY_TYPE_NAME);
            tableColumn.setHeaderValue(PropertyType.CORRELATON_PROPERTY_TYPE_NAME.getDisplayName());
            this.addColumn(tableColumn);
        }
    }
}

