/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import org.netbeans.modules.bpel.editors.api.ui.valid.ErrorMessagesBundle;
import org.netbeans.modules.bpel.properties.PropertyNodeFactory;
import org.netbeans.modules.soa.ui.ExtendedLookup;
import org.netbeans.modules.soa.ui.form.ChooserLifeCycle;
import org.netbeans.modules.soa.ui.form.EditorLifeCycle;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.ValidationExtension;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.soa.ui.nodes.NodeFactory;
import org.netbeans.modules.soa.ui.nodes.NodesTreeParams;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeChooserPanel<T>
extends JPanel
implements ChooserLifeCycle<T>,
EditorLifeCycle,
ExplorerManager.Provider,
Validator.Provider,
HelpCtx.Provider,
Lookup.Provider {
    static final long serialVersionUID = 1L;
    private Lookup myLookup;
    private ExplorerManager myExplorerManager = new ExplorerManager();
    private PropertyChangeListener selectionChangeListener;
    protected Validator myValidator;

    public AbstractTreeChooserPanel() {
    }

    public AbstractTreeChooserPanel(Lookup lookup) {
        this.setLookup(lookup);
    }

    public void createContent() {
        this.selectionChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                    AbstractTreeChooserPanel.this.getValidator().revalidate(true);
                }
            }
        };
        this.getExplorerManager().addPropertyChangeListener(this.selectionChangeListener);
    }

    public boolean initControls() {
        this.getExplorerManager().setRootContext(Node.EMPTY);
        this.getExplorerManager().setRootContext(this.constructRootNode());
        this.getValidator().revalidate(true);
        return false;
    }

    protected Node constructRootNode() {
        return Node.EMPTY;
    }

    public Lookup getLookup() {
        return this.myLookup;
    }

    public void setLookup(Lookup lookup) {
        ArrayList<PropertyNodeFactory> arrayList = new ArrayList<PropertyNodeFactory>();
        NodeFactory nodeFactory = (NodeFactory)lookup.lookup(NodeFactory.class);
        if (nodeFactory == null || !nodeFactory.getClass().equals(PropertyNodeFactory.class)) {
            arrayList.add(PropertyNodeFactory.getInstance());
        }
        this.myLookup = arrayList.isEmpty() ? lookup : new ExtendedLookup(lookup, arrayList);
    }

    public ExplorerManager getExplorerManager() {
        return this.myExplorerManager;
    }

    protected void setSelectedNode(Node node) {
        if (node == null) {
            ExplorerManager explorerManager = this.getExplorerManager();
            if (explorerManager != null) {
                try {
                    explorerManager.setSelectedNodes(new Node[0]);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        } else {
            ExplorerManager explorerManager = this.getExplorerManager();
            if (explorerManager != null) {
                try {
                    explorerManager.setSelectedNodes(new Node[]{node});
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    protected void setSelectedNodes(Node[] nodeArray) {
        if (nodeArray == null) {
            ExplorerManager explorerManager = this.getExplorerManager();
            if (explorerManager != null) {
                try {
                    explorerManager.setSelectedNodes(new Node[0]);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        } else {
            ExplorerManager explorerManager = this.getExplorerManager();
            if (explorerManager != null) {
                try {
                    explorerManager.setSelectedNodes(nodeArray);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    protected Node getSelectedNode() {
        Node[] nodeArray;
        ExplorerManager explorerManager = this.getExplorerManager();
        if (explorerManager != null && (nodeArray = explorerManager.getSelectedNodes()) != null && nodeArray.length > 0) {
            return nodeArray[0];
        }
        return null;
    }

    protected Node[] getSelectedNodes() {
        ExplorerManager explorerManager = this.getExplorerManager();
        if (explorerManager != null) {
            Node[] nodeArray = explorerManager.getSelectedNodes();
            return nodeArray;
        }
        return null;
    }

    protected JPanel createTreeWrapper(TreeView treeView) {
        TreeWrapperPanel treeWrapperPanel = new TreeWrapperPanel();
        treeWrapperPanel.add((Component)treeView, "Center");
        return treeWrapperPanel;
    }

    public synchronized Validator getValidator() {
        if (this.myValidator == null) {
            this.myValidator = this.createValidator();
        }
        return this.myValidator;
    }

    protected Validator createValidator() {
        return new DefaultChooserValidator();
    }

    public boolean unsubscribeListeners() {
        return true;
    }

    public boolean subscribeListeners() {
        return true;
    }

    public boolean afterClose() {
        this.myLookup = null;
        return true;
    }

    public boolean applyNewValues() throws Exception {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    protected class TreeWrapperPanel
    extends JPanel
    implements Lookup.Provider {
        private Lookup lookup;

        public TreeWrapperPanel() {
            this.setLayout(new BorderLayout());
            this.lookup = ExplorerUtils.createLookup((ExplorerManager)AbstractTreeChooserPanel.this.getExplorerManager(), (ActionMap)new ActionMap());
            this.setFocusable(false);
        }

        public Lookup getLookup() {
            return this.lookup;
        }
    }

    protected class DefaultChooserValidator
    extends DefaultValidator {
        public DefaultChooserValidator() {
            super((Component)AbstractTreeChooserPanel.this, ErrorMessagesBundle.class);
        }

        protected String getIncorrectNodeSelectionReasonKey() {
            return "ERR_INCORRECT_TREE_SELECTION";
        }

        public void doFastValidation() {
            Validator validator;
            ValidationExtension validationExtension;
            Node node = AbstractTreeChooserPanel.this.getSelectedNode();
            if (node == null) {
                this.addReasonKey(Validator.Severity.ERROR, this.getIncorrectNodeSelectionReasonKey());
                return;
            }
            NodesTreeParams nodesTreeParams = (NodesTreeParams)AbstractTreeChooserPanel.this.getLookup().lookup(NodesTreeParams.class);
            if (nodesTreeParams == null) {
                return;
            }
            Class<?> clazz = node.getClass();
            boolean bl = false;
            ValidationExtension validationExtension2 = validationExtension = nodesTreeParams.getTargetNodeClasses();
            int n = ((Class[])validationExtension2).length;
            for (int i = 0; i < n; ++i) {
                Class clazz2 = validationExtension2[i];
                if (!clazz2.isAssignableFrom(clazz)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.addReasonKey(Validator.Severity.ERROR, this.getIncorrectNodeSelectionReasonKey());
            }
            if ((validationExtension2 = (ValidationExtension)AbstractTreeChooserPanel.this.getLookup().lookup(ValidationExtension.class)) != null && (validator = validationExtension2.getExtensionValidator()) != null) {
                validator.doFastValidation();
                if (validator.hasReasons(Validator.Severity.ERROR)) {
                    this.addReasons(validator.getReasons(Validator.Severity.ERROR));
                }
            }
        }

        public void doDetailedValidation() {
            Validator validator;
            super.doDetailedValidation();
            ValidationExtension validationExtension = (ValidationExtension)AbstractTreeChooserPanel.this.getLookup().lookup(ValidationExtension.class);
            if (validationExtension != null && (validator = validationExtension.getExtensionValidator()) != null) {
                validator.doDetailedValidation();
                if (validator.hasReasons(null)) {
                    this.addReasons(validator.getReasons());
                }
            }
        }
    }
}

